/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.extras;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.util.HashMap;
import java.util.Map;
import org.jibx.runtime.EnumSet;
import org.jibx.runtime.IAliasable;
import org.jibx.runtime.IMarshaller;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshaller;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class HashMapperStringToSchemaType
implements IMarshaller,
IUnmarshaller,
IAliasable {
    private static final String SIZE_ATTRIBUTE_NAME = "size";
    private static final String ENTRY_ELEMENT_NAME = "entry";
    private static final String KEY_ATTRIBUTE_NAME = "key";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String XSI_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSD_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema";
    private static final String[] SCHEMA_NAMESPACE_URIS = new String[]{"http://www.w3.org/2001/XMLSchema-instance", "http://www.w3.org/2001/XMLSchema"};
    private static final String XSI_NAMESPACE_PREFIX = "xsi";
    private static final String XSD_NAMESPACE_PREFIX = "xsd";
    private static final String[] SCHEMA_NAMESPACE_PREFIXES = new String[]{"xsi", "xsd"};
    private static final String XSD_PREFIX_LEAD = "xsd:";
    private static final int DEFAULT_SIZE = 10;
    public static final int BOOLEAN_TYPE = 0;
    public static final int BYTE_TYPE = 1;
    public static final int DOUBLE_TYPE = 2;
    public static final int FLOAT_TYPE = 3;
    public static final int INT_TYPE = 4;
    public static final int LONG_TYPE = 5;
    public static final int SHORT_TYPE = 6;
    public static final int DATETIME_TYPE = 7;
    public static final int DECIMAL_TYPE = 8;
    public static final int INTEGER_TYPE = 9;
    public static final int BYTERRAY_TYPE = 10;
    public static final int STRING_TYPE = 11;
    public static final int DATE_TYPE = 12;
    public static final int TIME_TYPE = 13;
    private static final EnumSet s_javaTypesEnum = new EnumSet(0, new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.util.Date", "java.math.BigDecimal", "java.math.BigInteger", "byte[]", "java.lang.String", "java.sql.Date", "java.sql.Time"});
    private static final EnumSet s_schemaTypesEnum = new EnumSet(0, new String[]{"boolean", "byte", "double", "float", "int", "long", "short", "dateTime", "decimal", "integer", "base64Binary", "string", "date", "time"});
    private String m_uri;
    private int m_index;
    private String m_name;

    public HashMapperStringToSchemaType() {
        this.m_uri = null;
        this.m_index = 0;
        this.m_name = "hashmap";
    }

    public HashMapperStringToSchemaType(String uri, int index2, String name) {
        this.m_uri = uri;
        this.m_index = index2;
        this.m_name = name;
    }

    @Override
    public boolean isExtension(String mapname) {
        return false;
    }

    @Override
    public void marshal(Object obj, IMarshallingContext ictx) throws JiBXException {
        if (!(obj instanceof Map)) {
            throw new JiBXException("Invalid object type for marshaller");
        }
        if (!(ictx instanceof MarshallingContext)) {
            throw new JiBXException("Invalid object type for marshaller");
        }
        MarshallingContext ctx = (MarshallingContext)ictx;
        IXMLWriter xwrite = ctx.getXmlWriter();
        int ixsi = xwrite.getNamespaces().length;
        String[][] extens = xwrite.getExtensionNamespaces();
        if (extens != null) {
            for (int i = 0; i < extens.length; ++i) {
                ixsi += extens[i].length;
            }
        }
        xwrite.pushExtensionNamespaces(SCHEMA_NAMESPACE_URIS);
        Map map2 = (Map)obj;
        ctx.startTagNamespaces(this.m_index, this.m_name, new int[]{ixsi, ixsi + 1}, SCHEMA_NAMESPACE_PREFIXES).attribute(this.m_index, SIZE_ATTRIBUTE_NAME, map2.size()).closeStartContent();
        for (Map.Entry entry2 : map2.entrySet()) {
            Object value2 = entry2.getValue();
            if (value2 == null) continue;
            ctx.startTagAttributes(this.m_index, ENTRY_ELEMENT_NAME);
            ctx.attribute(this.m_index, KEY_ATTRIBUTE_NAME, entry2.getKey().toString());
            String tname = value2.getClass().getName();
            int type = s_javaTypesEnum.getValue(tname);
            if (type < 0) {
                throw new JiBXException("Value of type " + tname + " with key " + entry2.getKey() + " is not a supported type");
            }
            ctx.attribute(ixsi, TYPE_ATTRIBUTE_NAME, XSD_PREFIX_LEAD + s_schemaTypesEnum.getName(type));
            ctx.closeStartContent();
            switch (type) {
                case 0: {
                    ctx.content(Utility.serializeBoolean((boolean)((Boolean)value2)));
                    break;
                }
                case 1: {
                    ctx.content(Utility.serializeByte((Byte)value2));
                    break;
                }
                case 2: {
                    ctx.content(Utility.serializeDouble((Double)value2));
                    break;
                }
                case 3: {
                    ctx.content(Utility.serializeFloat(((Float)value2).floatValue()));
                    break;
                }
                case 4: {
                    ctx.content((Integer)value2);
                    break;
                }
                case 5: {
                    ctx.content(Utility.serializeLong((Long)value2));
                    break;
                }
                case 6: {
                    ctx.content(Utility.serializeShort((Short)value2));
                    break;
                }
                case 7: {
                    ctx.content(Utility.serializeDateTime((java.util.Date)value2));
                    break;
                }
                case 12: {
                    ctx.content(Utility.serializeSqlDate((Date)value2));
                    break;
                }
                case 13: {
                    ctx.content(Utility.serializeSqlTime((Time)value2));
                    break;
                }
                case 10: {
                    ctx.content(Utility.serializeBase64((byte[])value2));
                    break;
                }
                case 8: 
                case 9: 
                case 11: {
                    ctx.content(value2.toString());
                }
            }
            ctx.endTag(this.m_index, ENTRY_ELEMENT_NAME);
        }
        ctx.endTag(this.m_index, this.m_name);
        xwrite.popExtensionNamespaces();
    }

    @Override
    public boolean isPresent(IUnmarshallingContext ctx) throws JiBXException {
        return ctx.isAt(this.m_uri, this.m_name);
    }

    @Override
    public Object unmarshal(Object obj, IUnmarshallingContext ictx) throws JiBXException {
        UnmarshallingContext ctx = (UnmarshallingContext)ictx;
        if (!ctx.isAt(this.m_uri, this.m_name)) {
            ctx.throwStartTagNameError(this.m_uri, this.m_name);
        }
        int nscnt = ctx.getActiveNamespaceCount();
        String xsdlead = null;
        for (int i = nscnt - 1; i >= 0; --i) {
            String prefix;
            String uri = ctx.getActiveNamespaceUri(i);
            if (!XSD_NAMESPACE_URI.equals(uri) || "".equals(prefix = ctx.getActiveNamespacePrefix(i))) continue;
            xsdlead = prefix + ':';
            break;
        }
        if (xsdlead == null) {
            throw new JiBXException("Missing required schema namespace declaration");
        }
        int size2 = ctx.attributeInt(this.m_uri, SIZE_ATTRIBUTE_NAME, 10);
        HashMap<String, Object> map2 = (HashMap<String, Object>)obj;
        if (map2 == null) {
            map2 = new HashMap<String, Object>(size2);
        }
        ctx.parsePastStartTag(this.m_uri, this.m_name);
        String tdflt = xsdlead + "string";
        while (ctx.isAt(this.m_uri, ENTRY_ELEMENT_NAME)) {
            String key = ctx.attributeText(this.m_uri, KEY_ATTRIBUTE_NAME);
            String tname = ctx.attributeText(XSI_NAMESPACE_URI, TYPE_ATTRIBUTE_NAME, tdflt);
            int type = -1;
            if (tname.startsWith(xsdlead)) {
                type = s_schemaTypesEnum.getValue(tname.substring(xsdlead.length()));
            }
            if (type < 0) {
                throw new JiBXException("Value of type " + tname + " with key " + key + " is not a supported type");
            }
            String text2 = ctx.parseElementText(this.m_uri, ENTRY_ELEMENT_NAME);
            Object value2 = null;
            switch (type) {
                case 0: {
                    value2 = Utility.parseBoolean(text2) ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 1: {
                    value2 = new Byte(Utility.parseByte(text2));
                    break;
                }
                case 2: {
                    value2 = new Double(Utility.parseDouble(text2));
                    break;
                }
                case 3: {
                    value2 = new Float(Utility.parseFloat(text2));
                    break;
                }
                case 4: {
                    value2 = new Integer(Utility.parseInt(text2));
                    break;
                }
                case 5: {
                    value2 = new Long(Utility.parseLong(text2));
                    break;
                }
                case 6: {
                    value2 = new Short(Utility.parseShort(text2));
                    break;
                }
                case 7: {
                    value2 = Utility.deserializeDateTime(text2);
                    break;
                }
                case 12: {
                    value2 = Utility.deserializeSqlDate(text2);
                    break;
                }
                case 13: {
                    value2 = Utility.deserializeSqlTime(text2);
                    break;
                }
                case 10: {
                    value2 = Utility.deserializeBase64(text2);
                    break;
                }
                case 8: {
                    value2 = new BigDecimal(text2);
                    break;
                }
                case 9: {
                    value2 = new BigInteger(text2);
                    break;
                }
                case 11: {
                    value2 = text2;
                }
            }
            map2.put(key, value2);
        }
        ctx.parsePastEndTag(this.m_uri, this.m_name);
        return map2;
    }
}

