/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.extras;

import java.util.HashMap;
import java.util.Map;
import org.jibx.runtime.IAliasable;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshaller;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshaller;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class HashMapperStringToComplex
implements IMarshaller,
IUnmarshaller,
IAliasable {
    private static final int DEFAULT_SIZE = 10;
    private String m_uri;
    private int m_index;
    private String m_name;

    public HashMapperStringToComplex() {
        this.m_uri = null;
        this.m_index = 0;
        this.m_name = "hashmap";
    }

    public HashMapperStringToComplex(String uri, int index2, String name) {
        this.m_uri = uri;
        this.m_index = index2;
        this.m_name = name;
    }

    protected String getSizeAttributeName() {
        return "size";
    }

    protected String getEntryElementName() {
        return "entry";
    }

    protected String getKeyAttributeName() {
        return "key";
    }

    @Override
    public boolean isExtension(String mapname) {
        return false;
    }

    @Override
    public void marshal(Object obj, IMarshallingContext ictx) throws JiBXException {
        if (!(obj instanceof Map)) {
            throw new JiBXException("Invalid object type for marshaller");
        }
        if (!(ictx instanceof MarshallingContext)) {
            throw new JiBXException("Invalid object type for marshaller");
        }
        MarshallingContext ctx = (MarshallingContext)ictx;
        Map map2 = (Map)obj;
        ctx.startTagAttributes(this.m_index, this.m_name).attribute(this.m_index, this.getSizeAttributeName(), map2.size()).closeStartContent();
        for (Map.Entry entry2 : map2.entrySet()) {
            ctx.startTagAttributes(this.m_index, this.getEntryElementName());
            ctx.attribute(this.m_index, this.getKeyAttributeName(), entry2.getKey().toString());
            ctx.closeStartContent();
            if (entry2.getValue() instanceof IMarshallable) {
                ((IMarshallable)entry2.getValue()).marshal(ctx);
                ctx.endTag(this.m_index, this.getEntryElementName());
                continue;
            }
            throw new JiBXException("Mapped value is not marshallable");
        }
        ctx.endTag(this.m_index, this.m_name);
    }

    @Override
    public boolean isPresent(IUnmarshallingContext ctx) throws JiBXException {
        return ctx.isAt(this.m_uri, this.m_name);
    }

    @Override
    public Object unmarshal(Object obj, IUnmarshallingContext ictx) throws JiBXException {
        UnmarshallingContext ctx = (UnmarshallingContext)ictx;
        if (!ctx.isAt(this.m_uri, this.m_name)) {
            ctx.throwStartTagNameError(this.m_uri, this.m_name);
        }
        int size2 = ctx.attributeInt(this.m_uri, this.getSizeAttributeName(), 10);
        HashMap<String, Object> map2 = (HashMap<String, Object>)obj;
        if (map2 == null) {
            map2 = new HashMap<String, Object>(size2);
        }
        ctx.parsePastStartTag(this.m_uri, this.m_name);
        while (ctx.isAt(this.m_uri, this.getEntryElementName())) {
            String key = ctx.attributeText(this.m_uri, this.getKeyAttributeName(), null);
            ctx.parsePastStartTag(this.m_uri, this.getEntryElementName());
            Object value2 = ctx.unmarshalElement();
            map2.put(key, value2);
            ctx.parsePastEndTag(this.m_uri, this.getEntryElementName());
        }
        ctx.parsePastEndTag(this.m_uri, this.m_name);
        return map2;
    }
}

