/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.EclipseLinkLogRecord;
import org.eclipse.persistence.logging.LogFormatter;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.sessions.Session;

public class JavaLog
extends AbstractSessionLog {
    public static final String TOPLINK_NAMESPACE = "org.eclipse.persistence";
    protected static final String LOGGING_LOCALIZATION_STRING = "org.eclipse.persistence.internal.localization.i18n.LoggingLocalizationResource";
    protected static final String TRACE_LOCALIZATION_STRING = "org.eclipse.persistence.internal.localization.i18n.TraceLocalizationResource";
    public static final String DEFAULT_TOPLINK_NAMESPACE = "org.eclipse.persistence.default";
    public static final String SESSION_TOPLINK_NAMESPACE = "org.eclipse.persistence.session";
    private static final Level[] levels = new Level[]{Level.ALL, Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
    private Map nameSpaceMap = new HashMap();
    private String sessionNameSpace;
    private Logger sessionLogger;
    private Map categoryloggers = new HashMap();

    public JavaLog() {
        this.addLogger(DEFAULT_TOPLINK_NAMESPACE, DEFAULT_TOPLINK_NAMESPACE);
    }

    protected void addLogger(String loggerCategory, String loggerNameSpace) {
        this.categoryloggers.put(loggerCategory, Logger.getLogger(loggerNameSpace));
    }

    public Map getCategoryLoggers() {
        return this.categoryloggers;
    }

    @Override
    public int getLevel(String category) {
        Logger logger = this.getLogger(category);
        while (logger != null && logger.getLevel() == null) {
            logger = logger.getParent();
        }
        if (logger == null) {
            return 8;
        }
        int logLevel = logger.getLevel().intValue();
        int i = 0;
        while (i < levels.length) {
            if (logLevel == levels[i].intValue()) {
                return i;
            }
            ++i;
        }
        return 8;
    }

    @Override
    public void setLevel(final int level, String category) {
        final Logger logger = this.getLogger(category);
        if (logger == null) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                logger.setLevel(JavaLog.this.getJavaLevel(level));
                return null;
            }
        });
    }

    @Override
    public void setWriter(OutputStream fileOutputStream) {
        StreamHandler sh = new StreamHandler(fileOutputStream, new LogFormatter());
        ((Logger)this.categoryloggers.get(DEFAULT_TOPLINK_NAMESPACE)).addHandler(sh);
        if (this.sessionLogger != null) {
            this.sessionLogger.addHandler(sh);
        }
    }

    protected String getNameSpaceString(String category) {
        if (this.session == null) {
            return DEFAULT_TOPLINK_NAMESPACE;
        }
        if (category == null || category.length() == 0) {
            return this.sessionNameSpace;
        }
        return (String)this.nameSpaceMap.get(category);
    }

    protected Logger getLogger(String category) {
        if (this.session == null) {
            return (Logger)this.categoryloggers.get(DEFAULT_TOPLINK_NAMESPACE);
        }
        if (category == null || category.length() == 0 || !this.categoryloggers.containsKey(category)) {
            return (Logger)this.categoryloggers.get(this.sessionNameSpace);
        }
        Logger logger = (Logger)this.categoryloggers.get(category);
        assert (logger != null);
        return logger;
    }

    @Override
    public void setSession(Session session) {
        super.setSession(session);
        if (session != null) {
            String sessionName = session.getName();
            this.sessionNameSpace = sessionName != null && sessionName.length() != 0 ? "org.eclipse.persistence.session." + sessionName : DEFAULT_TOPLINK_NAMESPACE;
            this.addLogger(this.sessionNameSpace, this.sessionNameSpace);
            int i = 0;
            while (i < loggerCatagories.length) {
                String loggerCategory = loggerCatagories[i];
                String loggerNameSpace = String.valueOf(this.sessionNameSpace) + "." + loggerCategory;
                this.nameSpaceMap.put(loggerCategory, loggerNameSpace);
                this.addLogger(loggerCategory, loggerNameSpace);
                ++i;
            }
        }
    }

    protected Level getJavaLevel(int level) {
        return levels[level];
    }

    @Override
    public boolean shouldLog(int level, String category) {
        Logger logger = this.getLogger(category);
        return logger.isLoggable(this.getJavaLevel(level));
    }

    @Override
    public void log(SessionLogEntry entry2) {
        if (!this.shouldLog(entry2.getLevel(), entry2.getNameSpace())) {
            return;
        }
        Logger logger = this.getLogger(entry2.getNameSpace());
        Level javaLevel = this.getJavaLevel(entry2.getLevel());
        this.internalLog(entry2, javaLevel, logger);
    }

    protected void internalLog(SessionLogEntry entry2, Level javaLevel, Logger logger) {
        EclipseLinkLogRecord lr = new EclipseLinkLogRecord(javaLevel, this.formatMessage(entry2));
        lr.setSourceClassName(null);
        lr.setSourceMethodName(null);
        lr.setLoggerName(this.getNameSpaceString(entry2.getNameSpace()));
        if (this.shouldPrintSession()) {
            lr.setSessionString(this.getSessionString(entry2.getSession()));
        }
        if (this.shouldPrintConnection()) {
            lr.setConnection(entry2.getConnection());
        }
        lr.setThrown(entry2.getException());
        lr.setShouldLogExceptionStackTrace(this.shouldLogExceptionStackTrace());
        lr.setShouldPrintDate(this.shouldPrintDate());
        lr.setShouldPrintThread(this.shouldPrintThread());
        logger.log(lr);
    }

    @Override
    public void throwing(Throwable throwable) {
        this.getLogger(null).throwing(null, null, throwable);
    }

    @Override
    public Object clone() {
        JavaLog cloneLog = (JavaLog)super.clone();
        return cloneLog;
    }
}

