/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.dag;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.CycleDetector;
import org.codehaus.plexus.util.dag.TopologicalSorter;
import org.codehaus.plexus.util.dag.Vertex;

public class DAG
implements Cloneable,
Serializable {
    private Map vertexMap = new HashMap();
    private List vertexList = new ArrayList();

    public List getVerticies() {
        return this.vertexList;
    }

    public Set getLabels() {
        Set retValue = this.vertexMap.keySet();
        return retValue;
    }

    public Vertex addVertex(String label) {
        Vertex retValue = null;
        if (this.vertexMap.containsKey(label)) {
            retValue = (Vertex)this.vertexMap.get(label);
        } else {
            retValue = new Vertex(label);
            this.vertexMap.put(label, retValue);
            this.vertexList.add(retValue);
        }
        return retValue;
    }

    public void addEdge(String from2, String to2) throws CycleDetectedException {
        Vertex v1 = this.addVertex(from2);
        Vertex v2 = this.addVertex(to2);
        this.addEdge(v1, v2);
    }

    public void addEdge(Vertex from2, Vertex to2) throws CycleDetectedException {
        from2.addEdgeTo(to2);
        to2.addEdgeFrom(from2);
        List cycle = CycleDetector.introducesCycle(to2);
        if (cycle != null) {
            this.removeEdge(from2, to2);
            String msg = "Edge between '" + from2 + "' and '" + to2 + "' introduces to cycle in the graph";
            throw new CycleDetectedException(msg, cycle);
        }
    }

    public void removeEdge(String from2, String to2) {
        Vertex v1 = this.addVertex(from2);
        Vertex v2 = this.addVertex(to2);
        this.removeEdge(v1, v2);
    }

    public void removeEdge(Vertex from2, Vertex to2) {
        from2.removeEdgeTo(to2);
        to2.removeEdgeFrom(from2);
    }

    public Vertex getVertex(String label) {
        Vertex retValue = (Vertex)this.vertexMap.get(label);
        return retValue;
    }

    public boolean hasEdge(String label1, String label2) {
        Vertex v1 = this.getVertex(label1);
        Vertex v2 = this.getVertex(label2);
        boolean retValue = v1.getChildren().contains(v2);
        return retValue;
    }

    public List getChildLabels(String label) {
        Vertex vertex = this.getVertex(label);
        return vertex.getChildLabels();
    }

    public List getParentLabels(String label) {
        Vertex vertex = this.getVertex(label);
        return vertex.getParentLabels();
    }

    public Object clone() throws CloneNotSupportedException {
        Object retValue = super.clone();
        return retValue;
    }

    public boolean isConnected(String label) {
        Vertex vertex = this.getVertex(label);
        boolean retValue = vertex.isConnected();
        return retValue;
    }

    public List getSuccessorLabels(String label) {
        ArrayList<String> retValue;
        Vertex vertex = this.getVertex(label);
        if (vertex.isLeaf()) {
            retValue = new ArrayList<String>(1);
            retValue.add(label);
        } else {
            retValue = TopologicalSorter.sort(vertex);
        }
        return retValue;
    }
}

