/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.composition;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.composition.AbstractComponentComposer;
import org.codehaus.plexus.component.composition.CompositionException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.ReflectionUtils;

public class FieldComponentComposer
extends AbstractComponentComposer {
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$lang$Object;

    public List assembleComponent(Object component, ComponentDescriptor componentDescriptor, PlexusContainer container) throws CompositionException {
        LinkedList retValue = new LinkedList();
        List requirements = componentDescriptor.getRequirements();
        Iterator i = requirements.iterator();
        while (i.hasNext()) {
            ComponentRequirement requirement = (ComponentRequirement)i.next();
            Field field2 = this.findMatchingField(component, componentDescriptor, requirement, container);
            if (!field2.isAccessible()) {
                ((AccessibleObject)field2).setAccessible(true);
            }
            List descriptors = this.assignRequirementToField(component, field2, container, requirement);
            retValue.addAll(descriptors);
        }
        return retValue;
    }

    private List assignRequirementToField(Object component, Field field2, PlexusContainer container, ComponentRequirement requirement) throws CompositionException {
        try {
            ArrayList<ComponentDescriptor> retValue;
            String role = requirement.getRole();
            if (field2.getType().isArray()) {
                List dependencies = container.lookupList(role);
                Object[] array = (Object[])Array.newInstance(field2.getType(), dependencies.size());
                retValue = container.getComponentDescriptorList(role);
                field2.set(component, dependencies.toArray(array));
            } else if ((class$java$util$Map == null ? (class$java$util$Map = FieldComponentComposer.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(field2.getType())) {
                Map dependencies = container.lookupMap(role);
                retValue = container.getComponentDescriptorList(role);
                field2.set(component, dependencies);
            } else if ((class$java$util$List == null ? (class$java$util$List = FieldComponentComposer.class$("java.util.List")) : class$java$util$List).isAssignableFrom(field2.getType())) {
                List dependencies = container.lookupList(role);
                retValue = container.getComponentDescriptorList(role);
                field2.set(component, dependencies);
            } else if ((class$java$util$Set == null ? (class$java$util$Set = FieldComponentComposer.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(field2.getType())) {
                Map dependencies = container.lookupMap(role);
                retValue = container.getComponentDescriptorList(role);
                field2.set(component, dependencies.entrySet());
            } else {
                String key = requirement.getRequirementKey();
                Object dependency = container.lookup(key);
                ComponentDescriptor componentDescriptor = container.getComponentDescriptor(key);
                retValue = new ArrayList<ComponentDescriptor>(1);
                retValue.add(componentDescriptor);
                field2.set(component, dependency);
            }
            return retValue;
        }
        catch (IllegalArgumentException e) {
            throw new CompositionException("Composition failed for the field " + field2.getName() + " " + "in object of type " + component.getClass().getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new CompositionException("Composition failed for the field " + field2.getName() + " " + "in object of type " + component.getClass().getName(), e);
        }
        catch (ComponentLookupException e) {
            throw new CompositionException("Composition failed of field " + field2.getName() + " " + "in object of type " + component.getClass().getName() + " because the requirement " + requirement + " was missing", e);
        }
    }

    protected Field findMatchingField(Object component, ComponentDescriptor componentDescriptor, ComponentRequirement requirement, PlexusContainer container) throws CompositionException {
        String fieldName = requirement.getFieldName();
        Field field2 = null;
        if (fieldName != null) {
            field2 = this.getFieldByName(component, fieldName, componentDescriptor);
        } else {
            Class<?> fieldClass = null;
            try {
                fieldClass = container != null ? container.getContainerRealm().loadClass(requirement.getRole()) : Thread.currentThread().getContextClassLoader().loadClass(requirement.getRole());
            }
            catch (ClassNotFoundException e) {
                StringBuffer msg = new StringBuffer("Component Composition failed for component: ");
                msg.append(componentDescriptor.getHumanReadableKey());
                msg.append(": Requirement class: '");
                msg.append(requirement.getRole());
                msg.append("' not found.");
                throw new CompositionException(msg.toString(), e);
            }
            field2 = this.getFieldByType(component, fieldClass, componentDescriptor);
        }
        return field2;
    }

    protected Field getFieldByName(Object component, String fieldName, ComponentDescriptor componentDescriptor) throws CompositionException {
        Field field2 = ReflectionUtils.getFieldByNameIncludingSuperclasses(fieldName, component.getClass());
        if (field2 == null) {
            StringBuffer msg = new StringBuffer("Component Composition failed. No field of name: '");
            msg.append(fieldName);
            msg.append("' exists in component: ");
            msg.append(componentDescriptor.getHumanReadableKey());
            throw new CompositionException(msg.toString());
        }
        return field2;
    }

    protected Field getFieldByTypeIncludingSuperclasses(Class componentClass, Class type, ComponentDescriptor componentDescriptor) throws CompositionException {
        List fields = this.getFieldsByTypeIncludingSuperclasses(componentClass, type, componentDescriptor);
        if (fields.size() == 0) {
            return null;
        }
        if (fields.size() == 1) {
            return (Field)fields.get(0);
        }
        throw new CompositionException("There are several fields of type '" + type + "', " + "use 'field-name' to select the correct field.");
    }

    protected List getFieldsByTypeIncludingSuperclasses(Class componentClass, Class type, ComponentDescriptor componentDescriptor) throws CompositionException {
        Class<?> arrayType = Array.newInstance(type, 0).getClass();
        Field[] fields = componentClass.getDeclaredFields();
        ArrayList<Field> foundFields = new ArrayList<Field>();
        for (int i = 0; i < fields.length; ++i) {
            Class<?> fieldType = fields[i].getType();
            if (!fieldType.isAssignableFrom(type) && !fieldType.isAssignableFrom(arrayType)) continue;
            foundFields.add(fields[i]);
        }
        if (componentClass.getSuperclass() != (class$java$lang$Object == null ? (class$java$lang$Object = FieldComponentComposer.class$("java.lang.Object")) : class$java$lang$Object)) {
            List superFields = this.getFieldsByTypeIncludingSuperclasses(componentClass.getSuperclass(), type, componentDescriptor);
            foundFields.addAll(superFields);
        }
        return foundFields;
    }

    protected Field getFieldByType(Object component, Class type, ComponentDescriptor componentDescriptor) throws CompositionException {
        Field field2 = this.getFieldByTypeIncludingSuperclasses(component.getClass(), type, componentDescriptor);
        if (field2 == null) {
            StringBuffer msg = new StringBuffer("Component composition failed. No field of type: '");
            msg.append(type);
            msg.append("' exists in class '");
            msg.append(component.getClass().getName());
            msg.append("'.");
            if (componentDescriptor != null) {
                msg.append(" Component: ");
                msg.append(componentDescriptor.getHumanReadableKey());
            }
            throw new CompositionException(msg.toString());
        }
        return field2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

