/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.ZipException;
import org.codehaus.plexus.archiver.ArchiveFile;
import org.codehaus.plexus.archiver.zip.ExtraFieldUtils;
import org.codehaus.plexus.archiver.zip.ZipExtraField;
import org.codehaus.plexus.archiver.zip.ZipShort;

public class ZipEntry
extends java.util.zip.ZipEntry
implements Cloneable,
ArchiveFile.Entry {
    private static final int PLATFORM_UNIX = 3;
    private static final int PLATFORM_FAT = 0;
    private int internalAttributes = 0;
    private int platform = 0;
    private long externalAttributes = 0L;
    private Vector extraFields = new Vector();
    private String name = null;
    private Long compressedSize = null;
    private static Method setCompressedSizeMethod = null;
    private static final Object lockReflection = new Object();
    private static boolean triedToGetMethod = false;

    public ZipEntry(String name) {
        super(name);
    }

    public ZipEntry(java.util.zip.ZipEntry entry2) throws ZipException {
        super(entry2.getName());
        byte[] extra;
        long crc;
        long cSize;
        this.setComment(entry2.getComment());
        this.setMethod(entry2.getMethod());
        this.setTime(entry2.getTime());
        long size2 = entry2.getSize();
        if (size2 > 0L) {
            this.setSize(size2);
        }
        if ((cSize = entry2.getCompressedSize()) > 0L) {
            this.setComprSize(cSize);
        }
        if ((crc = entry2.getCrc()) > 0L) {
            this.setCrc(crc);
        }
        if ((extra = entry2.getExtra()) != null) {
            this.setExtraFields(ExtraFieldUtils.parse(extra));
        } else {
            this.setExtra();
        }
    }

    public ZipEntry(ZipEntry entry2) throws ZipException {
        this((java.util.zip.ZipEntry)entry2);
        this.setInternalAttributes(entry2.getInternalAttributes());
        this.setExternalAttributes(entry2.getExternalAttributes());
        this.setExtraFields(entry2.getExtraFields());
    }

    protected ZipEntry() {
        super("");
    }

    public Object clone() {
        try {
            long crc;
            long cSize;
            ZipEntry e = (ZipEntry)super.clone();
            e.setName(this.getName());
            e.setComment(this.getComment());
            e.setMethod(this.getMethod());
            e.setTime(this.getTime());
            long size2 = this.getSize();
            if (size2 > 0L) {
                e.setSize(size2);
            }
            if ((cSize = this.getCompressedSize()) > 0L) {
                e.setComprSize(cSize);
            }
            if ((crc = this.getCrc()) > 0L) {
                e.setCrc(crc);
            }
            e.extraFields = (Vector)this.extraFields.clone();
            e.setInternalAttributes(this.getInternalAttributes());
            e.setExternalAttributes(this.getExternalAttributes());
            e.setExtraFields(this.getExtraFields());
            return e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public int getInternalAttributes() {
        return this.internalAttributes;
    }

    public void setInternalAttributes(int value2) {
        this.internalAttributes = value2;
    }

    public long getExternalAttributes() {
        return this.externalAttributes;
    }

    public void setExternalAttributes(long value2) {
        this.externalAttributes = value2;
    }

    public void setUnixMode(int mode) {
        this.setExternalAttributes(mode << 16 | ((mode & 0x80) == 0 ? 1 : 0) | (this.isDirectory() ? 16 : 0));
        this.platform = 3;
    }

    public int getUnixMode() {
        return (int)(this.getExternalAttributes() >> 16 & 0xFFFFL);
    }

    public int getPlatform() {
        return this.platform;
    }

    protected void setPlatform(int platform) {
        this.platform = platform;
    }

    public void setExtraFields(ZipExtraField[] fields) {
        this.extraFields.removeAllElements();
        for (int i = 0; i < fields.length; ++i) {
            this.extraFields.addElement(fields[i]);
        }
        this.setExtra();
    }

    public ZipExtraField[] getExtraFields() {
        Object[] result2 = new ZipExtraField[this.extraFields.size()];
        this.extraFields.copyInto(result2);
        return result2;
    }

    public void addExtraField(ZipExtraField ze) {
        ZipShort type = ze.getHeaderId();
        boolean done = false;
        for (int i = 0; !done && i < this.extraFields.size(); ++i) {
            if (!((ZipExtraField)this.extraFields.elementAt(i)).getHeaderId().equals(type)) continue;
            this.extraFields.setElementAt(ze, i);
            done = true;
        }
        if (!done) {
            this.extraFields.addElement(ze);
        }
        this.setExtra();
    }

    public void removeExtraField(ZipShort type) {
        boolean done = false;
        for (int i = 0; !done && i < this.extraFields.size(); ++i) {
            if (!((ZipExtraField)this.extraFields.elementAt(i)).getHeaderId().equals(type)) continue;
            this.extraFields.removeElementAt(i);
            done = true;
        }
        if (!done) {
            throw new NoSuchElementException();
        }
        this.setExtra();
    }

    public void setExtra(byte[] extra) throws RuntimeException {
        try {
            this.setExtraFields(ExtraFieldUtils.parse(extra));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void setExtra() {
        super.setExtra(ExtraFieldUtils.mergeLocalFileDataData(this.getExtraFields()));
    }

    public byte[] getLocalFileDataExtra() {
        byte[] extra = this.getExtra();
        return extra != null ? extra : new byte[]{};
    }

    public byte[] getCentralDirectoryExtra() {
        return ExtraFieldUtils.mergeCentralDirectoryData(this.getExtraFields());
    }

    public void setComprSize(long size2) {
        if (ZipEntry.haveSetCompressedSize()) {
            ZipEntry.performSetCompressedSize(this, size2);
        } else {
            this.compressedSize = new Long(size2);
        }
    }

    public long getCompressedSize() {
        if (this.compressedSize != null) {
            return this.compressedSize;
        }
        return super.getCompressedSize();
    }

    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    public boolean isDirectory() {
        return this.getName().endsWith("/");
    }

    protected void setName(String name) {
        this.name = name;
    }

    private static boolean haveSetCompressedSize() {
        ZipEntry.checkSCS();
        return setCompressedSizeMethod != null;
    }

    private static void performSetCompressedSize(ZipEntry ze, long size2) {
        Object[] s2 = new Long[]{new Long(size2)};
        try {
            setCompressedSizeMethod.invoke((Object)ze, s2);
        }
        catch (InvocationTargetException ite) {
            Throwable nested = ite.getTargetException();
            throw new RuntimeException("Exception setting the compressed size of " + ze + ": " + nested.getMessage());
        }
        catch (Throwable other) {
            throw new RuntimeException("Exception setting the compressed size of " + ze + ": " + other.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkSCS() {
        if (!triedToGetMethod) {
            Object object = lockReflection;
            synchronized (object) {
                triedToGetMethod = true;
                try {
                    setCompressedSizeMethod = java.util.zip.ZipEntry.class.getMethod("setCompressedSize", Long.TYPE);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
    }

    public long getLastModificationTime() {
        return this.getTime();
    }
}

