/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.util.zip.CRC32;
import java.util.zip.ZipException;
import org.codehaus.plexus.archiver.UnixStat;
import org.codehaus.plexus.archiver.zip.ZipExtraField;
import org.codehaus.plexus.archiver.zip.ZipLong;
import org.codehaus.plexus.archiver.zip.ZipShort;

public class AsiExtraField
implements ZipExtraField,
UnixStat,
Cloneable {
    private static final ZipShort HEADER_ID = new ZipShort(30062);
    private int mode = 0;
    private int uid = 0;
    private int gid = 0;
    private String link = "";
    private boolean dirFlag = false;
    private CRC32 crc = new CRC32();

    public ZipShort getHeaderId() {
        return HEADER_ID;
    }

    public ZipShort getLocalFileDataLength() {
        return new ZipShort(14 + this.getLinkedFile().getBytes().length);
    }

    public ZipShort getCentralDirectoryLength() {
        return this.getLocalFileDataLength();
    }

    public byte[] getLocalFileDataData() {
        byte[] data2 = new byte[this.getLocalFileDataLength().getValue() - 4];
        System.arraycopy(new ZipShort(this.getMode()).getBytes(), 0, data2, 0, 2);
        byte[] linkArray = this.getLinkedFile().getBytes();
        System.arraycopy(new ZipLong(linkArray.length).getBytes(), 0, data2, 2, 4);
        System.arraycopy(new ZipShort(this.getUserId()).getBytes(), 0, data2, 6, 2);
        System.arraycopy(new ZipShort(this.getGroupId()).getBytes(), 0, data2, 8, 2);
        System.arraycopy(linkArray, 0, data2, 10, linkArray.length);
        this.crc.reset();
        this.crc.update(data2);
        long checksum = this.crc.getValue();
        byte[] result2 = new byte[data2.length + 4];
        System.arraycopy(new ZipLong(checksum).getBytes(), 0, result2, 0, 4);
        System.arraycopy(data2, 0, result2, 4, data2.length);
        return result2;
    }

    public byte[] getCentralDirectoryData() {
        return this.getLocalFileDataData();
    }

    public void setUserId(int uid) {
        this.uid = uid;
    }

    public int getUserId() {
        return this.uid;
    }

    public void setGroupId(int gid) {
        this.gid = gid;
    }

    public int getGroupId() {
        return this.gid;
    }

    public void setLinkedFile(String name) {
        this.link = name;
        this.mode = this.getMode(this.mode);
    }

    public String getLinkedFile() {
        return this.link;
    }

    public boolean isLink() {
        return this.getLinkedFile().length() != 0;
    }

    public void setMode(int mode) {
        this.mode = this.getMode(mode);
    }

    public int getMode() {
        return this.mode;
    }

    public void setDirectory(boolean dirFlag) {
        this.dirFlag = dirFlag;
        this.mode = this.getMode(this.mode);
    }

    public boolean isDirectory() {
        return this.dirFlag && !this.isLink();
    }

    public void parseFromLocalFileData(byte[] data2, int offset, int length) throws ZipException {
        long givenChecksum = new ZipLong(data2, offset).getValue();
        byte[] tmp = new byte[length - 4];
        System.arraycopy(data2, offset + 4, tmp, 0, length - 4);
        this.crc.reset();
        this.crc.update(tmp);
        long realChecksum = this.crc.getValue();
        if (givenChecksum != realChecksum) {
            throw new ZipException("bad CRC checksum " + Long.toHexString(givenChecksum) + " instead of " + Long.toHexString(realChecksum));
        }
        int newMode = new ZipShort(tmp, 0).getValue();
        byte[] linkArray = new byte[(int)new ZipLong(tmp, 2).getValue()];
        this.uid = new ZipShort(tmp, 6).getValue();
        this.gid = new ZipShort(tmp, 8).getValue();
        if (linkArray.length == 0) {
            this.link = "";
        } else {
            System.arraycopy(tmp, 10, linkArray, 0, linkArray.length);
            this.link = new String(linkArray);
        }
        this.setDirectory((newMode & 0x4000) != 0);
        this.setMode(newMode);
    }

    protected int getMode(int mode) {
        int type = 32768;
        if (this.isLink()) {
            type = 40960;
        } else if (this.isDirectory()) {
            type = 16384;
        }
        return type | mode & 0xFFF;
    }
}

