/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.ear;

import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.ResourceUtils;
import org.codehaus.plexus.archiver.zip.ZipOutputStream;

public class EarArchiver
extends JarArchiver {
    private File deploymentDescriptor;
    private boolean descriptorAdded;

    public EarArchiver() {
        this.archiveType = "ear";
    }

    public void setAppxml(File descr) throws ArchiverException {
        this.deploymentDescriptor = descr;
        if (!this.deploymentDescriptor.exists()) {
            throw new ArchiverException("Deployment descriptor: " + this.deploymentDescriptor + " does not exist.");
        }
        this.addFile(descr, "META-INF/application.xml");
    }

    public void addArchive(File fileName) throws ArchiverException {
        this.addDirectory(fileName.getParentFile(), "/", new String[]{fileName.getName()}, null);
    }

    public void addArchives(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, "/", includes, excludes);
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, ArchiverException {
        if (this.deploymentDescriptor == null && !this.isInUpdateMode()) {
            throw new ArchiverException("appxml attribute is required");
        }
        super.initZipOutputStream(zOut);
    }

    protected void zipFile(ArchiveEntry entry2, ZipOutputStream zOut, String vPath, int mode) throws IOException, ArchiverException {
        if (vPath.equalsIgnoreCase("META-INF/application.xml")) {
            if (this.deploymentDescriptor == null || !ResourceUtils.isCanonicalizedSame(entry2.getResource(), this.deploymentDescriptor) || this.descriptorAdded) {
                this.getLogger().warn("Warning: selected " + this.archiveType + " files include a META-INF/application.xml which will be ignored " + "(please use appxml attribute to " + this.archiveType + " task)");
            } else {
                super.zipFile(entry2, zOut, vPath);
                this.descriptorAdded = true;
            }
        } else {
            super.zipFile(entry2, zOut, vPath);
        }
    }

    protected void cleanUp() {
        this.descriptorAdded = false;
        super.cleanUp();
    }
}

