/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.bzip2;

import java.io.IOException;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.bzip2.BZip2Compressor;

public class BZip2Archiver
extends AbstractArchiver {
    private BZip2Compressor compressor = new BZip2Compressor();

    public void execute() throws ArchiverException, IOException {
        if (!this.checkForced()) {
            return;
        }
        ResourceIterator iter2 = this.getResources();
        ArchiveEntry entry2 = iter2.next();
        if (iter2.hasNext()) {
            throw new ArchiverException("There is more than one file in input.");
        }
        this.compressor.setSource(entry2.getResource());
        this.compressor.setDestFile(this.getDestFile());
        this.compressor.compress();
    }

    public boolean isSupportingForced() {
        return true;
    }

    protected void close() {
        this.compressor.close();
    }

    protected String getArchiveType() {
        return "bzip2";
    }
}

