/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.classworlds;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import org.codehaus.classworlds.BytesURLStreamHandler;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.classworlds.Entry;
import org.codehaus.classworlds.NoSuchRealmException;
import org.codehaus.classworlds.RealmClassLoader;
import org.codehaus.classworlds.UberJarRealmClassLoader;
import org.codehaus.classworlds.UrlUtils;

public class DefaultClassRealm
implements ClassRealm {
    private ClassWorld world;
    private String id;
    private TreeSet imports;
    private ClassLoader foreignClassLoader;
    private RealmClassLoader classLoader;
    private ClassRealm parent;

    public DefaultClassRealm(ClassWorld world, String id) {
        this(world, id, null);
    }

    public DefaultClassRealm(ClassWorld world, String id, ClassLoader foreignClassLoader) {
        this.world = world;
        this.id = id;
        this.imports = new TreeSet();
        if (foreignClassLoader != null) {
            this.foreignClassLoader = foreignClassLoader;
        }
        this.classLoader = "true".equals(System.getProperty("classworlds.bootstrapped")) ? new UberJarRealmClassLoader(this) : new RealmClassLoader(this);
    }

    public URL[] getConstituents() {
        return this.classLoader.getURLs();
    }

    public ClassRealm getParent() {
        return this.parent;
    }

    public void setParent(ClassRealm parent) {
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    public ClassWorld getWorld() {
        return this.world;
    }

    public void importFrom(String realmId, String packageName) throws NoSuchRealmException {
        this.imports.add(new Entry(this.getWorld().getRealm(realmId), packageName));
        this.imports.add(new Entry(this.getWorld().getRealm(realmId), packageName.replace('.', '/')));
    }

    public void addConstituent(URL constituent) {
        this.classLoader.addConstituent(constituent);
    }

    public void addConstituent(String constituent, byte[] b) throws ClassNotFoundException {
        try {
            File file;
            if (constituent.lastIndexOf(46) != -1) {
                File path = new File("byteclass/" + constituent.substring(0, constituent.lastIndexOf(46) + 1).replace('.', File.separatorChar));
                file = new File(path, constituent.substring(constituent.lastIndexOf(46) + 1) + ".class");
            } else {
                File path = new File("byteclass/");
                file = new File(path, constituent + ".class");
            }
            this.addConstituent(new URL(null, file.toURL().toExternalForm(), new BytesURLStreamHandler(b)));
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Couldn't load byte stream.", e);
        }
    }

    public ClassRealm locateSourceRealm(String classname) {
        Iterator iterator2 = this.imports.iterator();
        while (iterator2.hasNext()) {
            Entry entry2 = (Entry)iterator2.next();
            if (!entry2.matches(classname)) continue;
            return entry2.getRealm();
        }
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassRealm createChildRealm(String id) throws DuplicateRealmException {
        ClassRealm childRealm = this.getWorld().newRealm(id);
        childRealm.setParent(this);
        return childRealm;
    }

    /*
     * Loose catch block
     */
    public Class loadClass(String name) throws ClassNotFoundException {
        ClassRealm sourceRealm;
        block10: {
            if (name.startsWith("org.codehaus.classworlds.")) {
                return this.getWorld().loadClass(name);
            }
            if (this.foreignClassLoader != null) {
                try {
                    return this.foreignClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if ((sourceRealm = this.locateSourceRealm(name)) != this) break block10;
            return this.classLoader.loadClassDirect(name);
            {
                catch (ClassNotFoundException e) {
                    if (this.getParent() != null) {
                        return this.getParent().loadClass(name);
                    }
                    throw e;
                }
            }
        }
        try {
            return sourceRealm.loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            return this.classLoader.loadClassDirect(name);
        }
    }

    public URL getResource(String name) {
        URL resource = null;
        name = UrlUtils.normalizeUrlPath(name);
        if (this.foreignClassLoader != null && (resource = this.foreignClassLoader.getResource(name)) != null) {
            return resource;
        }
        ClassRealm sourceRealm = this.locateSourceRealm(name);
        if (sourceRealm == this) {
            resource = this.classLoader.getResourceDirect(name);
        } else {
            resource = sourceRealm.getResource(name);
            if (resource == null) {
                resource = this.classLoader.getResourceDirect(name);
            }
        }
        if (resource == null && this.getParent() != null) {
            resource = this.getParent().getResource(name);
        }
        return resource;
    }

    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        InputStream is = null;
        if (url != null) {
            try {
                is = url.openStream();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return is;
    }

    public Enumeration findResources(String name) throws IOException {
        ClassRealm sourceRealm;
        name = UrlUtils.normalizeUrlPath(name);
        Vector<URL> resources = new Vector<URL>();
        if (this.foreignClassLoader != null) {
            Enumeration<URL> res = this.foreignClassLoader.getResources(name);
            while (res.hasMoreElements()) {
                resources.addElement(res.nextElement());
            }
        }
        if ((sourceRealm = this.locateSourceRealm(name)) != this) {
            Enumeration res = sourceRealm.findResources(name);
            while (res.hasMoreElements()) {
                resources.addElement((URL)res.nextElement());
            }
        }
        Enumeration direct = this.classLoader.findResourcesDirect(name);
        while (direct.hasMoreElements()) {
            resources.addElement((URL)direct.nextElement());
        }
        if (this.parent != null) {
            Enumeration parent = this.getParent().findResources(name);
            while (parent.hasMoreElements()) {
                resources.addElement((URL)parent.nextElement());
            }
        }
        return resources.elements();
    }

    public void display() {
        ClassRealm cr = this;
        System.out.println("-----------------------------------------------------");
        this.showUrls(cr);
        while (cr.getParent() != null) {
            System.out.println("\n");
            cr = cr.getParent();
            this.showUrls(cr);
        }
        System.out.println("-----------------------------------------------------");
    }

    private void showUrls(ClassRealm classRealm) {
        System.out.println("this realm = " + classRealm.getId());
        URL[] urls = classRealm.getConstituents();
        for (int i = 0; i < urls.length; ++i) {
            System.out.println("urls[" + i + "] = " + urls[i]);
        }
        System.out.println("Number of imports: " + this.imports.size());
        Iterator i = this.imports.iterator();
        while (i.hasNext()) {
            System.out.println("import: " + i.next());
        }
    }
}

