/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.storm.spout.Scheme;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.Utils;

public class StringScheme
implements Scheme {
    private static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    public static final String STRING_SCHEME_KEY = "str";

    public List<Object> deserialize(ByteBuffer bytes) {
        return new Values(new Object[]{StringScheme.deserializeString(bytes)});
    }

    public static String deserializeString(ByteBuffer string2) {
        if (string2.hasArray()) {
            int base = string2.arrayOffset();
            return new String(string2.array(), base + string2.position(), string2.remaining());
        }
        return new String(Utils.toByteArray((ByteBuffer)string2), UTF8_CHARSET);
    }

    public Fields getOutputFields() {
        return new Fields(new String[]{STRING_SCHEME_KEY});
    }
}

