/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.util.ClassLoaderRepository;
import org.apache.bcel.util.Repository;
import org.apache.bcel.util.SyntheticRepository;

@Deprecated
public class ClassLoader
extends java.lang.ClassLoader {
    private static final String BCEL_TOKEN = "$$BCEL$$";
    public static final String[] DEFAULT_IGNORED_PACKAGES = new String[]{"java.", "javax.", "sun."};
    private final Hashtable<String, Class<?>> classes = new Hashtable();
    private final String[] ignored_packages;
    private Repository repository = SyntheticRepository.getInstance();

    public ClassLoader() {
        this(DEFAULT_IGNORED_PACKAGES);
    }

    public ClassLoader(java.lang.ClassLoader deferTo) {
        super(deferTo);
        this.ignored_packages = DEFAULT_IGNORED_PACKAGES;
        this.repository = new ClassLoaderRepository(deferTo);
    }

    public ClassLoader(String[] ignored_packages) {
        this.ignored_packages = ignored_packages;
    }

    public ClassLoader(java.lang.ClassLoader deferTo, String[] ignored_packages) {
        this(ignored_packages);
        this.repository = new ClassLoaderRepository(deferTo);
    }

    @Override
    protected Class<?> loadClass(String class_name, boolean resolve2) throws ClassNotFoundException {
        Class<?> cl = null;
        cl = this.classes.get(class_name);
        if (cl == null) {
            for (String ignored_package : this.ignored_packages) {
                if (!class_name.startsWith(ignored_package)) continue;
                cl = this.getParent().loadClass(class_name);
                break;
            }
            if (cl == null) {
                JavaClass clazz = null;
                if (class_name.contains(BCEL_TOKEN)) {
                    clazz = this.createClass(class_name);
                } else {
                    clazz = this.repository.loadClass(class_name);
                    if (clazz != null) {
                        clazz = this.modifyClass(clazz);
                    } else {
                        throw new ClassNotFoundException(class_name);
                    }
                }
                if (clazz != null) {
                    byte[] bytes = clazz.getBytes();
                    cl = this.defineClass(class_name, bytes, 0, bytes.length);
                } else {
                    cl = Class.forName(class_name);
                }
            }
            if (resolve2) {
                this.resolveClass(cl);
            }
        }
        this.classes.put(class_name, cl);
        return cl;
    }

    protected JavaClass modifyClass(JavaClass clazz) {
        return clazz;
    }

    protected JavaClass createClass(String class_name) {
        int index2 = class_name.indexOf(BCEL_TOKEN);
        String real_name = class_name.substring(index2 + BCEL_TOKEN.length());
        JavaClass clazz = null;
        try {
            byte[] bytes = Utility.decode(real_name, true);
            ClassParser parser = new ClassParser(new ByteArrayInputStream(bytes), "foo");
            clazz = parser.parse();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        ConstantPool cp = clazz.getConstantPool();
        ConstantClass cl = (ConstantClass)cp.getConstant(clazz.getClassNameIndex(), (byte)7);
        ConstantUtf8 name = (ConstantUtf8)cp.getConstant(cl.getNameIndex(), (byte)1);
        name.setBytes(class_name.replace('.', '/'));
        return clazz;
    }
}

