/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConst;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.VariableLengthInstruction;

public final class PUSH
implements CompoundInstruction,
VariableLengthInstruction,
InstructionConstants {
    private Instruction instruction;

    public PUSH(ConstantPoolGen cp, int value2) {
        this.instruction = value2 >= -1 && value2 <= 5 ? InstructionConst.getInstruction(3 + value2) : (Instruction.isValidByte(value2) ? new BIPUSH((byte)value2) : (Instruction.isValidShort(value2) ? new SIPUSH((short)value2) : new LDC(cp.addInteger(value2))));
    }

    public PUSH(ConstantPoolGen cp, boolean value2) {
        this.instruction = InstructionConst.getInstruction(3 + (value2 ? 1 : 0));
    }

    public PUSH(ConstantPoolGen cp, float value2) {
        this.instruction = (double)value2 == 0.0 ? InstructionConst.FCONST_0 : ((double)value2 == 1.0 ? InstructionConst.FCONST_1 : ((double)value2 == 2.0 ? InstructionConst.FCONST_2 : new LDC(cp.addFloat(value2))));
    }

    public PUSH(ConstantPoolGen cp, long value2) {
        this.instruction = value2 == 0L ? InstructionConst.LCONST_0 : (value2 == 1L ? InstructionConst.LCONST_1 : new LDC2_W(cp.addLong(value2)));
    }

    public PUSH(ConstantPoolGen cp, double value2) {
        this.instruction = value2 == 0.0 ? InstructionConst.DCONST_0 : (value2 == 1.0 ? InstructionConst.DCONST_1 : new LDC2_W(cp.addDouble(value2)));
    }

    public PUSH(ConstantPoolGen cp, String value2) {
        this.instruction = value2 == null ? InstructionConst.ACONST_NULL : new LDC(cp.addString(value2));
    }

    public PUSH(ConstantPoolGen cp, ObjectType value2) {
        this.instruction = value2 == null ? InstructionConst.ACONST_NULL : new LDC(cp.addClass(value2));
    }

    public PUSH(ConstantPoolGen cp, Number value2) {
        if (value2 instanceof Integer || value2 instanceof Short || value2 instanceof Byte) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (int)value2.intValue()).instruction;
        } else if (value2 instanceof Double) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (double)value2.doubleValue()).instruction;
        } else if (value2 instanceof Float) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (float)value2.floatValue()).instruction;
        } else if (value2 instanceof Long) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (long)value2.longValue()).instruction;
        } else {
            throw new ClassGenException("What's this: " + value2);
        }
    }

    public PUSH(ConstantPoolGen cp, Character value2) {
        this(cp, (int)value2.charValue());
    }

    public PUSH(ConstantPoolGen cp, Boolean value2) {
        this(cp, (boolean)value2);
    }

    @Override
    public final InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }

    public final Instruction getInstruction() {
        return this.instruction;
    }

    public String toString() {
        return this.instruction + " (PUSH)";
    }
}

