/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.regex.BMPString;
import net.sf.saxon.regex.LatinString;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.UntypedAtomicValue;

public class StringValue
extends AtomicValue {
    public static final StringValue EMPTY_STRING = new StringValue(LatinString.EMPTY);
    public static final StringValue SINGLE_SPACE = new StringValue(LatinString.SINGLE_SPACE);
    public static final StringValue TRUE = new StringValue(new LatinString("true"));
    public static final StringValue FALSE = new StringValue(new LatinString("false"));
    protected CharSequence value;

    protected StringValue() {
        this.value = "";
        this.typeLabel = BuiltInAtomicType.STRING;
    }

    public StringValue(CharSequence value2) {
        this.value = value2 == null ? "" : value2;
        this.typeLabel = BuiltInAtomicType.STRING;
    }

    public StringValue(CharSequence value2, AtomicType typeLabel) {
        this.value = value2;
        this.typeLabel = typeLabel;
    }

    public synchronized void setContainsNoSurrogates() {
        if (!(this.value instanceof BMPString) && !(this.value instanceof LatinString)) {
            this.value = new BMPString(this.value);
        }
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        StringValue v = new StringValue(this.value);
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.STRING;
    }

    public static StringValue makeStringValue(CharSequence value2) {
        if (value2 == null || value2.length() == 0) {
            return EMPTY_STRING;
        }
        return new StringValue(value2);
    }

    public static boolean isEmpty(CharSequence string2) {
        if (string2 instanceof String) {
            return ((String)string2).isEmpty();
        }
        if (string2 instanceof UnicodeString) {
            return ((UnicodeString)string2).uLength() == 0;
        }
        return string2.length() == 0;
    }

    public final CharSequence getPrimitiveStringValue() {
        return this.value;
    }

    public final void setStringValueCS(CharSequence value2) {
        this.value = value2;
    }

    public synchronized int getStringLength() {
        if (!(this.value instanceof UnicodeString)) {
            this.makeUnicodeString();
        }
        return ((UnicodeString)this.value).uLength();
    }

    public synchronized int getStringLengthUpperBound() {
        if (this.value instanceof UnicodeString) {
            return ((UnicodeString)this.value).uLength();
        }
        return this.value.length();
    }

    public synchronized UnicodeString getUnicodeString() {
        if (!(this.value instanceof UnicodeString)) {
            this.makeUnicodeString();
        }
        return (UnicodeString)this.value;
    }

    private void makeUnicodeString() {
        this.value = UnicodeString.makeUnicodeString(this.value);
    }

    public static int getStringLength(CharSequence s2) {
        if (s2 instanceof UnicodeString) {
            return ((UnicodeString)s2).uLength();
        }
        int n = 0;
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c >= '\ud800' && c <= '\udbff') continue;
            ++n;
        }
        return n;
    }

    public boolean isZeroLength() {
        return this.value.length() == 0;
    }

    public boolean containsSurrogatePairs() {
        return UnicodeString.containsSurrogatePairs(this.value);
    }

    public boolean isKnownToContainNoSurrogates() {
        return this.value instanceof BMPString || this.value instanceof LatinString;
    }

    public synchronized UnfailingIterator iterateCharacters() {
        if (this.value instanceof UnicodeString) {
            return new UnicodeCharacterIterator((UnicodeString)this.value);
        }
        return new CharacterIterator(this.value);
    }

    public static int[] expand(CharSequence s2) {
        int[] array = new int[StringValue.getStringLength(s2)];
        int o = 0;
        for (int i = 0; i < s2.length(); ++i) {
            int charval;
            int c = s2.charAt(i);
            if (c >= 55296 && c <= 56319) {
                charval = (c - 55296) * 1024 + (s2.charAt(i + 1) - 56320) + 65536;
                ++i;
            } else {
                charval = c;
            }
            array[o++] = charval;
        }
        return array;
    }

    public static CharSequence contract(int[] codes, int used) {
        FastStringBuffer sb = new FastStringBuffer(codes.length);
        for (int i = 0; i < used; ++i) {
            sb.appendWideChar(codes[i]);
        }
        return sb;
    }

    public AtomicMatchKey getXPathComparable(boolean ordered, StringCollator collator, int implicitTimezone) {
        return collator.getCollationKey(this.value);
    }

    public boolean equals(Object other) {
        throw new ClassCastException("equals on StringValue is not allowed");
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean codepointEquals(StringValue other) {
        if (this.value instanceof String) {
            return ((String)this.value).contentEquals(other.value);
        }
        if (other.value instanceof String) {
            return ((String)other.value).contentEquals(this.value);
        }
        if (this.value instanceof UnicodeString) {
            if (!(other.value instanceof UnicodeString)) {
                other.makeUnicodeString();
            }
            return this.value.equals(other.value);
        }
        return this.value.length() == other.value.length() && this.value.toString().equals(other.value.toString());
    }

    public boolean effectiveBooleanValue() {
        return this.value.length() > 0;
    }

    public String toString() {
        return "\"" + this.value + '\"';
    }

    public Comparable getSchemaComparable() {
        return this.getStringValue();
    }

    public boolean isIdentical(AtomicValue v) {
        return v instanceof StringValue && this instanceof AnyURIValue == v instanceof AnyURIValue && this instanceof UntypedAtomicValue == v instanceof UntypedAtomicValue && this.codepointEquals((StringValue)v);
    }

    public static String diagnosticDisplay(String s2) {
        FastStringBuffer fsb = new FastStringBuffer(s2.length());
        int len = s2.length();
        for (int i = 0; i < len; ++i) {
            char c = s2.charAt(i);
            if (c >= ' ' && c <= '~') {
                fsb.append(c);
                continue;
            }
            fsb.append("\\u");
            for (int shift = 12; shift >= 0; shift -= 4) {
                fsb.append("0123456789ABCDEF".charAt(c >> shift & 0xF));
            }
        }
        return fsb.toString();
    }

    public static final class UnicodeCharacterIterator
    implements UnfailingIterator {
        UnicodeString uValue;
        int inpos = 0;

        public UnicodeCharacterIterator(UnicodeString value2) {
            this.uValue = value2;
        }

        public Int64Value next() {
            if (this.inpos < this.uValue.uLength()) {
                return new Int64Value(this.uValue.uCharAt(this.inpos++));
            }
            return null;
        }

        public void close() {
        }

        public int getProperties() {
            return 0;
        }
    }

    public static final class CharacterIterator
    implements UnfailingIterator {
        int inpos = 0;
        private CharSequence value;

        public CharacterIterator(CharSequence value2) {
            this.value = value2;
        }

        public Int64Value next() {
            if (this.inpos < this.value.length()) {
                int current;
                int c;
                if ((c = this.value.charAt(this.inpos++)) >= 55296 && c <= 56319) {
                    try {
                        current = (c - 55296) * 1024 + (this.value.charAt(this.inpos++) - 56320) + 65536;
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        System.err.println("Invalid surrogate at end of string");
                        System.err.println(StringValue.diagnosticDisplay(this.value.toString()));
                        e.printStackTrace();
                        throw e;
                    }
                } else {
                    current = c;
                }
                return new Int64Value(current);
            }
            return null;
        }

        public void close() {
        }

        public int getProperties() {
            return 0;
        }
    }
}

