/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.functions.FormatNumber;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.Whitespace;

public abstract class IntegerValue
extends DecimalValue {
    public static final Int64Value MINUS_ONE = new Int64Value(-1L);
    public static final Int64Value ZERO = new Int64Value(0L);
    public static final Int64Value PLUS_ONE = new Int64Value(1L);
    public static final Int64Value MAX_LONG = new Int64Value(Long.MAX_VALUE);
    public static final Int64Value MIN_LONG = new Int64Value(Long.MIN_VALUE);
    private static long NO_LIMIT = -9999L;
    private static long MAX_UNSIGNED_LONG = -9998L;
    private static long[] ranges = new long[]{533L, NO_LIMIT, NO_LIMIT, 536L, Long.MIN_VALUE, Long.MAX_VALUE, 537L, Integer.MIN_VALUE, Integer.MAX_VALUE, 538L, -32768L, 32767L, 539L, -128L, 127L, 540L, 0L, NO_LIMIT, 541L, 1L, NO_LIMIT, 534L, NO_LIMIT, 0L, 535L, NO_LIMIT, -1L, 542L, 0L, MAX_UNSIGNED_LONG, 543L, 0L, 0xFFFFFFFFL, 544L, 0L, 65535L, 545L, 0L, 255L};

    public static IntegerValue makeIntegerValue(BigInteger value2) {
        if (value2.compareTo(BigIntegerValue.MAX_LONG) > 0 || value2.compareTo(BigIntegerValue.MIN_LONG) < 0) {
            return new BigIntegerValue(value2);
        }
        return Int64Value.makeIntegerValue(value2.longValue());
    }

    public static ConversionResult makeIntegerValue(double value2) {
        if (Double.isNaN(value2)) {
            ValidationFailure err2 = new ValidationFailure("Cannot convert double NaN to an integer");
            err2.setErrorCode("FOCA0002");
            return err2;
        }
        if (Double.isInfinite(value2)) {
            ValidationFailure err3 = new ValidationFailure("Cannot convert double INF to an integer");
            err3.setErrorCode("FOCA0002");
            return err3;
        }
        if (value2 > 9.223372036854776E18 || value2 < -9.223372036854776E18) {
            if (value2 == Math.floor(value2)) {
                return new BigIntegerValue(FormatNumber.adjustToDecimal(value2, 2).toBigInteger());
            }
            return new BigIntegerValue(new BigDecimal(value2).toBigInteger());
        }
        return Int64Value.makeIntegerValue((long)value2);
    }

    public static ConversionResult makeIntegerValue(DoubleValue doubleValue) {
        double value2 = doubleValue.getDoubleValue();
        return IntegerValue.makeIntegerValue(value2);
    }

    public abstract ValidationFailure convertToSubType(BuiltInAtomicType var1, boolean var2);

    public abstract ValidationFailure validateAgainstSubType(BuiltInAtomicType var1);

    public static boolean checkRange(long value2, BuiltInAtomicType type) {
        int fp = type.getFingerprint();
        for (int i = 0; i < ranges.length; i += 3) {
            if (ranges[i] != (long)fp) continue;
            long min2 = ranges[i + 1];
            if (min2 != NO_LIMIT && value2 < min2) {
                return false;
            }
            long max2 = ranges[i + 2];
            return max2 == NO_LIMIT || max2 == MAX_UNSIGNED_LONG || value2 <= max2;
        }
        throw new IllegalArgumentException("No range information found for integer subtype " + type.getDescription());
    }

    public static IntegerValue getMinInclusive(BuiltInAtomicType type) {
        int fp = type.getFingerprint();
        for (int i = 0; i < ranges.length; i += 3) {
            if (ranges[i] != (long)fp) continue;
            long min2 = ranges[i + 1];
            if (min2 == NO_LIMIT) {
                return null;
            }
            return Int64Value.makeIntegerValue(min2);
        }
        return null;
    }

    public static IntegerValue getMaxInclusive(BuiltInAtomicType type) {
        int fp = type.getFingerprint();
        for (int i = 0; i < ranges.length; i += 3) {
            if (ranges[i] != (long)fp) continue;
            long max2 = ranges[i + 2];
            if (max2 == NO_LIMIT) {
                return null;
            }
            if (max2 == MAX_UNSIGNED_LONG) {
                return IntegerValue.makeIntegerValue(BigIntegerValue.MAX_UNSIGNED_LONG);
            }
            return Int64Value.makeIntegerValue(max2);
        }
        return null;
    }

    public static boolean checkBigRange(BigInteger big, BuiltInAtomicType type) {
        for (int i = 0; i < ranges.length; i += 3) {
            if (ranges[i] != (long)type.getFingerprint()) continue;
            long min2 = ranges[i + 1];
            if (min2 != NO_LIMIT && BigInteger.valueOf(min2).compareTo(big) > 0) {
                return false;
            }
            long max2 = ranges[i + 2];
            if (max2 == NO_LIMIT) {
                return true;
            }
            if (max2 == MAX_UNSIGNED_LONG) {
                return BigIntegerValue.MAX_UNSIGNED_LONG.compareTo(big) >= 0;
            }
            return BigInteger.valueOf(max2).compareTo(big) >= 0;
        }
        throw new IllegalArgumentException("No range information found for integer subtype " + type.getDescription());
    }

    public static ConversionResult stringToInteger(CharSequence s2) {
        int start;
        int len = s2.length();
        int last2 = len - 1;
        for (start = 0; start < len && s2.charAt(start) <= ' '; ++start) {
        }
        while (last2 > start && s2.charAt(last2) <= ' ') {
            --last2;
        }
        if (start > last2) {
            return new ValidationFailure("Cannot convert zero-length string to an integer");
        }
        if (last2 - start < 16) {
            boolean negative = false;
            long value2 = 0L;
            int i = start;
            if (s2.charAt(i) == '+') {
                ++i;
            } else if (s2.charAt(i) == '-') {
                negative = true;
                ++i;
            }
            if (i > last2) {
                return new ValidationFailure("Cannot convert string " + Err.wrap(s2, 4) + " to integer: no digits after the sign");
            }
            while (i <= last2) {
                char d;
                if ((d = s2.charAt(i++)) >= '0' && d <= '9') {
                    value2 = 10L * value2 + (long)(d - 48);
                    continue;
                }
                return new ValidationFailure("Cannot convert string " + Err.wrap(s2, 4) + " to an integer");
            }
            return Int64Value.makeIntegerValue(negative ? -value2 : value2);
        }
        try {
            CharSequence t = Whitespace.trimWhitespace(s2);
            if (t.charAt(0) == '+') {
                t = t.subSequence(1, t.length());
            }
            if (t.length() < 16) {
                return new Int64Value(Long.parseLong(t.toString()));
            }
            return new BigIntegerValue(new BigInteger(t.toString()));
        }
        catch (NumberFormatException err2) {
            return new ValidationFailure("Cannot convert string " + Err.wrap(s2, 4) + " to an integer");
        }
    }

    public static ValidationFailure castableAsInteger(CharSequence input2) {
        CharSequence s2 = Whitespace.trimWhitespace(input2);
        int last2 = s2.length() - 1;
        if (last2 < 0) {
            return new ValidationFailure("Cannot convert empty string to an integer");
        }
        int i = 0;
        if (s2.charAt(i) == '+' || s2.charAt(i) == '-') {
            ++i;
        }
        if (i > last2) {
            return new ValidationFailure("Cannot convert string " + Err.wrap(s2, 4) + " to integer: no digits after the sign");
        }
        while (i <= last2) {
            char d;
            if ((d = s2.charAt(i++)) >= '0' && d <= '9') continue;
            return new ValidationFailure("Cannot convert string " + Err.wrap(s2, 4) + " to an integer: contains a character that is not a digit");
        }
        return null;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.INTEGER;
    }

    public abstract BigDecimal getDecimalValue();

    public boolean isWholeNumber() {
        return true;
    }

    public abstract IntegerValue plus(IntegerValue var1);

    public abstract IntegerValue minus(IntegerValue var1);

    public abstract IntegerValue times(IntegerValue var1);

    public abstract NumericValue div(IntegerValue var1) throws XPathException;

    public NumericValue div(IntegerValue other, Location locator) throws XPathException {
        try {
            return this.div(other);
        }
        catch (XPathException err2) {
            err2.maybeSetLocation(locator);
            throw err2;
        }
    }

    public abstract IntegerValue mod(IntegerValue var1) throws XPathException;

    public IntegerValue mod(IntegerValue other, Location locator) throws XPathException {
        try {
            return this.mod(other);
        }
        catch (XPathException err2) {
            err2.maybeSetLocation(locator);
            throw err2;
        }
    }

    public abstract IntegerValue idiv(IntegerValue var1) throws XPathException;

    public IntegerValue idiv(IntegerValue other, Location locator) throws XPathException {
        try {
            return this.idiv(other);
        }
        catch (XPathException err2) {
            err2.maybeSetLocation(locator);
            throw err2;
        }
    }

    public abstract BigInteger asBigInteger();

    protected static int signum(int i) {
        return i >> 31 | -i >>> 31;
    }

    public boolean isIdentical(AtomicValue v) {
        return v instanceof IntegerValue && this.equals(v);
    }
}

