/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.expr.sort.DoubleSortComparer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.FloatingPointConverter;
import net.sf.saxon.value.NumericValue;

public final class DoubleValue
extends NumericValue {
    public static final DoubleValue ZERO = new DoubleValue(0.0);
    public static final DoubleValue NEGATIVE_ZERO = new DoubleValue(-0.0);
    public static final DoubleValue ONE = new DoubleValue(1.0);
    public static final DoubleValue NaN = new DoubleValue(Double.NaN);
    private double value;

    public DoubleValue(double value2) {
        this.value = value2;
        this.typeLabel = BuiltInAtomicType.DOUBLE;
    }

    public DoubleValue(double value2, AtomicType type) {
        this.value = value2;
        this.typeLabel = type;
    }

    public static DoubleValue makeDoubleValue(double value2) {
        return new DoubleValue(value2);
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        DoubleValue v = new DoubleValue(this.value);
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DOUBLE;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public float getFloatValue() {
        return (float)this.value;
    }

    public BigDecimal getDecimalValue() throws ValidationException {
        try {
            return new BigDecimal(this.value);
        }
        catch (NumberFormatException e) {
            throw new ValidationException(e);
        }
    }

    public long longValue() throws XPathException {
        return (long)this.value;
    }

    public int hashCode() {
        if (this.value > -2.147483648E9 && this.value < 2.147483647E9) {
            return (int)this.value;
        }
        return new Double(this.value).hashCode();
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean effectiveBooleanValue() {
        return this.value != 0.0 && !Double.isNaN(this.value);
    }

    public CharSequence getPrimitiveStringValue() {
        return DoubleValue.doubleToString(this.value);
    }

    public CharSequence getCanonicalLexicalRepresentation() {
        FastStringBuffer fsb = new FastStringBuffer(16);
        return FloatingPointConverter.appendDouble(fsb, this.value, true);
    }

    public static CharSequence doubleToString(double value2) {
        return FloatingPointConverter.appendDouble(new FastStringBuffer(16), value2, false);
    }

    public NumericValue negate() {
        return new DoubleValue(-this.value);
    }

    public NumericValue floor() {
        return new DoubleValue(Math.floor(this.value));
    }

    public NumericValue ceiling() {
        return new DoubleValue(Math.ceil(this.value));
    }

    public NumericValue round(int scale) {
        if (Double.isNaN(this.value)) {
            return this;
        }
        if (Double.isInfinite(this.value)) {
            return this;
        }
        if (this.value == 0.0) {
            return this;
        }
        if (scale == 0 && this.value > -9.223372036854776E18 && this.value < 9.223372036854776E18) {
            if (this.value >= -0.5 && this.value < 0.0) {
                return new DoubleValue(-0.0);
            }
            return new DoubleValue(Math.round(this.value));
        }
        double factor = Math.pow(10.0, scale + 1);
        double d = Math.abs(this.value * factor);
        if (Double.isInfinite(d)) {
            BigDecimal dec = new BigDecimal(this.value);
            dec = dec.setScale(scale, 4);
            return new DoubleValue(dec.doubleValue());
        }
        double rem = d % 10.0;
        if (rem >= 5.0) {
            d += 10.0 - rem;
        } else if (rem < 5.0) {
            d -= rem;
        }
        d /= factor;
        if (this.value < 0.0) {
            d = -d;
        }
        return new DoubleValue(d);
    }

    public NumericValue roundHalfToEven(int scale) {
        if (Double.isNaN(this.value)) {
            return this;
        }
        if (Double.isInfinite(this.value)) {
            return this;
        }
        if (this.value == 0.0) {
            return this;
        }
        double factor = Math.pow(10.0, scale + 1);
        double d = Math.abs(this.value * factor);
        if (Double.isInfinite(d)) {
            BigDecimal dec = new BigDecimal(this.value);
            dec = dec.setScale(scale, 6);
            return new DoubleValue(dec.doubleValue());
        }
        double rem = d % 10.0;
        d = rem > 5.0 ? (d += 10.0 - rem) : (rem < 5.0 ? (d -= rem) : (d % 20.0 == 15.0 ? (d += 5.0) : (d -= 5.0)));
        d /= factor;
        if (this.value < 0.0) {
            d = -d;
        }
        return new DoubleValue(d);
    }

    public int signum() {
        if (Double.isNaN(this.value)) {
            return 0;
        }
        if (this.value > 0.0) {
            return 1;
        }
        if (this.value == 0.0) {
            return 0;
        }
        return -1;
    }

    public boolean isNegativeZero() {
        return this.value == 0.0 && (Double.doubleToLongBits(this.value) & Long.MIN_VALUE) != 0L;
    }

    public boolean isWholeNumber() {
        return this.value == Math.floor(this.value) && !Double.isInfinite(this.value);
    }

    public int asSubscript() {
        if (this.isWholeNumber() && this.value > 0.0 && this.value <= 2.147483647E9) {
            return (int)this.value;
        }
        return -1;
    }

    public NumericValue abs() {
        if (this.value > 0.0) {
            return this;
        }
        return new DoubleValue(Math.abs(this.value));
    }

    public int compareTo(long other) {
        double otherDouble = other;
        if (this.value == otherDouble) {
            return 0;
        }
        return this.value < otherDouble ? -1 : 1;
    }

    public Comparable getSchemaComparable() {
        return Double.valueOf(this.value == 0.0 ? 0.0 : this.value);
    }

    public AtomicMatchKey asMapKey() {
        if (this.isNaN()) {
            return AtomicSortComparer.COLLATION_KEY_NaN;
        }
        if (Double.isInfinite(this.value)) {
            return this;
        }
        try {
            return new BigDecimalValue(this.value);
        }
        catch (ValidationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean isIdentical(AtomicValue v) {
        return v instanceof DoubleValue && DoubleSortComparer.getInstance().comparesEqual(this, v);
    }
}

