/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Whitespace;

public final class BooleanValue
extends AtomicValue
implements Comparable,
AtomicMatchKey {
    private boolean value;
    public static final BooleanValue TRUE = new BooleanValue(true);
    public static final BooleanValue FALSE = new BooleanValue(false);

    private BooleanValue(boolean value2) {
        this.value = value2;
        this.typeLabel = BuiltInAtomicType.BOOLEAN;
    }

    public static BooleanValue get(boolean value2) {
        return value2 ? TRUE : FALSE;
    }

    public BooleanValue(boolean value2, AtomicType typeLabel) {
        this.value = value2;
        this.typeLabel = typeLabel;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        BooleanValue v = new BooleanValue(this.value);
        v.typeLabel = typeLabel;
        return v;
    }

    public static ConversionResult fromString(CharSequence s2) {
        int len = (s2 = Whitespace.trimWhitespace(s2)).length();
        if (len == 1) {
            char c = s2.charAt(0);
            if (c == '1') {
                return TRUE;
            }
            if (c == '0') {
                return FALSE;
            }
        } else if (len == 4) {
            if (s2.charAt(0) == 't' && s2.charAt(1) == 'r' && s2.charAt(2) == 'u' && s2.charAt(3) == 'e') {
                return TRUE;
            }
        } else if (len == 5 && s2.charAt(0) == 'f' && s2.charAt(1) == 'a' && s2.charAt(2) == 'l' && s2.charAt(3) == 's' && s2.charAt(4) == 'e') {
            return FALSE;
        }
        ValidationFailure err2 = new ValidationFailure("The string " + Err.wrap(s2, 4) + " cannot be cast to a boolean");
        err2.setErrorCode("FORG0001");
        return err2;
    }

    public boolean getBooleanValue() {
        return this.value;
    }

    public boolean effectiveBooleanValue() {
        return this.value;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    public String getPrimitiveStringValue() {
        return this.value ? "true" : "false";
    }

    public Comparable getSchemaComparable() {
        return new BooleanComparable();
    }

    public AtomicMatchKey getXPathComparable(boolean ordered, StringCollator collator, int implicitTimezone) {
        return this;
    }

    public int compareTo(Object other) {
        if (!(other instanceof BooleanValue)) {
            throw new ClassCastException("Boolean values are not comparable to " + other.getClass());
        }
        if (this.value == ((BooleanValue)other).value) {
            return 0;
        }
        if (this.value) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object other) {
        return other instanceof BooleanValue && this.value == ((BooleanValue)other).value;
    }

    public int hashCode() {
        return this.value ? 0 : 1;
    }

    public String toString() {
        return this.getStringValue() + "()";
    }

    private class BooleanComparable
    implements Comparable {
        private BooleanComparable() {
        }

        public boolean asBoolean() {
            return BooleanValue.this.getBooleanValue();
        }

        public int compareTo(Object o) {
            return this.equals(o) ? 0 : Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            return o instanceof BooleanComparable && this.asBoolean() == ((BooleanComparable)o).asBoolean();
        }

        public int hashCode() {
            return this.asBoolean() ? 9999999 : 8888888;
        }
    }
}

