/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.util.regex.Pattern;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.value.YearMonthDurationValue;

public abstract class StringConverter
extends Converter {
    public static final StringToString STRING_TO_STRING = new StringToString();
    public static final StringToLanguage STRING_TO_LANGUAGE = new StringToLanguage();
    public static final StringToNormalizedString STRING_TO_NORMALIZED_STRING = new StringToNormalizedString();
    public static final StringToName STRING_TO_NAME = new StringToName();
    public static final StringToNCName STRING_TO_NCNAME = new StringToNCName(BuiltInAtomicType.NCNAME);
    public static final StringToNMTOKEN STRING_TO_NMTOKEN = new StringToNMTOKEN();
    public static final StringToNCName STRING_TO_ID = new StringToNCName(BuiltInAtomicType.ID);
    public static final StringToNCName STRING_TO_IDREF = new StringToNCName(BuiltInAtomicType.IDREF);
    public static final StringToNCName STRING_TO_ENTITY = new StringToNCName(BuiltInAtomicType.ENTITY);
    public static final StringToToken STRING_TO_TOKEN = new StringToToken();
    public static final StringToDecimal STRING_TO_DECIMAL = new StringToDecimal();
    public static final StringToInteger STRING_TO_INTEGER = new StringToInteger();
    public static final StringToGMonth STRING_TO_G_MONTH = new StringToGMonth();
    public static final StringToGMonthDay STRING_TO_G_MONTH_DAY = new StringToGMonthDay();
    public static final StringToGDay STRING_TO_G_DAY = new StringToGDay();
    public static final StringToDuration STRING_TO_DURATION = new StringToDuration();
    public static final StringToDayTimeDuration STRING_TO_DAY_TIME_DURATION = new StringToDayTimeDuration();
    public static final StringToYearMonthDuration STRING_TO_YEAR_MONTH_DURATION = new StringToYearMonthDuration();
    public static final StringToTime STRING_TO_TIME = new StringToTime();
    public static final StringToBoolean STRING_TO_BOOLEAN = new StringToBoolean();
    public static final StringToHexBinary STRING_TO_HEX_BINARY = new StringToHexBinary();
    public static final Converter.StringToBase64BinaryConverter STRING_TO_BASE64_BINARY = new Converter.StringToBase64BinaryConverter();
    public static final StringToUntypedAtomic STRING_TO_UNTYPED_ATOMIC = new StringToUntypedAtomic();

    protected StringConverter() {
    }

    protected StringConverter(ConversionRules rules) {
        super(rules);
    }

    public abstract ConversionResult convertString(CharSequence var1);

    public ValidationFailure validate(CharSequence input2) {
        ConversionResult result2 = this.convertString(input2);
        return result2 instanceof ValidationFailure ? (ValidationFailure)result2 : null;
    }

    public ConversionResult convert(AtomicValue input2) {
        return this.convertString(input2.getStringValueCS());
    }

    static {
        BuiltInAtomicType.ANY_ATOMIC.stringConverter = Converter.IDENTITY_CONVERTER;
        BuiltInAtomicType.STRING.stringConverter = STRING_TO_STRING;
        BuiltInAtomicType.LANGUAGE.stringConverter = STRING_TO_LANGUAGE;
        BuiltInAtomicType.NORMALIZED_STRING.stringConverter = STRING_TO_NORMALIZED_STRING;
        BuiltInAtomicType.TOKEN.stringConverter = STRING_TO_TOKEN;
        BuiltInAtomicType.NCNAME.stringConverter = STRING_TO_NCNAME;
        BuiltInAtomicType.NAME.stringConverter = STRING_TO_NAME;
        BuiltInAtomicType.NMTOKEN.stringConverter = STRING_TO_NMTOKEN;
        BuiltInAtomicType.ID.stringConverter = STRING_TO_ID;
        BuiltInAtomicType.IDREF.stringConverter = STRING_TO_IDREF;
        BuiltInAtomicType.ENTITY.stringConverter = STRING_TO_ENTITY;
        BuiltInAtomicType.DECIMAL.stringConverter = STRING_TO_DECIMAL;
        BuiltInAtomicType.INTEGER.stringConverter = STRING_TO_INTEGER;
        BuiltInAtomicType.DURATION.stringConverter = STRING_TO_DURATION;
        BuiltInAtomicType.G_MONTH.stringConverter = STRING_TO_G_MONTH;
        BuiltInAtomicType.G_MONTH_DAY.stringConverter = STRING_TO_G_MONTH_DAY;
        BuiltInAtomicType.G_DAY.stringConverter = STRING_TO_G_DAY;
        BuiltInAtomicType.DAY_TIME_DURATION.stringConverter = STRING_TO_DAY_TIME_DURATION;
        BuiltInAtomicType.YEAR_MONTH_DURATION.stringConverter = STRING_TO_YEAR_MONTH_DURATION;
        BuiltInAtomicType.TIME.stringConverter = STRING_TO_TIME;
        BuiltInAtomicType.BOOLEAN.stringConverter = STRING_TO_BOOLEAN;
        BuiltInAtomicType.HEX_BINARY.stringConverter = STRING_TO_HEX_BINARY;
        BuiltInAtomicType.BASE64_BINARY.stringConverter = STRING_TO_BASE64_BINARY;
        BuiltInAtomicType.UNTYPED_ATOMIC.stringConverter = STRING_TO_UNTYPED_ATOMIC;
        BuiltInAtomicType.NON_POSITIVE_INTEGER.stringConverter = new StringToIntegerSubtype(BuiltInAtomicType.NON_POSITIVE_INTEGER);
        BuiltInAtomicType.NEGATIVE_INTEGER.stringConverter = new StringToIntegerSubtype(BuiltInAtomicType.NEGATIVE_INTEGER);
        BuiltInAtomicType.LONG.stringConverter = new StringToIntegerSubtype(BuiltInAtomicType.LONG);
        BuiltInAtomicType.INT.stringConverter = new StringToIntegerSubtype(BuiltInAtomicType.INT);
        BuiltInAtomicType.SHORT.stringConverter = new StringToIntegerSubtype(BuiltInAtomicType.SHORT);
        BuiltInAtomicType.BYTE.stringConverter = new StringToIntegerSubtype(BuiltInAtomicType.BYTE);
        BuiltInAtomicType.NON_NEGATIVE_INTEGER.stringConverter = new StringToIntegerSubtype(BuiltInAtomicType.NON_NEGATIVE_INTEGER);
        BuiltInAtomicType.POSITIVE_INTEGER.stringConverter = new StringToIntegerSubtype(BuiltInAtomicType.POSITIVE_INTEGER);
        BuiltInAtomicType.UNSIGNED_LONG.stringConverter = new StringToIntegerSubtype(BuiltInAtomicType.UNSIGNED_LONG);
        BuiltInAtomicType.UNSIGNED_INT.stringConverter = new StringToIntegerSubtype(BuiltInAtomicType.UNSIGNED_INT);
        BuiltInAtomicType.UNSIGNED_SHORT.stringConverter = new StringToIntegerSubtype(BuiltInAtomicType.UNSIGNED_SHORT);
        BuiltInAtomicType.UNSIGNED_BYTE.stringConverter = new StringToIntegerSubtype(BuiltInAtomicType.UNSIGNED_BYTE);
    }

    public static class StringToUnionConverter
    extends StringConverter {
        SimpleType targetType;
        ConversionRules rules;

        public StringToUnionConverter(PlainType targetType, ConversionRules rules) {
            if (!targetType.isPlainType()) {
                throw new IllegalArgumentException();
            }
            if (((SimpleType)((Object)targetType)).isNamespaceSensitive()) {
                throw new IllegalArgumentException();
            }
            this.targetType = (SimpleType)((Object)targetType);
            this.rules = rules;
        }

        public ConversionResult convertString(CharSequence input2) {
            try {
                return this.targetType.getTypedValue(input2, null, this.rules).head();
            }
            catch (ValidationException err2) {
                return err2.getValidationFailure();
            }
        }
    }

    public static class IdentityConverter
    extends StringConverter {
        public static IdentityConverter THE_INSTANCE = new IdentityConverter();

        public ConversionResult convert(AtomicValue input2) {
            return input2;
        }

        public ConversionResult convertString(CharSequence input2) {
            return StringValue.makeStringValue(input2);
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }

        public ValidationFailure validate(CharSequence input2) {
            return null;
        }
    }

    public static class StringToAnyURI
    extends StringConverter {
        public StringToAnyURI(ConversionRules rules) {
            super(rules);
        }

        public ConversionResult convertString(CharSequence input2) {
            if (this.getConversionRules().isValidURI(input2)) {
                return new AnyURIValue(input2);
            }
            return new ValidationFailure("Invalid URI: " + input2.toString());
        }

        public ValidationFailure validate(CharSequence input2) {
            if (this.getConversionRules().isValidURI(input2)) {
                return null;
            }
            return new ValidationFailure("Invalid URI: " + input2.toString());
        }
    }

    public static class StringToNotation
    extends StringConverter {
        NamespaceResolver nsResolver;

        public StringToNotation(ConversionRules rules) {
            super(rules);
        }

        public Converter setNamespaceResolver(NamespaceResolver resolver) {
            StringToNotation c = new StringToNotation(this.getConversionRules());
            c.nsResolver = resolver;
            return c;
        }

        public NamespaceResolver getNamespaceResolver() {
            return this.nsResolver;
        }

        public ConversionResult convertString(CharSequence input2) {
            if (this.getNamespaceResolver() == null) {
                throw new UnsupportedOperationException("Cannot validate a NOTATION without a namespace resolver");
            }
            try {
                String[] parts = NameChecker.getQNameParts(Whitespace.trimWhitespace(input2));
                String uri = this.getNamespaceResolver().getURIForPrefix(parts[0], true);
                if (uri == null) {
                    return new ValidationFailure("Namespace prefix " + Err.wrap(parts[0]) + " has not been declared");
                }
                if (!this.getConversionRules().isDeclaredNotation(uri, parts[1])) {
                    return new ValidationFailure("Notation {" + uri + "}" + parts[1] + " is not declared in the schema");
                }
                return new NotationValue(parts[0], uri, parts[1], false);
            }
            catch (QNameException err2) {
                return new ValidationFailure("Invalid lexical QName " + Err.wrap(input2));
            }
            catch (XPathException err3) {
                return new ValidationFailure(err3.getMessage());
            }
        }
    }

    public static class StringToQName
    extends StringConverter {
        NamespaceResolver nsResolver;

        public StringToQName(ConversionRules rules) {
            super(rules);
        }

        public Converter setNamespaceResolver(NamespaceResolver resolver) {
            StringToQName c = new StringToQName(this.getConversionRules());
            c.nsResolver = resolver;
            return c;
        }

        public NamespaceResolver getNamespaceResolver() {
            return this.nsResolver;
        }

        public ConversionResult convertString(CharSequence input2) {
            if (this.nsResolver == null) {
                throw new UnsupportedOperationException("Cannot validate a QName without a namespace resolver");
            }
            try {
                String[] parts = NameChecker.getQNameParts(Whitespace.trimWhitespace(input2));
                String uri = this.nsResolver.getURIForPrefix(parts[0], true);
                if (uri == null) {
                    ValidationFailure failure2 = new ValidationFailure("Namespace prefix " + Err.wrap(parts[0]) + " has not been declared");
                    failure2.setErrorCode("FONS0004");
                    return failure2;
                }
                return new QNameValue(parts[0], uri, parts[1], BuiltInAtomicType.QNAME, false);
            }
            catch (QNameException err2) {
                return new ValidationFailure("Invalid lexical QName " + Err.wrap(input2));
            }
            catch (XPathException err3) {
                return new ValidationFailure(err3.getMessage());
            }
        }
    }

    public static class StringToHexBinary
    extends StringConverter {
        public ConversionResult convertString(CharSequence input2) {
            try {
                return new HexBinaryValue(input2);
            }
            catch (XPathException e) {
                return ValidationFailure.fromException(e);
            }
        }
    }

    public static class StringToBoolean
    extends StringConverter {
        public ConversionResult convertString(CharSequence input2) {
            return BooleanValue.fromString(input2);
        }
    }

    public static class StringToTime
    extends StringConverter {
        public ConversionResult convertString(CharSequence input2) {
            return TimeValue.makeTimeValue(input2);
        }
    }

    public static class StringToGDay
    extends StringConverter {
        public ConversionResult convertString(CharSequence input2) {
            return GDayValue.makeGDayValue(input2);
        }
    }

    public static class StringToGMonthDay
    extends StringConverter {
        public ConversionResult convertString(CharSequence input2) {
            return GMonthDayValue.makeGMonthDayValue(input2);
        }
    }

    public static class StringToGYear
    extends StringConverter {
        public StringToGYear(ConversionRules rules) {
            super(rules);
        }

        public ConversionResult convertString(CharSequence input2) {
            return GYearValue.makeGYearValue(input2, this.getConversionRules());
        }
    }

    public static class StringToGYearMonth
    extends StringConverter {
        public StringToGYearMonth(ConversionRules rules) {
            super(rules);
        }

        public ConversionResult convertString(CharSequence input2) {
            return GYearMonthValue.makeGYearMonthValue(input2, this.getConversionRules());
        }
    }

    public static class StringToGMonth
    extends StringConverter {
        public ConversionResult convertString(CharSequence input2) {
            return GMonthValue.makeGMonthValue(input2);
        }
    }

    public static class StringToDate
    extends StringConverter {
        public StringToDate(ConversionRules rules) {
            super(rules);
        }

        public ConversionResult convertString(CharSequence input2) {
            return DateValue.makeDateValue(input2, this.getConversionRules());
        }
    }

    public static class StringToDateTimeStamp
    extends StringConverter {
        public StringToDateTimeStamp(ConversionRules rules) {
            super(rules);
        }

        public ConversionResult convertString(CharSequence input2) {
            ConversionResult val = DateTimeValue.makeDateTimeValue(input2, this.getConversionRules());
            if (val instanceof DateTimeValue) {
                if (!((DateTimeValue)val).hasTimezone()) {
                    return new ValidationFailure("Supplied DateTimeStamp value " + input2 + " has no time zone");
                }
                ((DateTimeValue)val).setTypeLabel(BuiltInAtomicType.DATE_TIME_STAMP);
            }
            return val;
        }
    }

    public static class StringToDateTime
    extends StringConverter {
        public StringToDateTime(ConversionRules rules) {
            super(rules);
        }

        public ConversionResult convertString(CharSequence input2) {
            return DateTimeValue.makeDateTimeValue(input2, this.getConversionRules());
        }
    }

    public static class StringToYearMonthDuration
    extends StringConverter {
        public ConversionResult convertString(CharSequence input2) {
            return YearMonthDurationValue.makeYearMonthDurationValue(input2);
        }
    }

    public static class StringToDayTimeDuration
    extends StringConverter {
        public ConversionResult convertString(CharSequence input2) {
            return DayTimeDurationValue.makeDayTimeDurationValue(input2);
        }
    }

    public static class StringToDuration
    extends StringConverter {
        public ConversionResult convertString(CharSequence input2) {
            return DurationValue.makeDuration(input2);
        }
    }

    public static class StringToIntegerSubtype
    extends StringConverter {
        BuiltInAtomicType targetType;

        public StringToIntegerSubtype(BuiltInAtomicType targetType) {
            this.targetType = targetType;
        }

        public ConversionResult convertString(CharSequence input2) {
            ConversionResult iv = IntegerValue.stringToInteger(input2);
            if (iv instanceof Int64Value) {
                boolean ok = IntegerValue.checkRange(((Int64Value)iv).longValue(), this.targetType);
                if (ok) {
                    return ((Int64Value)iv).copyAsSubType(this.targetType);
                }
                return new ValidationFailure("Integer value is out of range for type " + this.targetType.toString());
            }
            if (iv instanceof BigIntegerValue) {
                boolean ok = IntegerValue.checkBigRange(((BigIntegerValue)iv).asBigInteger(), this.targetType);
                if (ok) {
                    ((BigIntegerValue)iv).setTypeLabel(this.targetType);
                    return iv;
                }
                return new ValidationFailure("Integer value is out of range for type " + this.targetType.toString());
            }
            assert (iv instanceof ValidationFailure);
            return iv;
        }
    }

    public static class StringToInteger
    extends StringConverter {
        public ConversionResult convert(AtomicValue input2) {
            return IntegerValue.stringToInteger(input2.getStringValueCS());
        }

        public ConversionResult convertString(CharSequence input2) {
            return IntegerValue.stringToInteger(input2);
        }

        public ValidationFailure validate(CharSequence input2) {
            return IntegerValue.castableAsInteger(input2);
        }
    }

    public static class StringToDecimal
    extends StringConverter {
        public ConversionResult convertString(CharSequence input2) {
            return BigDecimalValue.makeDecimalValue(input2, true);
        }

        public ValidationFailure validate(CharSequence input2) {
            if (BigDecimalValue.castableAsDecimal(input2)) {
                return null;
            }
            return new ValidationFailure("Cannot convert string to decimal: " + input2.toString());
        }
    }

    public static class StringToFloat
    extends StringConverter {
        public StringToFloat(ConversionRules rules) {
            super(rules);
        }

        public ConversionResult convertString(CharSequence input2) {
            try {
                float flt = (float)this.getConversionRules().getStringToDoubleConverter().stringToNumber(input2);
                return new FloatValue(flt);
            }
            catch (NumberFormatException err2) {
                ValidationFailure ve = new ValidationFailure("Cannot convert string to float: " + input2.toString());
                ve.setErrorCode("FORG0001");
                return ve;
            }
        }
    }

    public static class StringToDerivedStringSubtype
    extends StringConverter {
        AtomicType targetType;
        StringConverter builtInValidator;
        int whitespaceAction;

        public StringToDerivedStringSubtype(ConversionRules rules, AtomicType targetType) {
            super(rules);
            this.targetType = targetType;
            this.whitespaceAction = targetType.getWhitespaceAction();
            this.builtInValidator = ((AtomicType)targetType.getBuiltInBaseType()).getStringConverter(rules);
        }

        public ConversionResult convertString(CharSequence input2) {
            CharSequence cs = Whitespace.applyWhitespaceNormalization(this.whitespaceAction, input2);
            ValidationFailure f = this.builtInValidator.validate(cs);
            if (f != null) {
                return f;
            }
            try {
                cs = this.targetType.preprocess(cs);
            }
            catch (ValidationException err2) {
                return err2.getValidationFailure();
            }
            StringValue sv = new StringValue(cs);
            f = this.targetType.validate(sv, cs, this.getConversionRules());
            if (f == null) {
                sv.setTypeLabel(this.targetType);
                return sv;
            }
            return f;
        }
    }

    public static class StringToStringSubtype
    extends StringConverter {
        AtomicType targetType;
        int whitespaceAction;

        public StringToStringSubtype(ConversionRules rules, AtomicType targetType) {
            super(rules);
            this.targetType = targetType;
            this.whitespaceAction = targetType.getWhitespaceAction();
        }

        public ConversionResult convertString(CharSequence input2) {
            CharSequence cs = Whitespace.applyWhitespaceNormalization(this.whitespaceAction, input2);
            try {
                cs = this.targetType.preprocess(cs);
            }
            catch (ValidationException err2) {
                return err2.getValidationFailure();
            }
            StringValue sv = new StringValue(cs);
            ValidationFailure f = this.targetType.validate(sv, cs, this.getConversionRules());
            if (f == null) {
                sv.setTypeLabel(this.targetType);
                return sv;
            }
            return f;
        }

        public ValidationFailure validate(CharSequence input2) {
            CharSequence cs = Whitespace.applyWhitespaceNormalization(this.whitespaceAction, input2);
            try {
                cs = this.targetType.preprocess(cs);
            }
            catch (ValidationException err2) {
                return err2.getValidationFailure();
            }
            return this.targetType.validate(new StringValue(cs), cs, this.getConversionRules());
        }
    }

    public static class StringToName
    extends StringToNCName {
        public StringToName() {
            super(BuiltInAtomicType.NAME);
        }

        public ConversionResult convertString(CharSequence input2) {
            ValidationFailure vf = this.validate(input2);
            if (vf == null) {
                return new StringValue(Whitespace.trimWhitespace(input2), BuiltInAtomicType.NAME);
            }
            return vf;
        }

        public ValidationFailure validate(CharSequence input2) {
            CharSequence trimmed = Whitespace.trimWhitespace(input2);
            if (NameChecker.isValidNCName(trimmed)) {
                return null;
            }
            FastStringBuffer buff = new FastStringBuffer(trimmed.length());
            buff.append(trimmed);
            for (int i = 0; i < buff.length(); ++i) {
                if (buff.charAt(i) != ':') continue;
                buff.setCharAt(i, '_');
            }
            if (NameChecker.isValidNCName(buff)) {
                return null;
            }
            return new ValidationFailure("The value '" + trimmed + "' is not a valid xs:Name");
        }
    }

    public static class StringToNMTOKEN
    extends StringConverter {
        public ConversionResult convertString(CharSequence input2) {
            CharSequence trimmed = Whitespace.trimWhitespace(input2);
            if (NameChecker.isValidNmtoken(trimmed)) {
                return new StringValue(trimmed, BuiltInAtomicType.NMTOKEN);
            }
            return new ValidationFailure("The value '" + input2 + "' is not a valid xs:NMTOKEN");
        }

        public ValidationFailure validate(CharSequence input2) {
            if (NameChecker.isValidNmtoken(Whitespace.trimWhitespace(input2))) {
                return null;
            }
            return new ValidationFailure("The value '" + input2 + "' is not a valid xs:NMTOKEN");
        }
    }

    public static class StringToNCName
    extends StringConverter {
        AtomicType targetType;

        public StringToNCName(AtomicType targetType) {
            this.targetType = targetType;
        }

        public ConversionResult convertString(CharSequence input2) {
            CharSequence trimmed = Whitespace.trimWhitespace(input2);
            if (NameChecker.isValidNCName(trimmed)) {
                return new StringValue(trimmed, this.targetType);
            }
            return new ValidationFailure("The value '" + input2 + "' is not a valid " + this.targetType.getDisplayName());
        }

        public ValidationFailure validate(CharSequence input2) {
            if (NameChecker.isValidNCName(Whitespace.trimWhitespace(input2))) {
                return null;
            }
            return new ValidationFailure("The value '" + input2 + "' is not a valid " + this.targetType.getDisplayName());
        }
    }

    public static class StringToLanguage
    extends StringConverter {
        private static final Pattern regex = Pattern.compile("[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");

        public ConversionResult convertString(CharSequence input2) {
            CharSequence trimmed = Whitespace.trimWhitespace(input2);
            if (!regex.matcher(trimmed).matches()) {
                return new ValidationFailure("The value '" + input2 + "' is not a valid xs:language");
            }
            return new StringValue(trimmed, BuiltInAtomicType.LANGUAGE);
        }

        public ValidationFailure validate(CharSequence input2) {
            if (regex.matcher(Whitespace.trimWhitespace(input2)).matches()) {
                return null;
            }
            return new ValidationFailure("The value '" + input2 + "' is not a valid xs:language");
        }
    }

    public static class StringToToken
    extends StringConverter {
        public ConversionResult convertString(CharSequence input2) {
            return new StringValue(Whitespace.collapseWhitespace(input2), BuiltInAtomicType.TOKEN);
        }

        public ValidationFailure validate(CharSequence input2) {
            return null;
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class StringToNormalizedString
    extends StringConverter {
        public ConversionResult convertString(CharSequence input2) {
            return new StringValue(Whitespace.normalizeWhitespace(input2), BuiltInAtomicType.NORMALIZED_STRING);
        }

        public ValidationFailure validate(CharSequence input2) {
            return null;
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class StringToUntypedAtomic
    extends StringConverter {
        public ConversionResult convert(AtomicValue input2) {
            return new UntypedAtomicValue(input2.getStringValueCS());
        }

        public ConversionResult convertString(CharSequence input2) {
            return new UntypedAtomicValue(input2);
        }

        public ValidationFailure validate(CharSequence input2) {
            return null;
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class StringToString
    extends StringConverter {
        public ConversionResult convert(AtomicValue input2) {
            return new StringValue(input2.getStringValueCS());
        }

        public ConversionResult convertString(CharSequence input2) {
            return new StringValue(input2);
        }

        public ValidationFailure validate(CharSequence input2) {
            return null;
        }

        public boolean isAlwaysSuccessful() {
            return true;
        }
    }

    public static class StringToNonStringDerivedType
    extends StringConverter {
        private StringConverter phaseOne;
        private Converter.DownCastingConverter phaseTwo;

        public StringToNonStringDerivedType(StringConverter phaseOne, Converter.DownCastingConverter phaseTwo) {
            this.phaseOne = phaseOne;
            this.phaseTwo = phaseTwo;
        }

        public Converter setNamespaceResolver(NamespaceResolver resolver) {
            return new StringToNonStringDerivedType((StringConverter)this.phaseOne.setNamespaceResolver(resolver), (Converter.DownCastingConverter)this.phaseTwo.setNamespaceResolver(resolver));
        }

        public ConversionResult convert(AtomicValue input2) {
            CharSequence in = input2.getStringValueCS();
            try {
                in = this.phaseTwo.getTargetType().preprocess(in);
            }
            catch (ValidationException err2) {
                return err2.getValidationFailure();
            }
            ConversionResult temp = this.phaseOne.convertString(in);
            if (temp instanceof ValidationFailure) {
                return temp;
            }
            return this.phaseTwo.convert((AtomicValue)temp, in);
        }

        public ConversionResult convertString(CharSequence input2) {
            try {
                input2 = this.phaseTwo.getTargetType().preprocess(input2);
            }
            catch (ValidationException err2) {
                return err2.getValidationFailure();
            }
            ConversionResult temp = this.phaseOne.convertString(input2);
            if (temp instanceof ValidationFailure) {
                return temp;
            }
            return this.phaseTwo.convert((AtomicValue)temp, input2);
        }

        public ValidationFailure validate(CharSequence input2) {
            try {
                input2 = this.phaseTwo.getTargetType().preprocess(input2);
            }
            catch (ValidationException err2) {
                return err2.getValidationFailure();
            }
            ConversionResult temp = this.phaseOne.convertString(input2);
            if (temp instanceof ValidationFailure) {
                return (ValidationFailure)temp;
            }
            return this.phaseTwo.validate((AtomicValue)temp, input2);
        }
    }
}

