/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class BuiltInListType
implements ListType {
    private int fingerprint;
    public static BuiltInListType ENTITIES = BuiltInListType.makeListType("http://www.w3.org/2001/XMLSchema", "ENTITIES");
    public static BuiltInListType IDREFS = BuiltInListType.makeListType("http://www.w3.org/2001/XMLSchema", "IDREFS");
    public static BuiltInListType NMTOKENS = BuiltInListType.makeListType("http://www.w3.org/2001/XMLSchema", "NMTOKENS");
    public static BuiltInListType ANY_URIS = BuiltInListType.makeListType("http://www.w3.org/2001/XMLSchema-instance", "anonymous_schemaLocationType");
    private BuiltInAtomicType itemType;

    public boolean isExternalType() {
        return false;
    }

    public boolean isBuiltInType() {
        return true;
    }

    public String getSystemId() {
        return null;
    }

    public int getRedefinitionLevel() {
        return 0;
    }

    public int getWhitespaceAction() {
        return 2;
    }

    public BuiltInListType(int fingerprint) {
        this.fingerprint = fingerprint;
        switch (fingerprint) {
            case 564: {
                this.itemType = BuiltInAtomicType.ENTITY;
                break;
            }
            case 562: {
                this.itemType = BuiltInAtomicType.IDREF;
                break;
            }
            case 557: {
                this.itemType = BuiltInAtomicType.NMTOKEN;
                break;
            }
            case 645: {
                this.itemType = BuiltInAtomicType.ANY_URI;
            }
        }
    }

    public int getValidationStatus() {
        return 3;
    }

    public SchemaType getBaseType() {
        return AnySimpleType.getInstance();
    }

    public boolean isAtomicType() {
        return false;
    }

    public boolean isIdType() {
        return false;
    }

    public boolean isIdRefType() {
        return this.fingerprint == 562;
    }

    public boolean isListType() {
        return true;
    }

    public boolean isUnionType() {
        return false;
    }

    public boolean isAnonymousType() {
        return false;
    }

    public SchemaType getBuiltInBaseType() {
        return this;
    }

    public boolean isNamespaceSensitive() {
        return false;
    }

    public String getName() {
        return StandardNames.getLocalName(this.fingerprint);
    }

    public String getTargetNamespace() {
        return "http://www.w3.org/2001/XMLSchema";
    }

    public String getEQName() {
        return "Q{http://www.w3.org/2001/XMLSchema}" + this.getName();
    }

    public int getFingerprint() {
        return this.fingerprint;
    }

    public String getDisplayName() {
        return StandardNames.getDisplayName(this.fingerprint);
    }

    public boolean isComplexType() {
        return false;
    }

    public boolean isSimpleType() {
        return true;
    }

    public int getBlock() {
        return 0;
    }

    public SchemaType getKnownBaseType() throws IllegalStateException {
        return AnySimpleType.getInstance();
    }

    public int getDerivationMethod() {
        return 8;
    }

    public boolean allowsDerivation(int derivation) {
        return true;
    }

    public int getFinalProhibitions() {
        return 0;
    }

    public AtomicSequence atomize(NodeInfo node) throws XPathException {
        try {
            return this.getTypedValue(node.getStringValue(), new InscopeNamespaceResolver(node), node.getConfiguration().getConversionRules());
        }
        catch (ValidationException err2) {
            throw new XPathException("Internal error: value doesn't match its type annotation. " + err2.getMessage());
        }
    }

    public boolean isSameType(SchemaType other) {
        return other.getFingerprint() == this.getFingerprint();
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public void checkTypeDerivationIsOK(SchemaType type, int block) throws SchemaException {
    }

    public String getLocalName() {
        return StandardNames.getLocalName(this.fingerprint);
    }

    public StructuredQName getStructuredQName() {
        return new StructuredQName("xs", "http://www.w3.org/2001/XMLSchema", this.getLocalName());
    }

    public SimpleType getItemType() {
        return this.itemType;
    }

    public String applyWhitespaceNormalization(String value2) {
        return Whitespace.collapseWhitespace(value2).toString();
    }

    public void analyzeContentExpression(Expression expression, int kind) throws XPathException {
        BuiltInAtomicType.analyzeContentExpression(this, expression, kind);
    }

    public ValidationFailure validateContent(CharSequence value2, NamespaceResolver nsResolver, ConversionRules rules) {
        StringValue val;
        SimpleType base = this.getItemType();
        Whitespace.Tokenizer iter2 = new Whitespace.Tokenizer(value2);
        boolean found = false;
        while ((val = iter2.next()) != null) {
            found = true;
            ValidationFailure v = base.validateContent(val.getStringValue(), nsResolver, rules);
            if (v == null) continue;
            return v;
        }
        if (!found) {
            return new ValidationFailure("The built-in list type " + StandardNames.getDisplayName(this.fingerprint) + " does not allow a zero-length list");
        }
        return null;
    }

    public AtomicSequence getTypedValue(CharSequence value2, NamespaceResolver resolver, ConversionRules rules) throws ValidationException {
        Whitespace.Tokenizer iter2 = new Whitespace.Tokenizer(value2);
        ListTypeMappingFunction map2 = new ListTypeMappingFunction();
        map2.resolver = resolver;
        map2.atomicType = (AtomicType)this.getItemType();
        map2.rules = rules;
        try {
            return new AtomicArray(new MappingIterator(iter2, map2));
        }
        catch (XPathException err2) {
            throw new ValidationException(err2);
        }
    }

    private static BuiltInListType makeListType(String namespace, String lname) {
        BuiltInListType t = new BuiltInListType(StandardNames.getFingerprint(namespace, lname));
        BuiltInType.register(t.getFingerprint(), t);
        return t;
    }

    public CharSequence preprocess(CharSequence input2) {
        return input2;
    }

    public CharSequence postprocess(CharSequence input2) throws ValidationException {
        return input2;
    }

    private static class ListTypeMappingFunction
    implements MappingFunction {
        public NamespaceResolver resolver;
        public AtomicType atomicType;
        public ConversionRules rules;

        private ListTypeMappingFunction() {
        }

        public SequenceIterator map(Item item) throws XPathException {
            try {
                return this.atomicType.getTypedValue(item.getStringValueCS(), this.resolver, this.rules).iterate();
            }
            catch (ValidationException err2) {
                throw new XPathException(err2);
            }
        }
    }
}

