/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.wrapper.VirtualCopy;
import net.sf.saxon.tree.wrapper.VirtualTreeInfo;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.UntypedAtomicValue;

public class VirtualUntypedCopy
extends VirtualCopy {
    public static VirtualCopy makeVirtualUntypedTree(NodeInfo original, NodeInfo root2) {
        VirtualTreeInfo doc;
        while (original instanceof VirtualUntypedCopy && original.getParent() == null) {
            original = ((VirtualUntypedCopy)original).original;
            root2 = ((VirtualUntypedCopy)root2).original;
        }
        VirtualUntypedCopy vc = new VirtualUntypedCopy(original, root2);
        Configuration config = original.getConfiguration();
        vc.tree = doc = new VirtualTreeInfo(config, vc);
        return vc;
    }

    protected VirtualUntypedCopy(NodeInfo base, NodeInfo root2) {
        super(base, root2);
    }

    public SchemaType getSchemaType() {
        switch (this.getNodeKind()) {
            case 1: {
                return Untyped.getInstance();
            }
            case 2: {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
        }
        return super.getSchemaType();
    }

    public AtomicSequence atomize() throws XPathException {
        switch (this.getNodeKind()) {
            case 1: 
            case 2: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        return super.atomize();
    }

    public void copy(Receiver out, int copyOptions, Location locationId) throws XPathException {
        super.copy(out, copyOptions & 0xFFFFFFFB, locationId);
    }

    protected VirtualCopy wrap(NodeInfo node) {
        VirtualUntypedCopy vc = new VirtualUntypedCopy(node, this.root);
        vc.tree = this.tree;
        return vc;
    }

    public boolean isNilled() {
        return false;
    }
}

