/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.AxisIteratorImpl;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.VirtualCopy;
import net.sf.saxon.tree.wrapper.VirtualTreeInfo;
import net.sf.saxon.value.UntypedAtomicValue;

public class SnapshotNode
extends VirtualCopy
implements NodeInfo {
    protected NodeInfo pivot;

    protected SnapshotNode(NodeInfo base, NodeInfo pivot) {
        super(base, pivot.getRoot());
        this.pivot = pivot;
    }

    public static SnapshotNode makeSnapshot(NodeInfo original) {
        SnapshotNode vc = new SnapshotNode(original, original);
        Configuration config = original.getConfiguration();
        VirtualTreeInfo doc = new VirtualTreeInfo(config);
        long docNr = config.getDocumentNumberAllocator().allocateDocumentNumber();
        doc.setDocumentNumber(docNr);
        doc.setCopyAccumulators(true);
        vc.tree = doc;
        doc.setRootNode(vc.getRoot());
        return vc;
    }

    protected SnapshotNode wrap(NodeInfo node) {
        SnapshotNode vc = new SnapshotNode(node, this.pivot);
        vc.tree = this.tree;
        return vc;
    }

    public CharSequence getStringValueCS() {
        if (Navigator.isAncestorOrSelf(this.original, this.pivot)) {
            return this.pivot.getStringValueCS();
        }
        return this.original.getStringValueCS();
    }

    public NodeInfo getParent() {
        if (this.parent == null) {
            NodeInfo basep = this.original.getParent();
            if (basep == null) {
                return null;
            }
            this.parent = this.wrap(basep);
        }
        return this.parent;
    }

    public NodeInfo getRoot() {
        return super.getRoot();
    }

    public void copy(Receiver out, int copyOptions, Location locationId) throws XPathException {
        Navigator.copy(this, out, copyOptions, locationId);
    }

    public AtomicSequence atomize() throws XPathException {
        switch (this.getNodeKind()) {
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 13: {
                return this.original.atomize();
            }
        }
        if (Navigator.isAncestorOrSelf(this.pivot, this.original)) {
            return this.original.atomize();
        }
        return new UntypedAtomicValue(this.pivot.getStringValueCS());
    }

    public boolean isId() {
        return this.original.isId();
    }

    public boolean isIdref() {
        return this.original.isIdref();
    }

    public boolean isNilled() {
        return this.original.isNilled();
    }

    public String getPublicId() {
        return this.original instanceof SourceLocator ? this.original.getPublicId() : null;
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (this.getNodeKind()) {
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 13: {
                return super.iterateAxis(axisNumber, nodeTest);
            }
        }
        if (!this.original.isSameNodeInfo(this.pivot) && Navigator.isAncestorOrSelf(this.original, this.pivot)) {
            switch (axisNumber) {
                case 3: {
                    return SingleNodeIterator.makeIterator(this.getChildOfAncestorNode());
                }
                case 4: 
                case 5: {
                    AxisIteratorImpl iter2 = new Navigator.DescendantEnumeration(this, axisNumber == 5, true);
                    if (!(nodeTest instanceof AnyNodeTest)) {
                        iter2 = new Navigator.AxisFilter(iter2, nodeTest);
                    }
                    return iter2;
                }
            }
            return super.iterateAxis(axisNumber, nodeTest);
        }
        return super.iterateAxis(axisNumber, nodeTest);
    }

    private NodeInfo getChildOfAncestorNode() {
        int pivotKind = this.pivot.getNodeKind();
        SnapshotNode p = this.wrap(this.pivot);
        if ((pivotKind == 2 || pivotKind == 13) && p.getParent().isSameNodeInfo(this)) {
            return null;
        }
        while (true) {
            SnapshotNode q;
            if ((q = (SnapshotNode)p.getParent()) == null) {
                throw new AssertionError();
            }
            if (q.isSameNodeInfo(this)) {
                return p;
            }
            p = q;
        }
    }

    protected boolean isIncludedInCopy(NodeInfo sourceNode) {
        switch (sourceNode.getNodeKind()) {
            case 2: 
            case 13: {
                return this.isIncludedInCopy(sourceNode.getParent());
            }
        }
        return Navigator.isAncestorOrSelf(this.pivot, sourceNode) || Navigator.isAncestorOrSelf(sourceNode, this.pivot);
    }
}

