/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.util;

import net.sf.saxon.tree.util.FastStringBuffer;

public class ProcInstParser {
    private ProcInstParser() {
    }

    public static String getPseudoAttribute(String content, String name) {
        int pos = 0;
        while (pos <= content.length() - 4) {
            int nextQuote = -1;
            for (int q = pos; q < content.length(); ++q) {
                if (content.charAt(q) != '\"' && content.charAt(q) != '\'') continue;
                nextQuote = q;
                break;
            }
            if (nextQuote < 0) {
                return null;
            }
            int closingQuote = content.indexOf(content.charAt(nextQuote), nextQuote + 1);
            if (closingQuote < 0) {
                return null;
            }
            int nextName = content.indexOf(name, pos);
            if (nextName < 0) {
                return null;
            }
            if (nextName < nextQuote) {
                boolean found = true;
                for (int s2 = nextName + name.length(); s2 < nextQuote; ++s2) {
                    char c = content.charAt(s2);
                    if (Character.isWhitespace(c) || c == '=') continue;
                    found = false;
                    break;
                }
                if (found) {
                    String val = content.substring(nextQuote + 1, closingQuote);
                    String u = ProcInstParser.unescape(val);
                    if (u == null) {
                        return val;
                    }
                    return u;
                }
            }
            pos = closingQuote + 1;
        }
        return null;
    }

    private static String unescape(String value2) {
        if (value2.indexOf(38) < 0) {
            return value2;
        }
        FastStringBuffer sb = new FastStringBuffer(value2.length());
        for (int i = 0; i < value2.length(); ++i) {
            char c = value2.charAt(i);
            if (c == '&') {
                if (i + 2 < value2.length() && value2.charAt(i + 1) == '#') {
                    int digit2;
                    int x;
                    int charval;
                    if (value2.charAt(i + 2) == 'x') {
                        charval = 0;
                        for (x = i + 3; x < value2.length() && value2.charAt(x) != ';'; ++x) {
                            digit2 = "0123456789abcdef".indexOf(value2.charAt(x));
                            if (digit2 < 0) {
                                digit2 = "0123456789ABCDEF".indexOf(value2.charAt(x));
                            }
                            if (digit2 < 0) {
                                return null;
                            }
                            charval = charval * 16 + digit2;
                        }
                        char hexchar = (char)charval;
                        sb.append(hexchar);
                        i = x;
                        continue;
                    }
                    charval = 0;
                    for (x = i + 2; x < value2.length() && value2.charAt(x) != ';'; ++x) {
                        digit2 = "0123456789".indexOf(value2.charAt(x));
                        if (digit2 < 0) {
                            return null;
                        }
                        charval = charval * 10 + digit2;
                    }
                    char decchar = (char)charval;
                    sb.append(decchar);
                    i = x;
                    continue;
                }
                if (value2.substring(i + 1).startsWith("lt;")) {
                    sb.append('<');
                    i += 3;
                    continue;
                }
                if (value2.substring(i + 1).startsWith("gt;")) {
                    sb.append('>');
                    i += 3;
                    continue;
                }
                if (value2.substring(i + 1).startsWith("amp;")) {
                    sb.append('&');
                    i += 4;
                    continue;
                }
                if (value2.substring(i + 1).startsWith("quot;")) {
                    sb.append('\"');
                    i += 5;
                    continue;
                }
                if (value2.substring(i + 1).startsWith("apos;")) {
                    sb.append('\'');
                    i += 5;
                    continue;
                }
                return null;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

