/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.CopyNamespaceSensitiveException;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyParentNodeImpl;
import net.sf.saxon.tree.tiny.TinyTextImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.tiny.WhitespaceTextImpl;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;

public final class TinyElementImpl
extends TinyParentNodeImpl {
    public TinyElementImpl(TinyTree tree, int nodeNr) {
        this.tree = tree;
        this.nodeNr = nodeNr;
    }

    public final int getNodeKind() {
        return 1;
    }

    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    public SchemaType getSchemaType() {
        return this.tree.getSchemaType(this.nodeNr);
    }

    public AtomicSequence atomize() throws XPathException {
        return this.tree.getTypedValueOfElement(this);
    }

    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return TinyElementImpl.getDeclaredNamespaces(this.tree, this.nodeNr, buffer);
    }

    public static NamespaceBinding[] getDeclaredNamespaces(TinyTree tree, int nodeNr, NamespaceBinding[] buffer) {
        int ns = tree.beta[nodeNr];
        if (ns > 0) {
            int count2 = 0;
            while (ns < tree.numberOfNamespaces && tree.namespaceParent[ns] == nodeNr) {
                ++count2;
                ++ns;
            }
            if (count2 == 0) {
                return NamespaceBinding.EMPTY_ARRAY;
            }
            if (buffer != null && count2 <= buffer.length) {
                System.arraycopy(tree.namespaceBinding, tree.beta[nodeNr], buffer, 0, count2);
                if (count2 < buffer.length) {
                    buffer[count2] = null;
                }
                return buffer;
            }
            NamespaceBinding[] array = new NamespaceBinding[count2];
            System.arraycopy(tree.namespaceBinding, tree.beta[nodeNr], array, 0, count2);
            return array;
        }
        return NamespaceBinding.EMPTY_ARRAY;
    }

    public String getAttributeValue(String uri, String local) {
        int a = this.tree.alpha[this.nodeNr];
        if (a < 0) {
            return null;
        }
        NamePool pool = this.getNamePool();
        while (a < this.tree.numberOfAttributes && this.tree.attParent[a] == this.nodeNr) {
            int fp = this.tree.attCode[a] & 0xFFFFF;
            if (pool.getLocalName(fp).equals(local) && pool.getURI(fp).equals(uri)) {
                return this.tree.attValue[a].toString();
            }
            ++a;
        }
        return null;
    }

    public String getAttributeValue(int fp) {
        int a = this.tree.alpha[this.nodeNr];
        if (a < 0) {
            return null;
        }
        while (a < this.tree.numberOfAttributes && this.tree.attParent[a] == this.nodeNr) {
            if (fp == (this.tree.attCode[a] & 0xFFFFF)) {
                return this.tree.attValue[a].toString();
            }
            ++a;
        }
        return null;
    }

    public void copy(Receiver receiver, int copyOptions, Location location) throws XPathException {
        boolean typed = CopyOptions.includes(copyOptions, 4);
        if (TinyTree.useFastCopy) {
            Receiver r3;
            Receiver r2;
            boolean copyTypes = typed;
            Receiver r1 = receiver;
            if (this.isSkipValidator(r1)) {
                copyTypes = false;
                r1 = ((ProxyReceiver)r1).getUnderlyingReceiver();
            }
            if (r1 instanceof ComplexContentOutputter && !copyTypes && (r2 = ((ComplexContentOutputter)r1).getReceiver()) instanceof NamespaceReducer && (r3 = ((NamespaceReducer)r2).getUnderlyingReceiver()) instanceof TinyBuilder) {
                ((ComplexContentOutputter)r1).beforeBulkCopy();
                TinyBuilder target = (TinyBuilder)r3;
                target.bulkCopy(this.getTree(), this.nodeNr);
                ((ComplexContentOutputter)r1).afterBulkCopy();
                return;
            }
        }
        short level = -1;
        boolean closePending = false;
        short startLevel = this.tree.depth[this.nodeNr];
        boolean first = true;
        boolean disallowNamespaceSensitiveContent = (copyOptions & 4) != 0 && (copyOptions & 3) == 0;
        Configuration config = this.tree.getConfiguration();
        NamePool pool = config.getNamePool();
        int next2 = this.nodeNr;
        CopyInformee informee = (CopyInformee)receiver.getPipelineConfiguration().getComponent(CopyInformee.class.getName());
        SchemaType elementType = Untyped.getInstance();
        SimpleType attributeType = BuiltInAtomicType.UNTYPED_ATOMIC;
        do {
            short nodeLevel = this.tree.depth[next2];
            if (closePending) {
                level = (short)(level + 1);
            }
            while (level > nodeLevel) {
                receiver.endElement();
                level = (short)(level - 1);
            }
            level = nodeLevel;
            switch (this.tree.nodeKind[next2]) {
                case 1: {
                    int options;
                    Location loc;
                    if (typed) {
                        elementType = this.tree.getSchemaType(next2);
                        if (disallowNamespaceSensitiveContent) {
                            try {
                                this.checkNotNamespaceSensitiveElement(elementType, next2);
                            }
                            catch (CopyNamespaceSensitiveException e) {
                                int lang = receiver.getPipelineConfiguration().getHostLanguage();
                                e.setErrorCode(lang == 50 ? "XTTE0950" : "XQTY0086");
                                throw e;
                            }
                        }
                    }
                    if (informee != null && (loc = (Location)informee.notifyElementNode(this.tree.getNode(next2))) != null) {
                        location = loc;
                    }
                    int nameCode = this.tree.nameCode[next2];
                    int fp = nameCode & 0xFFFFF;
                    String prefix = this.tree.getPrefix(next2);
                    int n = options = !first && (copyOptions & 3) != 0 ? 64 : 0;
                    if (location.getLineNumber() < this.tree.getLineNumber(next2)) {
                        String systemId = location.getSystemId() == null ? this.getSystemId() : location.getSystemId();
                        location = new ExplicitLocation(systemId, this.tree.getLineNumber(next2), this.getColumnNumber());
                    }
                    receiver.startElement(new CodedName(fp, prefix, pool), elementType, location, options);
                    closePending = true;
                    if ((copyOptions & 3) != 0 && this.tree.usesNamespaces) {
                        if (first) {
                            if ((copyOptions & 1) != 0) {
                                NamespaceBinding[] localNamespaces;
                                for (NamespaceBinding ns : localNamespaces = this.getDeclaredNamespaces(null)) {
                                    if (ns == null) break;
                                    receiver.namespace(ns, 0);
                                }
                            } else if ((copyOptions & 2) != 0) {
                                NamespaceIterator.sendNamespaces(this, receiver);
                            }
                        } else {
                            int ns = this.tree.beta[next2];
                            if (ns > 0) {
                                while (ns < this.tree.numberOfNamespaces && this.tree.namespaceParent[ns] == next2) {
                                    NamespaceBinding nscode = this.tree.namespaceBinding[ns];
                                    receiver.namespace(nscode, 0);
                                    ++ns;
                                }
                            }
                        }
                    }
                    first = false;
                    int att = this.tree.alpha[next2];
                    if (att >= 0) {
                        while (att < this.tree.numberOfAttributes && this.tree.attParent[att] == next2) {
                            int attCode = this.tree.attCode[att];
                            int attfp = attCode & 0xFFFFF;
                            if (typed) {
                                attributeType = this.tree.getAttributeType(att);
                                if (disallowNamespaceSensitiveContent) {
                                    try {
                                        this.checkNotNamespaceSensitiveAttribute(attributeType, att);
                                    }
                                    catch (CopyNamespaceSensitiveException e) {
                                        int lang = receiver.getPipelineConfiguration().getHostLanguage();
                                        e.setErrorCode(lang == 50 ? "XTTE0950" : "XQTY0086");
                                        throw e;
                                    }
                                }
                            }
                            String attPrefix = this.tree.prefixPool.getPrefix(attCode >> 20);
                            receiver.attribute(new CodedName(attfp, attPrefix, pool), attributeType, this.tree.attValue[att], location, 0);
                            ++att;
                        }
                    }
                    receiver.startContent();
                    break;
                }
                case 3: {
                    closePending = false;
                    CharSequence value2 = TinyTextImpl.getStringValue(this.tree, next2);
                    receiver.characters(value2, location, 1024);
                    break;
                }
                case 4: {
                    closePending = false;
                    CharSequence value3 = WhitespaceTextImpl.getStringValueCS(this.tree, next2);
                    receiver.characters(value3, location, 1024);
                    break;
                }
                case 8: {
                    closePending = false;
                    int start = this.tree.alpha[next2];
                    int len = this.tree.beta[next2];
                    if (len > 0) {
                        receiver.comment(this.tree.commentBuffer.subSequence(start, start + len), location, 0);
                        break;
                    }
                    receiver.comment("", ExplicitLocation.UNKNOWN_LOCATION, 0);
                    break;
                }
                case 7: {
                    closePending = false;
                    TinyNodeImpl pi = this.tree.getNode(next2);
                    receiver.processingInstruction(pi.getLocalPart(), pi.getStringValue(), location, 0);
                    break;
                }
                case 12: {
                    closePending = false;
                }
            }
        } while (++next2 < this.tree.numberOfNodes && this.tree.depth[next2] > startLevel);
        if (closePending) {
            level = (short)(level + 1);
        }
        while (level > startLevel) {
            receiver.endElement();
            level = (short)(level - 1);
        }
    }

    private void checkNotNamespaceSensitiveElement(SchemaType type, int nodeNr) throws XPathException {
        if (type instanceof SimpleType && ((SimpleType)type).isNamespaceSensitive()) {
            if (type.isAtomicType()) {
                throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
            }
            AtomicSequence value2 = this.tree.getTypedValueOfElement(nodeNr);
            for (AtomicValue val : value2) {
                if (!val.getPrimitiveType().isNamespaceSensitive()) continue;
                throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
            }
        }
    }

    private void checkNotNamespaceSensitiveAttribute(SimpleType type, int nodeNr) throws XPathException {
        if (type.isNamespaceSensitive()) {
            if (type.isAtomicType()) {
                throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
            }
            AtomicSequence value2 = this.tree.getTypedValueOfAttribute(null, nodeNr);
            for (AtomicValue val : value2) {
                if (!val.getPrimitiveType().isNamespaceSensitive()) continue;
                throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
            }
        }
    }

    public String getURIForPrefix(String prefix, boolean useDefault) {
        NodeInfo parent;
        if (!useDefault && (prefix == null || prefix.isEmpty())) {
            return "";
        }
        int ns = this.tree.beta[this.nodeNr];
        if (ns > 0) {
            while (ns < this.tree.numberOfNamespaces && this.tree.namespaceParent[ns] == this.nodeNr) {
                NamespaceBinding nscode = this.tree.namespaceBinding[ns];
                if (nscode.getPrefix().equals(prefix)) {
                    String uri = nscode.getURI();
                    if (uri.isEmpty()) {
                        if (prefix.isEmpty()) {
                            return "";
                        }
                        return null;
                    }
                    return uri;
                }
                ++ns;
            }
        }
        if ((parent = this.getParent()) instanceof NamespaceResolver) {
            return ((NamespaceResolver)((Object)parent)).getURIForPrefix(prefix, useDefault);
        }
        return null;
    }

    public boolean isId() {
        return this.tree.isIdElement(this.nodeNr);
    }

    public boolean isIdref() {
        return this.tree.isIdrefElement(this.nodeNr);
    }

    private boolean isSkipValidator(Receiver r) {
        return false;
    }
}

