/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;

public class TinyAttributeCollection
implements AttributeCollection {
    int element;
    TinyTree tree;
    int firstAttribute;

    public TinyAttributeCollection(TinyTree tree, int element) {
        this.tree = tree;
        this.element = element;
        this.firstAttribute = tree.alpha[element];
    }

    public int getLength() {
        int i;
        for (i = this.firstAttribute; i < this.tree.numberOfAttributes && this.tree.attParent[i] == this.element; ++i) {
        }
        return i - this.firstAttribute;
    }

    public int getFingerprint(int index2) {
        int nc = this.tree.attCode[this.firstAttribute + index2];
        return nc == -1 ? -1 : nc & 0xFFFFF;
    }

    public NodeName getNodeName(int index2) {
        return new CodedName(this.tree.attCode[this.firstAttribute + index2], this.getPrefix(index2), this.tree.getNamePool());
    }

    public SimpleType getTypeAnnotation(int index2) {
        if (this.tree.attType == null) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        return this.tree.getAttributeType(this.firstAttribute + index2);
    }

    public Location getLocation(int index2) {
        return ExplicitLocation.UNKNOWN_LOCATION;
    }

    public String getSystemId(int index2) {
        return this.tree.getSystemId(this.element);
    }

    public int getLineNumber(int index2) {
        return -1;
    }

    public int getProperties(int index2) {
        return 0;
    }

    public String getPrefix(int index2) {
        return this.tree.prefixPool.getPrefix(this.tree.attCode[this.firstAttribute + index2] >> 20);
    }

    public String getQName(int index2) {
        return this.getNodeName(index2).getDisplayName();
    }

    public String getLocalName(int index2) {
        return this.tree.getNamePool().getLocalName(this.tree.attCode[this.firstAttribute + index2]);
    }

    public String getURI(int index2) {
        return this.tree.getNamePool().getURI(this.tree.attCode[this.firstAttribute + index2]);
    }

    public int getIndex(String uri, String localname) {
        int fingerprint = this.tree.getNamePool().getFingerprint(uri, localname);
        return this.getIndexByFingerprint(fingerprint);
    }

    public int getIndexByFingerprint(int fingerprint) {
        int i = this.firstAttribute;
        while (this.tree.attParent[i] == this.element) {
            if ((this.tree.attCode[i] & 0xFFFFF) == fingerprint) {
                return i - this.firstAttribute;
            }
            ++i;
        }
        return -1;
    }

    public String getValueByFingerprint(int fingerprint) {
        return this.getValue(this.getIndexByFingerprint(fingerprint));
    }

    public String getValue(String uri, String localname) {
        return this.getValue(this.getIndex(uri, localname));
    }

    public String getValue(int index2) {
        CharSequence cs = this.tree.attValue[this.firstAttribute + index2];
        return cs == null ? null : cs.toString();
    }

    public boolean isId(int index2) {
        return this.getTypeAnnotation(index2).getFingerprint() == 560 || (this.tree.attCode[this.firstAttribute + index2] & 0xFFFFF) == 388;
    }

    public boolean isIdref(int index2) {
        return this.getTypeAnnotation(index2).getFingerprint() == 561 || this.getTypeAnnotation(index2).getFingerprint() == 562;
    }
}

