/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIteratorImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.z.IntPredicate;

final class PrecedingSiblingIterator
extends AxisIteratorImpl {
    private TinyTree document;
    private TinyNodeImpl startNode;
    private int nextNodeNr;
    private NodeTest test;
    private TinyNodeImpl parentNode;
    private final IntPredicate matcher;

    PrecedingSiblingIterator(TinyTree doc, TinyNodeImpl node, NodeTest nodeTest) {
        this.document = doc;
        this.document.ensurePriorIndex();
        this.test = nodeTest;
        this.startNode = node;
        this.nextNodeNr = node.nodeNr;
        this.parentNode = node.parent;
        this.matcher = nodeTest.getMatcher(doc);
    }

    public NodeInfo next() {
        if (this.nextNodeNr < 0) {
            return null;
        }
        do {
            this.nextNodeNr = this.document.prior[this.nextNodeNr];
            if (this.nextNodeNr >= 0) continue;
            return null;
        } while (!this.matcher.matches(this.nextNodeNr));
        TinyNodeImpl next2 = this.document.getNode(this.nextNodeNr);
        next2.setParentNode(this.parentNode);
        return next2;
    }
}

