/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import net.sf.saxon.tree.tiny.AppendableCharSequence;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.tree.util.FastStringBuffer;

public final class LargeStringBuffer
implements AppendableCharSequence {
    private static final int BITS = 16;
    private static final int SEGLEN = 65536;
    private static final int MASK = 65535;
    private char[][] data = new char[1][];
    private int length = 0;
    private int segmentsUsed = 0;

    private void addSegment(char[] seg) {
        int segs = this.data.length;
        if (this.segmentsUsed + 1 > segs) {
            if (this.segmentsUsed == 32768) {
                throw new IllegalStateException("Source document too large: more than 1G characters in text nodes");
            }
            this.data = (char[][])Arrays.copyOf(this.data, segs * 2);
        }
        this.data[this.segmentsUsed++] = seg;
    }

    public void append(CharSequence s2) {
        int lastSegLen;
        int fullSegments;
        int firstSegLen;
        char[] firstSeg;
        if (s2 instanceof CompressedWhitespace) {
            FastStringBuffer fsb = new FastStringBuffer(64);
            ((CompressedWhitespace)s2).uncompress(fsb);
            this.append(fsb);
            return;
        }
        int len = s2.length();
        int firstSegOffset = this.length & 0xFFFF;
        if (firstSegOffset == 0) {
            firstSeg = new char[65536];
            this.addSegment(firstSeg);
        } else {
            firstSeg = this.data[this.length >> 16];
        }
        if (len <= 65536 - firstSegOffset) {
            firstSegLen = len;
            fullSegments = 0;
            lastSegLen = 0;
        } else {
            firstSegLen = 65536 - firstSegOffset;
            fullSegments = len - firstSegLen >> 16;
            lastSegLen = len - firstSegLen & 0xFFFF;
        }
        if (s2 instanceof CharSlice) {
            ((CharSlice)s2).getChars(0, firstSegLen, firstSeg, firstSegOffset);
            int start = firstSegLen;
            for (int i = 0; i < fullSegments; ++i) {
                char[] seg = new char[65536];
                this.addSegment(seg);
                ((CharSlice)s2).getChars(start, start + 65536, seg, 0);
                start += 65536;
            }
            if (lastSegLen > 0) {
                char[] seg = new char[65536];
                this.addSegment(seg);
                ((CharSlice)s2).getChars(start, len, seg, 0);
            }
            this.length += len;
        } else if (s2 instanceof FastStringBuffer) {
            ((FastStringBuffer)s2).getChars(0, firstSegLen, firstSeg, firstSegOffset);
            int start = firstSegLen;
            for (int i = 0; i < fullSegments; ++i) {
                char[] seg = new char[65536];
                this.addSegment(seg);
                ((FastStringBuffer)s2).getChars(start, start + 65536, seg, 0);
                start += 65536;
            }
            if (lastSegLen > 0) {
                char[] seg = new char[65536];
                this.addSegment(seg);
                ((FastStringBuffer)s2).getChars(start, len, seg, 0);
            }
            this.length += len;
        } else {
            if (!(s2 instanceof String)) {
                s2 = s2.toString();
            }
            ((String)s2).getChars(0, firstSegLen, firstSeg, firstSegOffset);
            int start = firstSegLen;
            for (int i = 0; i < fullSegments; ++i) {
                char[] seg = new char[65536];
                this.addSegment(seg);
                ((String)s2).getChars(start, start + 65536, seg, 0);
                start += 65536;
            }
            if (lastSegLen > 0) {
                char[] seg = new char[65536];
                this.addSegment(seg);
                ((String)s2).getChars(start, len, seg, 0);
            }
            this.length += len;
        }
    }

    public int length() {
        return this.length;
    }

    public void setLength(int length) {
        if (length < this.length) {
            int usedInLastSegment = length & 0xFFFF;
            this.length = length;
            this.segmentsUsed = length / 65536 + (usedInLastSegment == 0 ? 0 : 1);
        }
    }

    public char charAt(int index2) {
        if (index2 < 0 || index2 >= this.length) {
            throw new IndexOutOfBoundsException(index2 + "");
        }
        return this.data[index2 >> 16][index2 & 0xFFFF];
    }

    public CharSequence subSequence(int start, int end) {
        int firstSeg = start >> 16;
        int lastSeg = end - 1 >> 16;
        if (firstSeg == lastSeg) {
            return new CharSlice(this.data[firstSeg], start & 0xFFFF, end - start);
        }
        FastStringBuffer fsb = new FastStringBuffer(end - start);
        int firstSegLen = 65536 - (start & 0xFFFF);
        fsb.append(this.data[firstSeg], start & 0xFFFF, firstSegLen);
        int doneTo = start + firstSegLen;
        while (true) {
            ++firstSeg;
            if (doneTo + 65536 >= end) break;
            fsb.append(this.data[firstSeg]);
            doneTo += 65536;
        }
        fsb.append(this.data[firstSeg], 0, end - doneTo);
        return fsb;
    }

    public String toString() {
        return this.subSequence(0, this.length).toString();
    }

    public boolean equals(Object other) {
        return other instanceof CharSequence && this.toString().equals(other.toString());
    }

    public int hashCode() {
        int h = 0;
        for (char[] chars : this.data) {
            for (int i = 0; i < 65536; ++i) {
                h = 31 * h + chars[i];
            }
        }
        return h;
    }

    public String substring(int start, int end) {
        return this.subSequence(start, end).toString();
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.toString());
    }
}

