/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import java.util.Arrays;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.linked.ChildEnumeration;
import net.sf.saxon.tree.linked.CommentImpl;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.linked.ProcInstImpl;
import net.sf.saxon.tree.linked.TextImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;

abstract class ParentNodeImpl
extends NodeImpl {
    private Object children = null;
    private int sequence;

    ParentNodeImpl() {
    }

    protected final long getSequenceNumber() {
        return this.getRawSequenceNumber() == -1 ? -1L : (long)this.getRawSequenceNumber() << 32;
    }

    protected final int getRawSequenceNumber() {
        return this.sequence;
    }

    protected final void setRawSequenceNumber(int seq) {
        this.sequence = seq;
    }

    protected final void setChildren(Object children) {
        this.children = children;
    }

    public final boolean hasChildNodes() {
        return this.children != null;
    }

    public final int getNumberOfChildren() {
        if (this.children == null) {
            return 0;
        }
        if (this.children instanceof NodeImpl) {
            return 1;
        }
        return ((NodeInfo[])this.children).length;
    }

    protected final AxisIterator iterateChildren(NodeTest test) {
        if (this.children == null) {
            return EmptyIterator.OfNodes.THE_INSTANCE;
        }
        if (this.children instanceof NodeImpl) {
            NodeImpl child = (NodeImpl)this.children;
            if (test == null || test == AnyNodeTest.getInstance()) {
                return SingleNodeIterator.makeIterator(child);
            }
            return Navigator.filteredSingleton(child, test);
        }
        if (test == null || test == AnyNodeTest.getInstance()) {
            return new ArrayIterator.OfNodes((NodeImpl[])this.children);
        }
        return new ChildEnumeration(this, test);
    }

    public final NodeImpl getFirstChild() {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return (NodeImpl)this.children;
        }
        return ((NodeImpl[])this.children)[0];
    }

    public final NodeImpl getLastChild() {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return (NodeImpl)this.children;
        }
        NodeImpl[] n = (NodeImpl[])this.children;
        return n[n.length - 1];
    }

    protected final NodeImpl getNthChild(int n) {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return n == 0 ? (NodeImpl)this.children : null;
        }
        NodeImpl[] nodes = (NodeImpl[])this.children;
        if (n < 0 || n >= nodes.length) {
            return null;
        }
        return nodes[n];
    }

    protected void removeChild(NodeImpl child) {
        if (this.children == null) {
            return;
        }
        if (this.children == child) {
            this.children = null;
            return;
        }
        NodeImpl[] nodes = (NodeImpl[])this.children;
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] != child) continue;
            if (nodes.length == 2) {
                this.children = nodes[1 - i];
                break;
            }
            NodeImpl[] n2 = new NodeImpl[nodes.length - 1];
            if (i > 0) {
                System.arraycopy(nodes, 0, n2, 0, i);
            }
            if (i < nodes.length - 1) {
                System.arraycopy(nodes, i + 1, n2, i, nodes.length - i - 1);
            }
            this.children = this.cleanUpChildren(n2);
            break;
        }
    }

    private NodeImpl[] cleanUpChildren(NodeImpl[] children) {
        boolean prevText = false;
        int j = 0;
        NodeImpl[] c2 = new NodeImpl[children.length];
        for (int i = 0; i < children.length; ++i) {
            NodeImpl node = children[i];
            if (node instanceof TextImpl) {
                if (prevText) {
                    TextImpl prev = (TextImpl)c2[j - 1];
                    prev.replaceStringValue(prev.getStringValue() + node.getStringValue());
                    continue;
                }
                if (node.getStringValue().length() <= 0) continue;
                prevText = true;
                node.setSiblingPosition(j);
                c2[j++] = node;
                continue;
            }
            node.setSiblingPosition(j);
            c2[j++] = node;
            prevText = false;
        }
        if (j == c2.length) {
            return c2;
        }
        return Arrays.copyOf(c2, j);
    }

    public String getStringValue() {
        return this.getStringValueCS().toString();
    }

    public CharSequence getStringValueCS() {
        FastStringBuffer sb = null;
        for (NodeImpl next2 = this.getFirstChild(); next2 != null; next2 = next2.getNextInDocument(this)) {
            if (!(next2 instanceof TextImpl)) continue;
            if (sb == null) {
                sb = new FastStringBuffer(64);
            }
            sb.append(next2.getStringValueCS());
        }
        if (sb == null) {
            return "";
        }
        return sb.condense();
    }

    protected synchronized void addChild(NodeImpl node, int index2) {
        NodeImpl[] c;
        if (this.children == null) {
            c = new NodeImpl[10];
        } else if (this.children instanceof NodeImpl) {
            c = new NodeImpl[10];
            c[0] = (NodeImpl)this.children;
        } else {
            c = (NodeImpl[])this.children;
        }
        if (index2 >= c.length) {
            c = Arrays.copyOf(c, c.length * 2);
        }
        c[index2] = node;
        node.setRawParent(this);
        node.setSiblingPosition(index2);
        this.children = c;
    }

    public void insertChildren(NodeInfo[] source, boolean atStart, boolean inherit) {
        if (atStart) {
            this.insertChildrenAt(source, 0, inherit);
        } else {
            this.insertChildrenAt(source, this.getNumberOfChildren(), inherit);
        }
    }

    protected synchronized void insertChildrenAt(NodeInfo[] source, int index2, boolean inherit) {
        NodeImpl[] n2;
        if (source.length == 0) {
            return;
        }
        for (int i = 0; i < source.length; ++i) {
            source[i] = this.convertForeignNode(source[i]);
            NodeImpl child = (NodeImpl)source[i];
            child.setRawParent(this);
            if (!(child instanceof ElementImpl)) continue;
            ((ElementImpl)child).fixupInsertedNamespaces(inherit);
        }
        if (this.children == null) {
            if (source.length == 1) {
                this.children = source[0];
            } else {
                NodeImpl[] n22 = new NodeImpl[source.length];
                System.arraycopy(source, 0, n22, 0, source.length);
                this.children = n22;
            }
        } else if (this.children instanceof NodeImpl) {
            int adjacent;
            int n = adjacent = index2 == 0 ? source.length - 1 : 0;
            if (this.children instanceof TextImpl && source[adjacent] instanceof TextImpl) {
                if (index2 == 0) {
                    ((TextImpl)source[adjacent]).replaceStringValue(source[adjacent].getStringValue() + ((TextImpl)this.children).getStringValue());
                } else {
                    ((TextImpl)source[adjacent]).replaceStringValue(((TextImpl)this.children).getStringValue() + source[adjacent].getStringValue());
                }
                this.children = Arrays.copyOf(source, source.length);
            } else {
                n2 = new NodeImpl[source.length + 1];
                if (index2 == 0) {
                    System.arraycopy(source, 0, n2, 0, source.length);
                    n2[source.length] = (NodeImpl)this.children;
                } else {
                    n2[0] = (NodeImpl)this.children;
                    System.arraycopy(source, 0, n2, 1, source.length);
                }
                this.children = this.cleanUpChildren(n2);
            }
        } else {
            NodeImpl[] n0 = (NodeImpl[])this.children;
            n2 = new NodeImpl[n0.length + source.length];
            System.arraycopy(n0, 0, n2, 0, index2);
            System.arraycopy(source, 0, n2, index2, source.length);
            System.arraycopy(n0, index2, n2, index2 + source.length, n0.length - index2);
            this.children = this.cleanUpChildren(n2);
        }
    }

    private NodeImpl convertForeignNode(NodeInfo source) {
        if (!(source instanceof NodeImpl)) {
            int kind = source.getNodeKind();
            switch (kind) {
                case 3: {
                    return new TextImpl(source.getStringValue());
                }
                case 8: {
                    return new CommentImpl(source.getStringValue());
                }
                case 7: {
                    return new ProcInstImpl(source.getLocalPart(), source.getStringValue());
                }
                case 1: {
                    throw new IllegalArgumentException("Cannot insert an element node unless it is an instance of net.sf.saxon.om.tree.ElementImpl");
                }
            }
            throw new IllegalArgumentException("Cannot insert a node unless it is an element, comment, text node, or processing instruction");
        }
        return (NodeImpl)source;
    }

    protected synchronized void replaceChildrenAt(NodeInfo[] source, int index2, boolean inherit) {
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < source.length; ++i) {
            source[i] = this.convertForeignNode(source[i]);
            NodeImpl child = (NodeImpl)source[i];
            child.setRawParent(this);
            if (!(child instanceof ElementImpl)) continue;
            ((ElementImpl)child).fixupInsertedNamespaces(inherit);
        }
        if (this.children instanceof NodeImpl) {
            if (source.length == 0) {
                this.children = null;
            } else if (source.length == 1) {
                this.children = source[0];
            } else {
                NodeImpl[] n2 = new NodeImpl[source.length];
                System.arraycopy(source, 0, n2, 0, source.length);
                this.children = this.cleanUpChildren(n2);
            }
        } else {
            NodeImpl[] n0 = (NodeImpl[])this.children;
            NodeImpl[] n2 = new NodeImpl[n0.length + source.length - 1];
            System.arraycopy(n0, 0, n2, 0, index2);
            System.arraycopy(source, 0, n2, index2, source.length);
            System.arraycopy(n0, index2 + 1, n2, index2 + source.length, n0.length - index2 - 1);
            this.children = this.cleanUpChildren(n2);
        }
    }

    public synchronized void compact(int size2) {
        if (size2 == 0) {
            this.children = null;
        } else if (size2 == 1) {
            if (this.children instanceof NodeImpl[]) {
                this.children = ((NodeImpl[])this.children)[0];
            }
        } else {
            this.children = Arrays.copyOf((NodeImpl[])this.children, size2);
        }
    }
}

