/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import java.util.Arrays;

public class LineNumberMap {
    private int[] sequenceNumbers = new int[200];
    private int[] lineNumbers = new int[200];
    private int[] columnNumbers = new int[200];
    private int allocated = 0;

    public void setLineAndColumn(int sequence2, int line, int column) {
        if (this.sequenceNumbers.length <= this.allocated + 1) {
            this.sequenceNumbers = Arrays.copyOf(this.sequenceNumbers, this.allocated * 2);
            this.lineNumbers = Arrays.copyOf(this.lineNumbers, this.allocated * 2);
            this.columnNumbers = Arrays.copyOf(this.columnNumbers, this.allocated * 2);
        }
        this.sequenceNumbers[this.allocated] = sequence2;
        this.lineNumbers[this.allocated] = line;
        this.columnNumbers[this.allocated] = column;
        ++this.allocated;
    }

    public int getLineNumber(int sequence2) {
        int index2;
        if (this.sequenceNumbers.length > this.allocated) {
            this.condense();
        }
        if ((index2 = Arrays.binarySearch(this.sequenceNumbers, sequence2)) < 0 && (index2 = -index2 - 1) > this.lineNumbers.length - 1) {
            index2 = this.lineNumbers.length - 1;
        }
        return this.lineNumbers[index2];
    }

    public int getColumnNumber(int sequence2) {
        int index2;
        if (this.sequenceNumbers.length > this.allocated) {
            this.condense();
        }
        if ((index2 = Arrays.binarySearch(this.sequenceNumbers, sequence2)) < 0 && (index2 = -index2 - 1) >= this.columnNumbers.length) {
            index2 = this.columnNumbers.length - 1;
        }
        return this.columnNumbers[index2];
    }

    private synchronized void condense() {
        this.sequenceNumbers = Arrays.copyOf(this.sequenceNumbers, this.allocated);
        this.lineNumbers = Arrays.copyOf(this.lineNumbers, this.allocated);
        this.columnNumbers = Arrays.copyOf(this.columnNumbers, this.allocated);
    }
}

