/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.One;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.value.EmptySequence;

public class SingleNodeIterator
implements AxisIterator,
ReversibleIterator,
LastPositionFinder,
GroundedIterator,
LookaheadIterator {
    private NodeInfo item;
    private int position = 0;

    private SingleNodeIterator(NodeInfo value2) {
        this.item = value2;
    }

    public static AxisIterator makeIterator(NodeInfo item) {
        if (item == null) {
            return EmptyIterator.OfNodes.THE_INSTANCE;
        }
        return new SingleNodeIterator(item);
    }

    public boolean hasNext() {
        return this.position == 0;
    }

    public NodeInfo next() {
        if (this.position == 0) {
            this.position = 1;
            return this.item;
        }
        if (this.position == 1) {
            this.position = -1;
            return null;
        }
        return null;
    }

    public int getLength() {
        return 1;
    }

    public void close() {
    }

    public SequenceIterator getReverseIterator() {
        return new SingleNodeIterator(this.item);
    }

    public Item getValue() {
        return this.item;
    }

    public GroundedValue materialize() {
        return new ZeroOrOne<NodeInfo>(this.item);
    }

    public GroundedValue getResidue() throws XPathException {
        return this.item == null ? EmptySequence.getInstance() : new One<NodeInfo>(this.item);
    }

    public int getProperties() {
        return 7;
    }
}

