/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;

public class SingleAtomicIterator
implements SequenceIterator,
AtomicIterator,
ReversibleIterator,
LastPositionFinder,
GroundedIterator,
LookaheadIterator {
    private AtomicValue item;
    boolean gone = false;

    public SingleAtomicIterator(AtomicValue value2) {
        if (value2 == null) {
            throw new NullPointerException();
        }
        this.item = value2;
    }

    public boolean hasNext() {
        return !this.gone;
    }

    public AtomicValue next() {
        if (this.gone) {
            return null;
        }
        this.gone = true;
        return this.item;
    }

    public int getLength() {
        return 1;
    }

    public void close() {
    }

    public SingleAtomicIterator getReverseIterator() {
        return new SingleAtomicIterator(this.item);
    }

    public GroundedValue materialize() {
        return this.item;
    }

    public GroundedValue getResidue() throws XPathException {
        return this.gone ? EmptySequence.getInstance() : this.item;
    }

    public int getProperties() {
        return 7;
    }
}

