/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReverseListIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListIterator
implements UnfailingIterator,
LastPositionFinder,
LookaheadIterator,
GroundedIterator,
ReversibleIterator {
    private int index = 0;
    protected List<? extends Item> list;

    public ListIterator(List<? extends Item> list2) {
        this.list = list2;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.list.size();
    }

    @Override
    public Item next() {
        if (this.index >= this.list.size()) {
            return null;
        }
        return this.list.get(this.index++);
    }

    @Override
    public void close() {
    }

    @Override
    public int getLength() {
        return this.list.size();
    }

    @Override
    public int getProperties() {
        return 7;
    }

    @Override
    public GroundedValue materialize() {
        return SequenceExtent.makeSequenceExtent(this.list);
    }

    @Override
    public GroundedValue getResidue() throws XPathException {
        List<? extends Item> l2 = this.list;
        if (this.index != 0) {
            l2 = l2.subList(this.index, l2.size());
        }
        return SequenceExtent.makeSequenceExtent(l2);
    }

    @Override
    public SequenceIterator getReverseIterator() {
        return new ReverseListIterator(this.list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OfNodes
    extends ListIterator
    implements AxisIterator {
        public OfNodes(List<? extends NodeInfo> list2) {
            super(list2);
        }

        @Override
        public NodeInfo next() {
            return (NodeInfo)super.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Atomic
    extends ListIterator
    implements AtomicIterator {
        public Atomic(List<AtomicValue> list2) {
            super(list2);
        }

        @Override
        public AtomicValue next() {
            return (AtomicValue)super.next();
        }
    }
}

