/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;

public class XPathException
extends TransformerException {
    private boolean isTypeError = false;
    private boolean isSyntaxError = false;
    private boolean isStaticError = false;
    private boolean isGlobalError = false;
    private String hostLanguage = null;
    private StructuredQName errorCode;
    private Sequence errorObject;
    private boolean hasBeenReported = false;
    transient XPathContext context;

    public XPathException(String message) {
        super(message);
    }

    public XPathException(Throwable err2) {
        super(err2);
    }

    public XPathException(String message, Throwable err2) {
        super(message, err2);
    }

    public XPathException(String message, String errorCode, Location loc) {
        this(message, errorCode);
        this.setLocator(loc);
    }

    public XPathException(String message, Location loc, Throwable err2) {
        super(message, loc, err2);
    }

    public XPathException(String message, String errorCode) {
        super(message);
        this.setErrorCode(errorCode);
    }

    public XPathException(String message, String errorCode, XPathContext context) {
        super(message);
        this.setErrorCode(errorCode);
        this.setXPathContext(context);
    }

    public static XPathException makeXPathException(Exception err2) {
        if (err2 instanceof XPathException) {
            return (XPathException)err2;
        }
        if (err2.getCause() instanceof XPathException) {
            return (XPathException)err2.getCause();
        }
        if (err2 instanceof TransformerException) {
            XPathException xe = new XPathException(err2.getMessage(), err2);
            xe.setLocator(((TransformerException)err2).getLocator());
            return xe;
        }
        return new XPathException(err2);
    }

    public void setXPathContext(XPathContext context) {
        this.context = context;
    }

    public void setLocation(Location loc) {
        this.setLocator(loc.saveLocation());
    }

    public Location getLocator() {
        SourceLocator locator = super.getLocator();
        if (locator == null) {
            return null;
        }
        if (locator instanceof Location) {
            return (Location)locator;
        }
        return new ExplicitLocation(locator);
    }

    public XPathContext getXPathContext() {
        return this.context;
    }

    public void setIsStaticError(boolean is) {
        this.isStaticError = is;
    }

    public boolean isStaticError() {
        return this.isStaticError;
    }

    public void setIsSyntaxError(boolean is) {
        if (is) {
            this.isStaticError = true;
        }
        this.isSyntaxError = is;
    }

    public boolean isSyntaxError() {
        return this.isSyntaxError;
    }

    public void setIsTypeError(boolean is) {
        this.isTypeError = is;
    }

    public boolean isTypeError() {
        return this.isTypeError;
    }

    public void setIsGlobalError(boolean is) {
        this.isGlobalError = is;
    }

    public boolean isGlobalError() {
        return this.isGlobalError;
    }

    public void setHostLanguage(String language2) {
        this.hostLanguage = language2;
    }

    public String getHostLanguage() {
        return this.hostLanguage;
    }

    public void setErrorCode(String code) {
        if (code != null) {
            this.errorCode = new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", code);
        }
    }

    public void maybeSetErrorCode(String code) {
        if (this.errorCode == null && code != null) {
            this.errorCode = new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", code);
        }
    }

    public void setErrorCodeQName(StructuredQName code) {
        this.errorCode = code;
    }

    public StructuredQName getErrorCodeQName() {
        return this.errorCode;
    }

    public String getErrorCodeLocalPart() {
        return this.errorCode == null ? null : this.errorCode.getLocalPart();
    }

    public String getErrorCodeNamespace() {
        return this.errorCode == null ? null : this.errorCode.getURI();
    }

    public void setErrorObject(Sequence value2) {
        this.errorObject = value2;
    }

    public Sequence getErrorObject() {
        return this.errorObject;
    }

    public void setHasBeenReported(boolean reported) {
        this.hasBeenReported = reported;
    }

    public boolean hasBeenReported() {
        return this.hasBeenReported;
    }

    public void maybeSetLocation(Location here) {
        if (here != null) {
            if (this.getLocator() == null) {
                this.setLocator(here.saveLocation());
            } else if (this.getLocator().getLineNumber() == -1 && (this.getLocator().getSystemId() == null || here.getSystemId() == null || this.getLocator().getSystemId().equals(here.getSystemId()))) {
                this.setLocator(here.saveLocation());
            }
        }
    }

    public void maybeSetContext(XPathContext context) {
        if (this.getXPathContext() == null) {
            this.setXPathContext(context);
        }
    }

    public boolean isReportableStatically() {
        if (this.isStaticError() || this.isTypeError()) {
            return true;
        }
        StructuredQName err2 = this.errorCode;
        if (err2 != null && err2.hasURI("http://www.w3.org/2005/xqt-errors")) {
            String local = err2.getLocalPart();
            return local.equals("XTDE1260") || local.equals("XTDE1280") || local.equals("XTDE1390") || local.equals("XTDE1400") || local.equals("XTDE1428") || local.equals("XTDE1440") || local.equals("XTDE1460");
        }
        return false;
    }

    public static class Circularity
    extends XPathException {
        public Circularity(String message) {
            super(message);
        }
    }
}

