/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecimalFormatManager {
    private DecimalSymbols defaultDFS;
    private HashMap<StructuredQName, DecimalSymbols> formatTable = new HashMap(10);
    private int language;
    private int languageLevel;

    public DecimalFormatManager(int language2, int languageLevel) {
        this.defaultDFS = new DecimalSymbols(language2, languageLevel);
        this.language = language2;
        this.languageLevel = languageLevel;
    }

    public DecimalSymbols getDefaultDecimalFormat() {
        return this.defaultDFS;
    }

    public DecimalSymbols getNamedDecimalFormat(StructuredQName qName) {
        DecimalSymbols ds = this.formatTable.get(qName);
        if (ds == null) {
            return null;
        }
        return ds;
    }

    public DecimalSymbols obtainNamedDecimalFormat(StructuredQName qName) {
        DecimalSymbols ds = this.formatTable.get(qName);
        if (ds == null) {
            ds = new DecimalSymbols(this.language, this.languageLevel);
            this.formatTable.put(qName, ds);
        }
        return ds;
    }

    public Iterable<StructuredQName> getDecimalFormatNames() {
        return this.formatTable.keySet();
    }

    public void checkConsistency() throws XPathException {
        this.defaultDFS.checkConsistency(null);
        for (Map.Entry<StructuredQName, DecimalSymbols> entry2 : this.formatTable.entrySet()) {
            entry2.getValue().checkConsistency(entry2.getKey());
        }
    }
}

