/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.File;
import java.math.BigDecimal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.lib.Initializer;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmEmptySequence;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlCatalogResolver;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.NumericValue;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineOptions {
    public static final int TYPE_BOOLEAN = 1;
    public static final int TYPE_FILENAME = 2;
    public static final int TYPE_CLASSNAME = 3;
    public static final int TYPE_ENUMERATION = 4;
    public static final int TYPE_INTEGER = 5;
    public static final int TYPE_QNAME = 6;
    public static final int TYPE_FILENAME_LIST = 7;
    public static final int TYPE_DATETIME = 8;
    public static final int TYPE_STRING = 9;
    public static final int TYPE_INTEGER_PAIR = 10;
    public static final int VALUE_REQUIRED = 256;
    public static final int VALUE_PROHIBITED = 512;
    HashMap<String, Integer> recognizedOptions = new HashMap();
    HashMap<String, String> optionHelp = new HashMap();
    protected Properties namedOptions = new Properties();
    Properties configOptions = new Properties();
    Map<String, Set<String>> permittedValues = new HashMap<String, Set<String>>();
    Map<String, String> defaultValues = new HashMap<String, String>();
    List<String> positionalOptions = new ArrayList<String>();
    Properties paramValues = new Properties();
    Properties paramExpressions = new Properties();
    Properties paramFiles = new Properties();
    Properties serializationParams = new Properties();
    private static DayTimeDurationValue milliSecond = new DayTimeDurationValue(1, 0, 0, 0, 0L, 1000);

    public void addRecognizedOption(String option, int optionProperties, String helpText) {
        this.recognizedOptions.put(option, optionProperties);
        this.optionHelp.put(option, helpText);
        if ((optionProperties & 0xFF) == 1) {
            this.setPermittedValues(option, new String[]{"on", "off"}, "on");
        }
    }

    public void setPermittedValues(String option, String[] values, String defaultValue) {
        HashSet<String> valueSet = new HashSet<String>();
        valueSet.addAll(Arrays.asList(values));
        this.permittedValues.put(option, valueSet);
        if (defaultValue != null) {
            this.defaultValues.put(option, defaultValue);
        }
    }

    private static String displayPermittedValues(Set<String> permittedValues) {
        FastStringBuffer sb = new FastStringBuffer(20);
        for (String val : permittedValues) {
            if ("".equals(val)) {
                sb.append("\"\"");
            } else {
                sb.append(val);
            }
            sb.append('|');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public void setActualOptions(String[] args) throws XPathException {
        for (String arg : args) {
            if ("-".equals(arg)) {
                this.positionalOptions.add(arg);
                continue;
            }
            if (arg.charAt(0) == '-') {
                String msg;
                int prop;
                String option;
                int colon2;
                String value2 = "";
                if (arg.length() > 5 && arg.charAt(1) == '-') {
                    colon2 = arg.indexOf(58);
                    if (colon2 > 0 && colon2 < arg.length() - 1) {
                        option = arg.substring(2, colon2);
                        value2 = arg.substring(colon2 + 1);
                        this.configOptions.setProperty(option, value2);
                        continue;
                    }
                    if (colon2 > 0 && colon2 == arg.length() - 1) {
                        option = arg.substring(2, colon2);
                        this.configOptions.setProperty(option, "");
                        continue;
                    }
                    option = arg.substring(2);
                    this.configOptions.setProperty(option, "true");
                    continue;
                }
                colon2 = arg.indexOf(58);
                if (colon2 > 0 && colon2 < arg.length() - 1) {
                    option = arg.substring(1, colon2);
                    value2 = arg.substring(colon2 + 1);
                } else {
                    option = arg.substring(1);
                }
                if (this.recognizedOptions.get(option) == null) {
                    throw new XPathException("Command line option -" + option + " is not recognized. Options available: " + this.displayPermittedOptions());
                }
                if (this.namedOptions.getProperty(option) != null) {
                    throw new XPathException("Command line option -" + option + " appears more than once");
                }
                if ("?".equals(value2)) {
                    this.displayOptionHelp(option);
                    throw new XPathException("No processing requested");
                }
                if ("".equals(value2)) {
                    prop = this.recognizedOptions.get(option);
                    if ((prop & 0x100) != 0) {
                        msg = "Command line option -" + option + " requires a value";
                        if (this.permittedValues.get(option) != null) {
                            msg = msg + ": permitted values are " + CommandLineOptions.displayPermittedValues(this.permittedValues.get(option));
                        }
                        throw new XPathException(msg);
                    }
                    String defaultValue = this.defaultValues.get(option);
                    if (defaultValue != null) {
                        value2 = defaultValue;
                    }
                } else {
                    prop = this.recognizedOptions.get(option);
                    if ((prop & 0x200) != 0) {
                        msg = "Command line option -" + option + " does not expect a value";
                        throw new XPathException(msg);
                    }
                }
                Set<String> permitted = this.permittedValues.get(option);
                if (permitted != null && !permitted.contains(value2)) {
                    throw new XPathException("Bad option value " + arg + ": permitted values are " + CommandLineOptions.displayPermittedValues(permitted));
                }
                this.namedOptions.setProperty(option, value2);
                continue;
            }
            int eq2 = arg.indexOf(61);
            if (eq2 >= 1) {
                char ch;
                String keyword2 = arg.substring(0, eq2);
                String value3 = "";
                if (eq2 < arg.length() - 1) {
                    value3 = arg.substring(eq2 + 1);
                }
                if ((ch = arg.charAt(0)) == '!' && eq2 >= 2) {
                    this.serializationParams.setProperty(keyword2.substring(1), value3);
                    continue;
                }
                if (ch == '?' && eq2 >= 2) {
                    this.paramExpressions.setProperty(keyword2.substring(1), value3);
                    continue;
                }
                if (ch == '+' && eq2 >= 2) {
                    this.paramFiles.setProperty(keyword2.substring(1), value3);
                    continue;
                }
                this.paramValues.setProperty(keyword2, value3);
                continue;
            }
            this.positionalOptions.add(arg);
        }
    }

    public boolean definesParameterValues() {
        return !this.serializationParams.isEmpty() || !this.paramExpressions.isEmpty() || !this.paramFiles.isEmpty() || !this.paramValues.isEmpty();
    }

    public boolean testIfSchemaAware() {
        return this.getOptionValue("sa") != null || this.getOptionValue("outval") != null || this.getOptionValue("val") != null || this.getOptionValue("vlax") != null || this.getOptionValue("xsd") != null || this.getOptionValue("xsdversion") != null;
    }

    public void applyToConfiguration(Processor processor) throws TransformerException {
        Object resolver;
        Configuration config = processor.getUnderlyingConfiguration();
        Enumeration<?> e = this.configOptions.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value2 = this.configOptions.getProperty(name);
            try {
                processor.setConfigurationProperty("http://saxon.sf.net/feature/" + name, value2);
            }
            catch (IllegalArgumentException err2) {
                throw new XPathException(err2.getMessage());
            }
        }
        String value3 = this.getOptionValue("catalog");
        if (value3 != null) {
            if (this.getOptionValue("r") != null) {
                throw new XPathException("Cannot use -catalog and -r together");
            }
            if (this.getOptionValue("x") != null) {
                throw new XPathException("Cannot use -catalog and -x together");
            }
            if (this.getOptionValue("y") != null) {
                throw new XPathException("Cannot use -catalog and -y together");
            }
            if (this.getOptionValue("u") != null || CommandLineOptions.isImplicitURI(value3)) {
                Source sourceInput = null;
                try {
                    sourceInput = config.getURIResolver().resolve(value3, null);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
                if (sourceInput == null) {
                    sourceInput = config.getSystemURIResolver().resolve(value3, null);
                }
                value3 = sourceInput.getSystemId();
            } else {
                value3 = new File(value3).toURI().toASCIIString();
            }
            try {
                config.getClass("org.apache.xml.resolver.CatalogManager", false, null);
                XmlCatalogResolver.setCatalog(value3, config, this.getOptionValue("t") != null);
            }
            catch (XPathException err3) {
                throw new XPathException("Failed to load Apache catalog resolver library", err3);
            }
        }
        if ((value3 = this.getOptionValue("cr")) != null) {
            resolver = config.getInstance(value3, null);
            processor.setConfigurationProperty("http://saxon.sf.net/feature/collection-uri-resolver", resolver);
        }
        if ((value3 = this.getOptionValue("dtd")) != null) {
            if ("on".equals(value3)) {
                config.setBooleanProperty("http://saxon.sf.net/feature/validation", true);
                config.getParseOptions().setDTDValidationMode(1);
            } else if ("off".equals(value3)) {
                config.setBooleanProperty("http://saxon.sf.net/feature/validation", false);
                config.getParseOptions().setDTDValidationMode(4);
            } else if ("recover".equals(value3)) {
                config.setBooleanProperty("http://saxon.sf.net/feature/validation", true);
                config.setBooleanProperty("http://saxon.sf.net/feature/dtd-validation-recoverable", true);
                config.getParseOptions().setDTDValidationMode(2);
            }
        }
        if ((value3 = this.getOptionValue("ea")) != null) {
            config.getDefaultXsltCompilerInfo().setAssertionsEnabled("on".equals(value3));
        }
        if ((value3 = this.getOptionValue("expand")) != null) {
            config.getParseOptions().setExpandAttributeDefaults("on".equals(value3));
        }
        if ((value3 = this.getOptionValue("ext")) != null) {
            config.setBooleanProperty("http://saxon.sf.net/feature/allow-external-functions", "on".equals(value3));
        }
        if ((value3 = this.getOptionValue("l")) != null) {
            config.setBooleanProperty("http://saxon.sf.net/feature/linenumbering", "on".equals(value3));
        }
        if ((value3 = this.getOptionValue("m")) != null) {
            config.setConfigurationProperty("http://saxon.sf.net/feature/messageEmitterClass", value3);
        }
        if ((value3 = this.getOptionValue("opt")) != null) {
            config.setConfigurationProperty("http://saxon.sf.net/feature/optimizationLevel", value3);
        }
        if ((value3 = this.getOptionValue("or")) != null) {
            resolver = config.getInstance(value3, null);
            config.setConfigurationProperty("http://saxon.sf.net/feature/outputURIResolver", resolver);
        }
        if ((value3 = this.getOptionValue("outval")) != null) {
            Boolean isRecover = "recover".equals(value3);
            config.setConfigurationProperty("http://saxon.sf.net/feature/validation-warnings", isRecover);
            config.setConfigurationProperty("http://saxon.sf.net/feature/validation-comments", isRecover);
        }
        if ((value3 = this.getOptionValue("r")) != null) {
            config.setURIResolver(config.makeURIResolver(value3));
        }
        if ((value3 = this.getOptionValue("strip")) != null) {
            config.setConfigurationProperty("http://saxon.sf.net/feature/strip-whitespace", value3);
        }
        if ((value3 = this.getOptionValue("T")) != null) {
            config.setCompileWithTracing(true);
        }
        if ((value3 = this.getOptionValue("TJ")) != null) {
            config.setBooleanProperty("http://saxon.sf.net/feature/trace-external-functions", "on".equals(value3));
        }
        if ((value3 = this.getOptionValue("tree")) != null) {
            if ("linked".equals(value3)) {
                config.setTreeModel(0);
            } else if ("tiny".equals(value3)) {
                config.setTreeModel(1);
            } else if ("tinyc".equals(value3)) {
                config.setTreeModel(2);
            }
        }
        if ((value3 = this.getOptionValue("val")) != null) {
            if ("strict".equals(value3)) {
                processor.setConfigurationProperty("http://saxon.sf.net/feature/schema-validation", 1);
            } else if ("lax".equals(value3)) {
                processor.setConfigurationProperty("http://saxon.sf.net/feature/schema-validation", 2);
            }
        }
        if ((value3 = this.getOptionValue("warnings")) != null) {
            if ("silent".equals(value3)) {
                processor.setConfigurationProperty("http://saxon.sf.net/feature/recoveryPolicy", 0);
            } else if ("recover".equals(value3)) {
                processor.setConfigurationProperty("http://saxon.sf.net/feature/recoveryPolicy", 1);
            } else if ("fatal".equals(value3)) {
                processor.setConfigurationProperty("http://saxon.sf.net/feature/recoveryPolicy", 2);
            }
        }
        if ((value3 = this.getOptionValue("x")) != null) {
            processor.setConfigurationProperty("http://saxon.sf.net/feature/sourceParserClass", value3);
        }
        if ((value3 = this.getOptionValue("xi")) != null) {
            processor.setConfigurationProperty("http://saxon.sf.net/feature/xinclude-aware", "on".equals(value3));
        }
        if ((value3 = this.getOptionValue("xmlversion")) != null) {
            processor.setConfigurationProperty("http://saxon.sf.net/feature/xml-version", value3);
        }
        if ((value3 = this.getOptionValue("xsdversion")) != null) {
            processor.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", value3);
        }
        if ((value3 = this.getOptionValue("xsiloc")) != null) {
            processor.setConfigurationProperty("http://saxon.sf.net/feature/useXsiSchemaLocation", "on".equals(value3));
        }
        if ((value3 = this.getOptionValue("y")) != null) {
            processor.setConfigurationProperty("http://saxon.sf.net/feature/styleParserClass", value3);
        }
        if ((value3 = this.getOptionValue("init")) != null) {
            Initializer initializer = (Initializer)config.getInstance(value3, null);
            initializer.initialize(config);
        }
    }

    public String displayPermittedOptions() {
        String[] options = new String[this.recognizedOptions.size()];
        options = new ArrayList<String>(this.recognizedOptions.keySet()).toArray(options);
        Arrays.sort(options, Collator.getInstance());
        FastStringBuffer sb = new FastStringBuffer(100);
        for (String opt2 : options) {
            sb.append(" -");
            sb.append(opt2);
        }
        return sb.toString();
    }

    private void displayOptionHelp(String option) {
        System.err.println("Help for -" + option + " option");
        int prop = this.recognizedOptions.get(option);
        if ((prop & 0x200) == 0) {
            switch (prop & 0xFF) {
                case 1: {
                    System.err.println("Value: on|off");
                    break;
                }
                case 5: {
                    System.err.println("Value: integer");
                    break;
                }
                case 2: {
                    System.err.println("Value: file name");
                    break;
                }
                case 7: {
                    System.err.println("Value: list of file names, semicolon-separated");
                    break;
                }
                case 3: {
                    System.err.println("Value: Java fully-qualified class name");
                    break;
                }
                case 6: {
                    System.err.println("Value: QName in Clark notation ({uri}local)");
                    break;
                }
                case 9: {
                    System.err.println("Value: string");
                    break;
                }
                case 10: {
                    System.err.println("Value: int,int");
                    break;
                }
                case 4: {
                    String message = "Value: one of ";
                    message = message + CommandLineOptions.displayPermittedValues(this.permittedValues.get(option));
                    System.err.println(message);
                    break;
                }
            }
        }
        System.err.println("Meaning: " + this.optionHelp.get(option));
    }

    public String getOptionValue(String option) {
        return this.namedOptions.getProperty(option);
    }

    public List<String> getPositionalOptions() {
        return this.positionalOptions;
    }

    public void setParams(Processor processor, ParamSetter paramSetter) throws SaxonApiException {
        String value2;
        String name;
        boolean useURLs = "on".equals(this.getOptionValue("u"));
        Enumeration<?> e = this.paramValues.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value2 = this.paramValues.getProperty(name);
            paramSetter.setParam(QName.fromClarkName(name), new XdmAtomicValue(value2, ItemType.UNTYPED_ATOMIC));
        }
        e = this.paramFiles.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value2 = this.paramFiles.getProperty(name);
            ArrayList<Source> sourceList = new ArrayList<Source>();
            CommandLineOptions.loadDocuments(value2, useURLs, processor, true, sourceList);
            if (sourceList.size() > 0) {
                ArrayList<XdmNode> nodeList = new ArrayList<XdmNode>(sourceList.size());
                DocumentBuilder builder = processor.newDocumentBuilder();
                for (Source s2 : sourceList) {
                    nodeList.add(builder.build(s2));
                }
                XdmValue nodes = new XdmValue(nodeList);
                paramSetter.setParam(QName.fromClarkName(name), nodes);
                continue;
            }
            paramSetter.setParam(QName.fromClarkName(name), XdmEmptySequence.getInstance());
        }
        e = this.paramExpressions.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value2 = this.paramExpressions.getProperty(name);
            XPathCompiler xpc = processor.newXPathCompiler();
            XPathExecutable xpe = xpc.compile(value2);
            XdmValue val = xpe.load().evaluate();
            paramSetter.setParam(QName.fromClarkName(name), val);
        }
    }

    public void setSerializationParams(Serializer serializer) {
        Enumeration<?> e = this.serializationParams.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value2 = this.serializationParams.getProperty(name);
            if (name.startsWith("saxon:")) {
                name = "{http://saxon.sf.net/}" + name.substring(6);
            }
            serializer.setOutputProperty(QName.fromClarkName(name), value2);
        }
    }

    public void applyStaticParams(XsltCompiler compiler) throws SaxonApiException {
        String value2;
        String name;
        Processor processor = compiler.getProcessor();
        Enumeration<?> e = this.paramValues.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value2 = this.paramValues.getProperty(name);
            compiler.setParameter(QName.fromClarkName(name), new XdmAtomicValue(value2, ItemType.UNTYPED_ATOMIC));
        }
        e = this.paramExpressions.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value2 = this.paramExpressions.getProperty(name);
            XPathCompiler xpc = processor.newXPathCompiler();
            XPathExecutable xpe = xpc.compile(value2);
            XdmValue val = xpe.load().evaluate();
            compiler.setParameter(QName.fromClarkName(name), val);
        }
    }

    public static boolean loadDocuments(String sourceFileName, boolean useURLs, Processor processor, boolean useSAXSource, List<Source> sources) throws SaxonApiException {
        Source sourceInput;
        Configuration config = processor.getUnderlyingConfiguration();
        if (useURLs || CommandLineOptions.isImplicitURI(sourceFileName)) {
            Source sourceInput2;
            try {
                sourceInput2 = config.getURIResolver().resolve(sourceFileName, null);
                if (sourceInput2 == null) {
                    sourceInput2 = config.getSystemURIResolver().resolve(sourceFileName, null);
                }
            }
            catch (TransformerException e) {
                throw new SaxonApiException(e);
            }
            sources.add(sourceInput2);
            return false;
        }
        if (sourceFileName.equals("-")) {
            Source sourceInput3;
            if (useSAXSource) {
                XMLReader parser = config.getSourceParser();
                sourceInput3 = new SAXSource(parser, new InputSource(System.in));
            } else {
                sourceInput3 = new StreamSource(System.in);
            }
            sources.add(sourceInput3);
            return false;
        }
        File sourceFile = new File(sourceFileName);
        if (!sourceFile.exists()) {
            throw new SaxonApiException("Source file " + sourceFile + " does not exist");
        }
        if (sourceFile.isDirectory()) {
            String[] files;
            XMLReader parser = config.getSourceParser();
            for (String file1 : files = sourceFile.list()) {
                Source sourceInput4;
                File file = new File(sourceFile, file1);
                if (file.isDirectory()) continue;
                if (useSAXSource) {
                    InputSource eis = new InputSource(file.toURI().toString());
                    sourceInput4 = new SAXSource(parser, eis);
                } else {
                    sourceInput4 = new StreamSource(file.toURI().toString());
                }
                sources.add(sourceInput4);
            }
            return true;
        }
        if (useSAXSource) {
            InputSource eis = new InputSource(sourceFile.toURI().toString());
            sourceInput = new SAXSource(config.getSourceParser(), eis);
        } else {
            sourceInput = new StreamSource(sourceFile.toURI().toString());
        }
        sources.add(sourceInput);
        return false;
    }

    public static boolean isImplicitURI(String name) {
        return name.startsWith("http:") || name.startsWith("https:") || name.startsWith("file:") || name.startsWith("classpath:");
    }

    public static void loadAdditionalSchemas(Configuration config, String additionalSchemas) throws SchemaException {
        StringTokenizer st = new StringTokenizer(additionalSchemas, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String schema = st.nextToken();
            File schemaFile = new File(schema);
            if (!schemaFile.exists()) {
                throw new SchemaException("Schema document " + schema + " not found");
            }
            config.addSchemaSource(new StreamSource(schemaFile));
        }
    }

    public static String showExecutionTimeNano(long nanosecs) {
        if ((double)nanosecs < 1.0E9) {
            return (double)nanosecs / 1000000.0 + "ms";
        }
        try {
            double millisecs = (double)nanosecs / 1000000.0;
            DayTimeDurationValue d = (DayTimeDurationValue)milliSecond.multiply(millisecs);
            long days = ((NumericValue)d.getComponent(AccessorFn.Component.DAY)).longValue();
            long hours = ((NumericValue)d.getComponent(AccessorFn.Component.HOURS)).longValue();
            long minutes = ((NumericValue)d.getComponent(AccessorFn.Component.MINUTES)).longValue();
            BigDecimal seconds = ((NumericValue)d.getComponent(AccessorFn.Component.SECONDS)).getDecimalValue();
            FastStringBuffer fsb = new FastStringBuffer(256);
            if (days > 0L) {
                fsb.append(days + "days ");
            }
            if (hours > 0L) {
                fsb.append(hours + "h ");
            }
            if (minutes > 0L) {
                fsb.append(minutes + "m ");
            }
            fsb.append(seconds + "s");
            return fsb.toString() + " (" + (double)nanosecs / 1000000.0 + "ms)";
        }
        catch (XPathException e) {
            return (double)nanosecs / 1000000.0 + "ms";
        }
    }

    public static interface ParamSetter {
        public void setParam(QName var1, XdmValue var2);
    }
}

