/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class XSLEvaluate
extends StyleElement {
    Expression xpath = null;
    SequenceType requiredType = SequenceType.ANY_SEQUENCE;
    Expression namespaceContext = null;
    Expression contextItem = null;
    Expression baseUri = null;
    Expression schemaAware = null;
    Expression withParams = null;
    private boolean allowAnySchemaNamespace = false;

    public boolean isInstruction() {
        return true;
    }

    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLLocalParam;
    }

    protected ItemType getReturnedItemType() {
        return AnyItemType.getInstance();
    }

    public boolean mayContainSequenceConstructor() {
        return false;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String xpathAtt = null;
        String asAtt = null;
        String contextItemAtt = null;
        String baseUriAtt = null;
        String namespaceContextAtt = null;
        String schemaAwareAtt = null;
        String withParamsAtt = null;
        boolean foundXPathDefaultNamespace = false;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("xpath")) {
                xpathAtt = atts.getValue(a);
                this.xpath = this.makeExpression(xpathAtt, a);
                continue;
            }
            if (f.equals("as")) {
                asAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("context-item")) {
                contextItemAtt = atts.getValue(a);
                this.contextItem = this.makeExpression(contextItemAtt, a);
                continue;
            }
            if (f.equals("base-uri")) {
                baseUriAtt = atts.getValue(a);
                this.baseUri = this.makeAttributeValueTemplate(baseUriAtt, a);
                continue;
            }
            if (f.equals("namespace-context")) {
                namespaceContextAtt = atts.getValue(a);
                this.namespaceContext = this.makeExpression(namespaceContextAtt, a);
                continue;
            }
            if (f.equals("schema-aware")) {
                schemaAwareAtt = Whitespace.trim(atts.getValue(a));
                this.schemaAware = this.makeAttributeValueTemplate(schemaAwareAtt, a);
                continue;
            }
            if (f.equals("with-params")) {
                withParamsAtt = atts.getValue(a);
                this.withParams = this.makeExpression(withParamsAtt, a);
                continue;
            }
            if (atts.getURI(a).equals("http://saxon.sf.net/") && atts.getLocalName(a).equals("allow-any-schema-namespace")) {
                this.allowAnySchemaNamespace = this.processBooleanAttribute("saxon:allow-any-schema-namespace", atts.getValue(a));
                continue;
            }
            if (f.equals("xpath-default-namespace")) {
                foundXPathDefaultNamespace = true;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (xpathAtt == null) {
            this.reportAbsence("xpath");
        }
        if (asAtt != null) {
            this.requiredType = this.makeSequenceType(asAtt);
            try {
                this.requiredType = this.makeSequenceType(asAtt);
            }
            catch (XPathException e) {
                this.compileErrorInAttribute(e.getMessage(), e.getErrorCodeLocalPart(), "as");
            }
        }
        if (contextItemAtt == null) {
            this.contextItem = Literal.makeEmptySequence();
        }
        if (schemaAwareAtt == null) {
            this.schemaAware = StringLiteral.makeLiteral(new StringValue("no"));
        } else if (this.schemaAware instanceof StringLiteral) {
            this.checkAttributeValue("schema-aware", schemaAwareAtt, true, StyleElement.YES_NO);
        }
        if (withParamsAtt == null) {
            withParamsAtt = "map{}";
            this.withParams = this.makeExpression(withParamsAtt, -1);
        }
        if (namespaceContextAtt != null && foundXPathDefaultNamespace) {
            this.issueWarning("When @xpath-context is present, @xpath-default-namespace has no effect on the target expression", this);
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo child;
        this.getContainingPackage().setRetainUnusedFunctions();
        this.xpath = this.typeCheck("select", this.xpath);
        this.baseUri = this.typeCheck("base-uri", this.baseUri);
        this.contextItem = this.typeCheck("context-item", this.contextItem);
        this.namespaceContext = this.typeCheck("namespace-context", this.namespaceContext);
        this.schemaAware = this.typeCheck("schema-aware", this.schemaAware);
        this.withParams = this.typeCheck("with-params", this.withParams);
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (child instanceof XSLWithParam || child instanceof XSLFallback) continue;
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:evaluate", "XTSE0010");
                continue;
            }
            this.compileError("Child element " + Err.wrap(child.getDisplayName(), 1) + " is not allowed as a child of xsl:evaluate", "XTSE0010");
        }
        try {
            ExpressionVisitor visitor = this.makeExpressionVisitor();
            TypeChecker tc = this.getConfiguration().getTypeChecker(false);
            RoleDiagnostic role = new RoleDiagnostic(4, "xsl:evaluate/xpath", 0);
            this.xpath = tc.staticTypeCheck(this.xpath, SequenceType.SINGLE_STRING, role, visitor);
            role = new RoleDiagnostic(4, "xsl:evaluate/context-item", 0);
            role.setErrorCode("XTTE3210");
            this.contextItem = tc.staticTypeCheck(this.contextItem, SequenceType.OPTIONAL_ITEM, role, visitor);
            role = new RoleDiagnostic(4, "xsl:evaluate/namespace-context", 0);
            role.setErrorCode("XTTE3170");
            if (this.namespaceContext != null) {
                this.namespaceContext = tc.staticTypeCheck(this.namespaceContext, SequenceType.SINGLE_NODE, role, visitor);
            }
            role = new RoleDiagnostic(4, "xsl:evaluate/with-params", 0);
            role.setErrorCode("XTTE3170");
            this.withParams = tc.staticTypeCheck(this.withParams, SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384), role, visitor);
        }
        catch (XPathException err2) {
            this.compileError(err2);
        }
    }

    public Expression getTargetExpression() {
        return this.xpath;
    }

    public Expression getContextItemExpression() {
        return this.contextItem;
    }

    public Expression getBaseUriExpression() {
        return this.baseUri;
    }

    public Expression getNamespaceContextExpression() {
        return this.namespaceContext;
    }

    public Expression getSchemaAwareExpression() {
        return this.schemaAware;
    }

    public Expression getWithParamsExpression() {
        return this.withParams;
    }

    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public boolean isAllowAnySchemaNamespace() {
        return this.allowAnySchemaNamespace;
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        if (this.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/disableXslEvaluate")) {
            this.validationError = new XPathException("xsl:evaluate is not available in this configuration", "XTDE3175");
            return this.fallbackProcessing(exec, decl, this);
        }
        return this.getConfiguration().makeEvaluateInstruction(this, decl);
    }
}

