/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLAccept;
import net.sf.saxon.trans.ComponentTest;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XSLAcceptExpose
extends StyleElement {
    private Set<ComponentTest> explicitComponentTests = new HashSet<ComponentTest>();
    private Set<ComponentTest> wildcardComponentTests = new HashSet<ComponentTest>();
    private Visibility visibility;

    @Override
    public Visibility getVisibility() {
        return this.visibility;
    }

    public Set<ComponentTest> getExplicitComponentTests() throws XPathException {
        this.prepareAttributes();
        return this.explicitComponentTests;
    }

    public Set<ComponentTest> getWildcardComponentTests() throws XPathException {
        this.prepareAttributes();
        return this.wildcardComponentTests;
    }

    @Override
    protected void prepareAttributes() throws XPathException {
        if (this.visibility != null) {
            return;
        }
        String componentAtt = null;
        String namesAtt = null;
        String visibilityAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("names")) {
                namesAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("component")) {
                componentAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("visibility")) {
                visibilityAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (visibilityAtt == null) {
            this.reportAbsence("visibility");
            this.visibility = Visibility.PRIVATE;
        } else {
            this.visibility = this.interpretVisibilityValue(visibilityAtt, this instanceof XSLAccept ? "ha" : "");
            if (this.visibility == null) {
                this.visibility = Visibility.PRIVATE;
            }
        }
        int componentTypeCode = 158;
        if (componentAtt == null) {
            this.reportAbsence("component");
        } else {
            String local = Whitespace.trim(componentAtt);
            if (local.equals("function")) {
                componentTypeCode = 158;
            } else if (local.equals("template")) {
                componentTypeCode = 200;
            } else if (local.equals("variable")) {
                componentTypeCode = 206;
            } else if (local.equals("attribute-set")) {
                componentTypeCode = 136;
            } else if (local.equals("mode")) {
                componentTypeCode = 174;
            } else if (local.equals("*")) {
                componentTypeCode = -1;
            } else {
                this.compileError("The component type is not one of the allowed names (function, template, variable, attribute-set, or mode)", "XTSE0020");
                return;
            }
        }
        if (namesAtt == null) {
            this.reportAbsence("names");
            namesAtt = "";
        }
        StringTokenizer st = new StringTokenizer(namesAtt, " \t\r\n");
        while (st.hasMoreTokens()) {
            NodeTest test;
            StructuredQName name;
            String tok = st.nextToken();
            int hash2 = tok.lastIndexOf(35);
            if (hash2 > 0 && tok.indexOf(125, hash2) < 0) {
                if (componentTypeCode == -1) {
                    this.compileError("When component='*' is specified, all names must be wildcards", this instanceof XSLAccept ? "XTSE3032" : "XTSE3022");
                    continue;
                }
                try {
                    name = this.makeQName(tok.substring(0, hash2));
                }
                catch (NamespaceException e) {
                    this.compileError("Invalid QName in names attribute: " + tok + " (" + e.getMessage() + ")");
                    name = NameOfNode.makeName(this).getStructuredQName();
                }
                test = new NameTest(1, name.getURI(), name.getLocalPart(), this.getNamePool());
                int arity = 0;
                try {
                    arity = Integer.parseInt(tok.substring(hash2 + 1));
                }
                catch (Exception err2) {
                    this.compileError("Malformed function arity in '" + tok + "'");
                }
                this.explicitComponentTests.add(new ComponentTest(componentTypeCode, (QNameTest)((Object)test), arity));
                continue;
            }
            if (tok.equals("*")) {
                test = AnyNodeTest.getInstance();
                this.addWildCardTest(componentTypeCode, (QNameTest)((Object)test));
                continue;
            }
            if (tok.endsWith(":*")) {
                if (tok.length() == 2) {
                    this.compileError("No prefix before ':*'");
                }
                String prefix = tok.substring(0, tok.length() - 2);
                String uri = this.getURIForPrefix(prefix, false);
                test = new NamespaceTest(this.getNamePool(), 1, uri);
                this.addWildCardTest(componentTypeCode, (QNameTest)((Object)test));
                continue;
            }
            if (tok.startsWith("Q{") && tok.endsWith("}*")) {
                String uri = tok.substring(2, tok.length() - 2);
                test = new NamespaceTest(this.getNamePool(), 1, uri);
                this.wildcardComponentTests.add(new ComponentTest(componentTypeCode, (QNameTest)((Object)test), -1));
                continue;
            }
            if (tok.startsWith("*:")) {
                if (tok.length() == 2) {
                    this.compileError("No local name after '*:'");
                }
                String localname = tok.substring(2);
                test = new LocalNameTest(this.getNamePool(), 1, localname);
                this.addWildCardTest(componentTypeCode, (QNameTest)((Object)test));
                continue;
            }
            if (componentTypeCode == -1) {
                this.compileError("When component='*' is specified, all names must be wildcards", this instanceof XSLAccept ? "XTSE3032" : "XTSE3022");
                continue;
            }
            try {
                name = this.makeQName(tok);
            }
            catch (NamespaceException e) {
                this.compileError("Invalid QName in names attribute: " + tok + " (" + e.getMessage() + ")");
                name = NameOfNode.makeName(this).getStructuredQName();
            }
            test = new NameTest(1, name.getURI(), name.getLocalPart(), this.getNamePool());
            this.explicitComponentTests.add(new ComponentTest(componentTypeCode, (QNameTest)((Object)test), -1));
        }
    }

    private void addWildCardTest(int componentTypeCode, QNameTest test) {
        if (componentTypeCode == -1) {
            this.wildcardComponentTests.add(new ComponentTest(158, test, -1));
            this.wildcardComponentTests.add(new ComponentTest(200, test, -1));
            this.wildcardComponentTests.add(new ComponentTest(206, test, -1));
            this.wildcardComponentTests.add(new ComponentTest(136, test, -1));
            this.wildcardComponentTests.add(new ComponentTest(174, test, -1));
        } else {
            this.wildcardComponentTests.add(new ComponentTest(componentTypeCode, test, -1));
        }
    }
}

