/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;

public class StylesheetFunctionLibrary
implements FunctionLibrary {
    private StylesheetPackage pack;
    private boolean overrideExtensionFunction;

    public StylesheetFunctionLibrary(StylesheetPackage sheet, boolean overrideExtensionFunction) {
        this.pack = sheet;
        this.overrideExtensionFunction = overrideExtensionFunction;
    }

    public boolean isOverrideExtensionFunction() {
        return this.overrideExtensionFunction;
    }

    public StylesheetPackage getStylesheetPackage() {
        return this.pack;
    }

    public Expression bind(SymbolicName.F functionName, Expression[] staticArgs, StaticContext env) throws XPathException {
        UserFunction fn = this.pack.getFunction(functionName);
        if (fn == null) {
            return null;
        }
        final UserFunctionCall fc = new UserFunctionCall();
        fc.setFunctionName(functionName.getComponentName());
        fc.setArguments(staticArgs);
        fc.setFunction(fn);
        if (env instanceof ExpressionContext) {
            final PrincipalStylesheetModule psm = ((ExpressionContext)env).getStyleElement().getCompilation().getPrincipalStylesheetModule();
            final ExpressionVisitor visitor = ExpressionVisitor.make(env);
            psm.addFixupAction(new PrincipalStylesheetModule.Action(){

                public void doAction() throws XPathException {
                    if (fc.getFunction() == null) {
                        Component target = psm.getComponent(fc.getSymbolicName());
                        UserFunction fn = (UserFunction)target.getActor();
                        if (fn != null) {
                            fc.checkFunctionCall(fn, visitor);
                            fc.computeArgumentEvaluationModes();
                            fc.setStaticType(fn.getResultType());
                        } else {
                            XPathException err2 = new XPathException("There is no available function named " + fc.getDisplayName() + " with " + fc.getArity() + " arguments", "XPST0017");
                            err2.setLocator(fc.getLocation());
                            throw err2;
                        }
                    }
                }
            });
        }
        return fc;
    }

    public boolean isAvailable(SymbolicName.F functionName) {
        return this.pack.getFunction(functionName) != null;
    }

    public FunctionLibrary copy() {
        return this;
    }
}

