/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.Whitespace;

public class XMLIndenter
extends ProxyReceiver {
    private int level = 0;
    protected char[] indentChars = new char[]{'\n', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private boolean sameline = false;
    private boolean afterStartTag = false;
    private boolean afterEndTag = true;
    private boolean allWhite = true;
    private int line = 0;
    private int column = 0;
    private int suppressedAtLevel = -1;
    private Set<NodeName> suppressedElements = null;
    private XMLEmitter emitter;
    private AttributeCollectionImpl bufferedAttributes;
    private List<NamespaceBindingSet> bufferedNamespaces = new ArrayList<NamespaceBindingSet>(8);

    public XMLIndenter(XMLEmitter next2) {
        super(next2);
        this.emitter = next2;
        this.bufferedAttributes = new AttributeCollectionImpl(this.getConfiguration());
    }

    public void setOutputProperties(Properties props) {
        String omit = props.getProperty("omit-xml-declaration");
        this.afterEndTag = omit == null || !"yes".equals(Whitespace.trim(omit)) || props.getProperty("doctype-system") != null;
        String s2 = props.getProperty("suppress-indentation");
        if (s2 == null) {
            s2 = props.getProperty("{http://saxon.sf.net/}suppress-indentation");
        }
        if (s2 != null) {
            this.suppressedElements = new HashSet<NodeName>(8);
            StringTokenizer st = new StringTokenizer(s2, " \t\r\n");
            while (st.hasMoreTokens()) {
                String clarkName = st.nextToken();
                this.suppressedElements.add(FingerprintedQName.fromClarkName(clarkName));
            }
        }
    }

    public void open() throws XPathException {
        this.nextReceiver.open();
    }

    public void startElement(NodeName nameCode, SchemaType type, Location location, int properties) throws XPathException {
        if (this.afterStartTag || this.afterEndTag) {
            if (this.isDoubleSpaced(nameCode)) {
                this.nextReceiver.characters("\n", location, 0);
                this.line = 0;
                this.column = 0;
            }
            this.indent();
        }
        this.nextReceiver.startElement(nameCode, type, location, properties);
        ++this.level;
        this.sameline = true;
        this.afterStartTag = true;
        this.afterEndTag = false;
        this.allWhite = true;
        this.line = 0;
        if (this.suppressedElements != null && this.suppressedAtLevel == -1 && this.suppressedElements.contains(nameCode)) {
            this.suppressedAtLevel = this.level;
        }
        if (type != AnyType.getInstance() && type != Untyped.getInstance() && this.suppressedAtLevel < 0 && type.isComplexType() && ((ComplexType)type).isMixedContent()) {
            this.suppressedAtLevel = this.level;
        }
        this.bufferedAttributes.clear();
        this.bufferedNamespaces.clear();
    }

    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        this.bufferedNamespaces.add(namespaceBindings);
    }

    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value2, Location locationId, int properties) throws XPathException {
        if (value2.equals("preserve") && attName.hasURI("http://www.w3.org/XML/1998/namespace") && attName.getLocalPart().equals("space") && this.suppressedAtLevel < 0) {
            this.suppressedAtLevel = this.level;
        }
        this.bufferedAttributes.addAttribute(attName, typeCode, value2.toString(), locationId, properties);
    }

    public void startContent() throws XPathException {
        int len = 0;
        int count2 = 0;
        int indent = -1;
        AttributeCollectionImpl ba = this.bufferedAttributes;
        if (this.suppressedAtLevel < 0) {
            for (NamespaceBindingSet nbs : this.bufferedNamespaces) {
                for (NamespaceBinding binding : nbs) {
                    String prefix = binding.getPrefix();
                    if (prefix.isEmpty()) {
                        len += 9 + binding.getURI().length();
                        continue;
                    }
                    len += prefix.length() + 10 + binding.getURI().length();
                }
            }
            for (int i = 0; i < ba.getLength(); ++i) {
                String prefix = ba.getPrefix(i);
                len += ba.getLocalName(i).length() + ba.getValue(i).length() + 4 + (prefix.isEmpty() ? 4 : prefix.length() + 5);
            }
            if (len > this.getLineLength()) {
                indent = (this.level - 1) * this.getIndentation() + this.emitter.elementStack.peek().length() + 3;
            }
        }
        for (NamespaceBindingSet nbs : this.bufferedNamespaces) {
            for (NamespaceBinding binding : nbs) {
                this.nextReceiver.namespace(binding, 0);
                if (indent <= 0 || count2++ != 0) continue;
                this.emitter.setIndentForNextAttribute(indent);
            }
        }
        for (int i = 0; i < ba.getLength(); ++i) {
            this.nextReceiver.attribute(ba.getNodeName(i), ba.getTypeAnnotation(i), ba.getValue(i), ba.getLocation(i), ba.getProperties(i));
            if (indent <= 0 || count2++ != 0) continue;
            this.emitter.setIndentForNextAttribute(indent);
        }
        this.nextReceiver.startContent();
    }

    public void endElement() throws XPathException {
        --this.level;
        if (this.afterEndTag && !this.sameline) {
            this.indent();
        }
        this.nextReceiver.endElement();
        this.sameline = false;
        this.afterEndTag = true;
        this.afterStartTag = false;
        this.allWhite = true;
        this.line = 0;
        if (this.level == this.suppressedAtLevel - 1) {
            this.suppressedAtLevel = -1;
        }
    }

    public void processingInstruction(String target, CharSequence data2, Location locationId, int properties) throws XPathException {
        if (this.afterEndTag) {
            this.indent();
        }
        this.nextReceiver.processingInstruction(target, data2, locationId, properties);
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            if (c == '\n') {
                this.sameline = false;
                ++this.line;
                this.column = 0;
            }
            if (!Character.isWhitespace(c)) {
                this.allWhite = false;
            }
            ++this.column;
        }
        this.nextReceiver.characters(chars, locationId, properties);
        if (!this.allWhite) {
            this.afterStartTag = false;
            this.afterEndTag = false;
        }
    }

    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.afterEndTag) {
            this.indent();
        }
        this.nextReceiver.comment(chars, locationId, properties);
    }

    public boolean usesTypeAnnotations() {
        return true;
    }

    private void indent() throws XPathException {
        if (this.suppressedAtLevel >= 0) {
            return;
        }
        int spaces2 = this.level * this.getIndentation();
        if (this.line > 0 && (spaces2 -= this.column) <= 0) {
            return;
        }
        if (spaces2 + 2 >= this.indentChars.length) {
            int increment = 5 * this.getIndentation();
            if (spaces2 + 2 > this.indentChars.length + increment) {
                increment += spaces2 + 2;
            }
            char[] c2 = new char[this.indentChars.length + increment];
            System.arraycopy(this.indentChars, 0, c2, 0, this.indentChars.length);
            Arrays.fill(c2, this.indentChars.length, c2.length, ' ');
            this.indentChars = c2;
        }
        int start = this.line == 0 ? 0 : 1;
        this.nextReceiver.characters(new CharSlice(this.indentChars, start, spaces2 + 1), ExplicitLocation.UNKNOWN_LOCATION, 4);
        this.sameline = false;
    }

    public void endDocument() throws XPathException {
        if (this.afterEndTag) {
            this.characters("\n", ExplicitLocation.UNKNOWN_LOCATION, 0);
        }
        super.endDocument();
    }

    protected int getIndentation() {
        return 3;
    }

    protected boolean isDoubleSpaced(NodeName name) {
        return false;
    }

    protected int getLineLength() {
        return 80;
    }
}

