/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.Stack;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.CharacterReferenceGenerator;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.serialize.HexCharacterReferenceGenerator;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.serialize.charcode.UTF8CharacterSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;

public class XMLEmitter
extends Emitter {
    protected boolean started = false;
    protected boolean startedElement = false;
    protected boolean openStartTag = false;
    protected boolean declarationIsWritten = false;
    protected NodeName elementCode;
    protected int indentForNextAttribute = -1;
    protected boolean undeclareNamespaces = false;
    protected boolean unfailing = false;
    protected char delimiter = (char)34;
    protected boolean[] attSpecials = specialInAtt;
    protected Stack<String> elementStack = new Stack();
    private boolean indenting = false;
    private String indentChars = "\n                                                          ";
    private boolean requireWellFormed = false;
    protected CharacterReferenceGenerator characterReferenceGenerator = HexCharacterReferenceGenerator.THE_INSTANCE;
    static boolean[] specialInText;
    static boolean[] specialInAtt;
    static boolean[] specialInAttSingle;

    public void setCharacterReferenceGenerator(CharacterReferenceGenerator generator) {
        this.characterReferenceGenerator = generator;
    }

    public void setEscapeNonAscii(Boolean escape2) {
    }

    public void open() throws XPathException {
    }

    public void startDocument(int properties) throws XPathException {
    }

    public void endDocument() throws XPathException {
    }

    protected void openDocument() throws XPathException {
        String rep2;
        if (this.writer == null) {
            this.makeWriter();
        }
        if (this.characterSet == null) {
            this.characterSet = UTF8CharacterSet.getInstance();
        }
        if (this.outputProperties == null) {
            this.outputProperties = new Properties();
        }
        if ((rep2 = this.outputProperties.getProperty("undeclare-prefixes")) != null) {
            this.undeclareNamespaces = rep2.equalsIgnoreCase("yes");
        }
        this.unfailing = "yes".equals(this.outputProperties.getProperty("{http://saxon.sf.net/}unfailing"));
        if ("yes".equals(this.outputProperties.getProperty("{http://saxon.sf.net/}single-quotes"))) {
            this.delimiter = (char)39;
            this.attSpecials = specialInAttSingle;
        }
        this.writeDeclaration();
    }

    public void writeDeclaration() throws XPathException {
        if (this.declarationIsWritten) {
            return;
        }
        this.declarationIsWritten = true;
        try {
            String systemId;
            String standalone;
            String version;
            String omitXMLDeclaration;
            this.indenting = "yes".equals(this.outputProperties.getProperty("indent"));
            String byteOrderMark = this.outputProperties.getProperty("byte-order-mark");
            String encoding = this.outputProperties.getProperty("encoding");
            if (encoding == null || encoding.equalsIgnoreCase("utf8")) {
                encoding = "UTF-8";
            }
            if ("yes".equals(byteOrderMark) && ("UTF-8".equalsIgnoreCase(encoding) || "UTF-16LE".equalsIgnoreCase(encoding) || "UTF-16BE".equalsIgnoreCase(encoding))) {
                this.writer.write(65279);
            }
            if ((omitXMLDeclaration = this.outputProperties.getProperty("omit-xml-declaration")) == null) {
                omitXMLDeclaration = "no";
            }
            if ((version = this.outputProperties.getProperty("version")) == null) {
                version = this.getConfiguration().getXMLVersion() == 10 ? "1.0" : "1.1";
            } else {
                if (!version.equals("1.0") && !version.equals("1.1")) {
                    if (this.unfailing) {
                        version = "1.0";
                    } else {
                        XPathException err2 = new XPathException("XML version must be 1.0 or 1.1");
                        err2.setErrorCode("SESU0013");
                        throw err2;
                    }
                }
                if (!version.equals("1.0") && omitXMLDeclaration.equals("yes") && this.outputProperties.getProperty("doctype-system") != null && !this.unfailing) {
                    XPathException err3 = new XPathException("Values of 'version', 'omit-xml-declaration', and 'doctype-system' conflict");
                    err3.setErrorCode("SEPM0009");
                    throw err3;
                }
            }
            String undeclare = this.outputProperties.getProperty("undeclare-prefixes");
            if ("yes".equals(undeclare)) {
                this.undeclareNamespaces = true;
            }
            if (version.equals("1.0") && this.undeclareNamespaces) {
                if (this.unfailing) {
                    this.undeclareNamespaces = false;
                } else {
                    XPathException err4 = new XPathException("Cannot undeclare namespaces with XML version 1.0");
                    err4.setErrorCode("SEPM0010");
                    throw err4;
                }
            }
            if ("omit".equals(standalone = this.outputProperties.getProperty("standalone"))) {
                standalone = null;
            }
            if (standalone != null) {
                this.requireWellFormed = true;
                if (omitXMLDeclaration.equals("yes") && !this.unfailing) {
                    XPathException err5 = new XPathException("Values of 'standalone' and 'omit-xml-declaration' conflict");
                    err5.setErrorCode("SEPM0009");
                    throw err5;
                }
            }
            if ((systemId = this.outputProperties.getProperty("doctype-system")) != null && !"".equals(systemId)) {
                this.requireWellFormed = true;
            }
            if (omitXMLDeclaration.equals("no")) {
                this.writer.write("<?xml version=\"" + version + "\" " + "encoding=\"" + encoding + '\"' + (standalone != null ? " standalone=\"" + standalone + '\"' : "") + "?>");
            }
        }
        catch (IOException err6) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err6);
        }
    }

    protected void writeDocType(NodeName name, String displayName, String systemId, String publicId) throws XPathException {
        try {
            if (this.declarationIsWritten && !this.indenting) {
                this.writer.write("\n");
            }
            this.writer.write("<!DOCTYPE " + displayName + '\n');
            String quotedSystemId = null;
            if (systemId != null) {
                quotedSystemId = systemId.contains("\"") ? "'" + systemId + "'" : '\"' + systemId + '\"';
            }
            if (systemId != null && publicId == null) {
                this.writer.write("  SYSTEM " + quotedSystemId + ">\n");
            } else if (systemId == null && publicId != null) {
                this.writer.write("  PUBLIC \"" + publicId + "\">\n");
            } else {
                this.writer.write("  PUBLIC \"" + publicId + "\" " + quotedSystemId + ">\n");
            }
        }
        catch (IOException err2) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err2);
        }
    }

    public void close() throws XPathException {
        if (!this.started) {
            this.openDocument();
        }
        try {
            if (this.writer != null) {
                this.writer.flush();
            }
        }
        catch (IOException err2) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err2);
        }
        super.close();
    }

    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        int badchar;
        this.previousAtomic = false;
        if (!this.started) {
            this.openDocument();
        } else if (this.requireWellFormed && this.elementStack.isEmpty() && this.startedElement && !this.unfailing) {
            XPathException err2 = new XPathException("When 'standalone' or 'doctype-system' is specified, the document must be well-formed; but this document contains more than one top-level element");
            err2.setErrorCode("SEPM0004");
            throw err2;
        }
        this.startedElement = true;
        String displayName = elemName.getDisplayName();
        if (!this.allCharactersEncodable && (badchar = this.testCharacters(displayName)) != 0) {
            XPathException err3 = new XPathException("Element name contains a character (decimal + " + badchar + ") not available in the selected encoding");
            err3.setErrorCode("SERE0008");
            throw err3;
        }
        this.elementStack.push(displayName);
        this.elementCode = elemName;
        try {
            if (!this.started) {
                String systemId = this.outputProperties.getProperty("doctype-system");
                String publicId = this.outputProperties.getProperty("doctype-public");
                if ("".equals(systemId)) {
                    systemId = null;
                }
                if ("".equals(publicId)) {
                    publicId = null;
                }
                if (systemId != null) {
                    this.requireWellFormed = true;
                    this.writeDocType(elemName, displayName, systemId, publicId);
                } else if (this.writeDocTypeWithNullSystemId()) {
                    this.writeDocType(elemName, displayName, systemId, publicId);
                }
                this.started = true;
            }
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.writer.write(60);
            this.writer.write(displayName);
            this.openStartTag = true;
            this.indentForNextAttribute = -1;
        }
        catch (IOException err4) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err4);
        }
    }

    protected boolean writeDocTypeWithNullSystemId() {
        return false;
    }

    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        try {
            for (NamespaceBinding ns : namespaceBindings) {
                String nsprefix = ns.getPrefix();
                String nsuri = ns.getURI();
                String sep = this.getAttributeIndentString();
                if (nsprefix.isEmpty()) {
                    this.writer.write(sep);
                    this.writeAttribute(this.elementCode, "xmlns", nsuri, 0);
                    continue;
                }
                if (nsprefix.equals("xml")) continue;
                int badchar = this.testCharacters(nsprefix);
                if (badchar != 0) {
                    XPathException err2 = new XPathException("Namespace prefix contains a character (decimal + " + badchar + ") not available in the selected encoding");
                    err2.setErrorCode("SERE0008");
                    throw err2;
                }
                if (!this.undeclareNamespaces && nsuri.length() == 0) continue;
                this.writer.write(sep);
                this.writeAttribute(this.elementCode, "xmlns:" + nsprefix, nsuri, 0);
            }
        }
        catch (IOException err3) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err3);
        }
    }

    public void setIndentForNextAttribute(int indent) {
        this.indentForNextAttribute = indent;
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value2, Location locationId, int properties) throws XPathException {
        int badchar;
        String displayName = nameCode.getDisplayName();
        if (!this.allCharactersEncodable && (badchar = this.testCharacters(displayName)) != 0) {
            if (this.unfailing) {
                displayName = this.convertToAscii(displayName);
            } else {
                XPathException err2 = new XPathException("Attribute name contains a character (decimal + " + badchar + ") not available in the selected encoding");
                err2.setErrorCode("SERE0008");
                throw err2;
            }
        }
        try {
            this.writer.write(this.getAttributeIndentString());
        }
        catch (IOException err3) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err3);
        }
        this.writeAttribute(this.elementCode, displayName, value2, properties);
    }

    protected String getAttributeIndentString() {
        if (this.indentForNextAttribute < 0) {
            return " ";
        }
        int indent = this.indentForNextAttribute;
        while (indent >= this.indentChars.length()) {
            this.indentChars = this.indentChars + "                     ";
        }
        return this.indentChars.substring(0, indent);
    }

    public void startContent() throws XPathException {
    }

    public void closeStartTag() throws XPathException {
        try {
            if (this.openStartTag) {
                this.writer.write(62);
                this.openStartTag = false;
            }
        }
        catch (IOException err2) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err2);
        }
    }

    protected String emptyElementTagCloser(String displayName, NodeName nameCode) {
        return "/>";
    }

    protected void writeAttribute(NodeName elCode, String attname, CharSequence value2, int properties) throws XPathException {
        try {
            String val = value2.toString();
            this.writer.write(attname);
            if ((properties & 4) != 0) {
                this.writer.write(61);
                this.writer.write(this.delimiter);
                this.writer.write(val);
                this.writer.write(this.delimiter);
            } else if ((properties & 0x100) != 0) {
                this.writer.write(61);
                int delim = val.indexOf(34) >= 0 && val.indexOf(39) < 0 ? 39 : this.delimiter;
                this.writer.write(delim);
                this.writeEscape(value2, true);
                this.writer.write(delim);
            } else {
                this.writer.write("=");
                this.writer.write(this.delimiter);
                this.writeEscape(value2, true);
                this.writer.write(this.delimiter);
            }
        }
        catch (IOException err2) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err2);
        }
    }

    protected int testCharacters(CharSequence chars) throws XPathException {
        for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            if (c <= '\u007f') continue;
            if (UTF16CharacterSet.isHighSurrogate(c)) {
                int cc;
                if (this.characterSet.inCharset(cc = UTF16CharacterSet.combinePair(c, chars.charAt(++i)))) continue;
                return cc;
            }
            if (this.characterSet.inCharset(c)) continue;
            return c;
        }
        return 0;
    }

    protected String convertToAscii(CharSequence chars) {
        FastStringBuffer buff = new FastStringBuffer(chars.length());
        for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            if (c >= '\u0014' && c < '\u007f') {
                buff.append(c);
                continue;
            }
            buff.append("_" + c + "_");
        }
        return buff.toString();
    }

    public void endElement() throws XPathException {
        String displayName = this.elementStack.pop();
        try {
            if (this.openStartTag) {
                this.writer.write(this.emptyElementTagCloser(displayName, this.elementCode));
                this.openStartTag = false;
            } else {
                this.writer.write("</");
                this.writer.write(displayName);
                this.writer.write(62);
            }
        }
        catch (IOException err2) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err2);
        }
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (!this.started) {
            this.openDocument();
        }
        if (this.requireWellFormed && this.elementStack.isEmpty() && !Whitespace.isWhite(chars) && !this.unfailing) {
            XPathException err2 = new XPathException("When 'standalone' or 'doctype-system' is specified, the document must be well-formed; but this document contains a top-level text node");
            err2.setErrorCode("SEPM0004");
            throw err2;
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag();
            }
            if ((properties & 4) != 0) {
                this.writeCharSequence(chars);
            } else if ((properties & 1) == 0) {
                this.writeEscape(chars, false);
            } else if (this.testCharacters(chars) == 0) {
                if ((properties & 0x100) == 0) {
                    this.writeCharSequence(chars);
                } else {
                    int len = chars.length();
                    for (int i = 0; i < len; ++i) {
                        char c = chars.charAt(i);
                        if (c == '\u0000') continue;
                        this.writer.write(c);
                    }
                }
            } else {
                int len = chars.length();
                for (int i = 0; i < len; ++i) {
                    char c = chars.charAt(i);
                    if (c == '\u0000') continue;
                    if (c > '\u007f' && UTF16CharacterSet.isHighSurrogate(c)) {
                        char[] pair2;
                        int cc;
                        if (!this.characterSet.inCharset(cc = UTF16CharacterSet.combinePair(c, (pair2 = new char[]{c, chars.charAt(++i)})[1]))) {
                            this.writeEscape(new CharSlice(pair2), false);
                            continue;
                        }
                        this.writeCharSequence(new CharSlice(pair2));
                        continue;
                    }
                    char[] ca = new char[]{c};
                    if (!this.characterSet.inCharset(c)) {
                        this.writeEscape(new CharSlice(ca), false);
                        continue;
                    }
                    this.writeCharSequence(new CharSlice(ca));
                }
            }
        }
        catch (IOException err3) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err3);
        }
    }

    public void writeCharSequence(CharSequence s2) throws IOException {
        if (s2 instanceof String) {
            this.writer.write((String)s2);
        } else if (s2 instanceof CharSlice) {
            ((CharSlice)s2).write(this.writer);
        } else if (s2 instanceof FastStringBuffer) {
            ((FastStringBuffer)s2).write(this.writer);
        } else if (s2 instanceof CompressedWhitespace) {
            ((CompressedWhitespace)s2).write(this.writer);
        } else {
            this.writer.write(s2.toString());
        }
    }

    public void processingInstruction(String target, CharSequence data2, Location locationId, int properties) throws XPathException {
        int x;
        if (!this.started) {
            this.openDocument();
        }
        if ((x = this.testCharacters(target)) != 0) {
            if (this.unfailing) {
                target = this.convertToAscii(target);
            } else {
                XPathException err2 = new XPathException("Character in processing instruction name cannot be represented in the selected encoding (code " + x + ')');
                err2.setErrorCode("SERE0008");
                throw err2;
            }
        }
        if ((x = this.testCharacters(data2)) != 0) {
            if (this.unfailing) {
                data2 = this.convertToAscii(data2);
            } else {
                XPathException err3 = new XPathException("Character in processing instruction data cannot be represented in the selected encoding (code " + x + ')');
                err3.setErrorCode("SERE0008");
                throw err3;
            }
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.writer.write("<?" + target + (data2.length() > 0 ? ' ' + data2.toString() : "") + "?>");
        }
        catch (IOException err4) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err4);
        }
    }

    protected void writeEscape(CharSequence chars, boolean inAttribute) throws IOException, XPathException {
        boolean[] specialChars;
        int segstart = 0;
        boolean disabled = false;
        boolean[] blArray = specialChars = inAttribute ? this.attSpecials : specialInText;
        if (chars instanceof CompressedWhitespace) {
            ((CompressedWhitespace)chars).writeEscape(specialChars, this.writer);
            return;
        }
        int clength = chars.length();
        while (segstart < clength) {
            int i = segstart;
            char c = '\u0000';
            while (i < clength) {
                c = chars.charAt(i);
                if (c < '\u007f') {
                    if (specialChars[c]) break;
                    ++i;
                    continue;
                }
                if (c < '\u00a0' || c == '\u2028' || UTF16CharacterSet.isHighSurrogate(c) || !this.characterSet.inCharset(c)) break;
                ++i;
            }
            if (i >= clength) {
                if (segstart == 0) {
                    this.writeCharSequence(chars);
                } else {
                    this.writeCharSequence(chars.subSequence(segstart, i));
                }
                return;
            }
            if (i > segstart) {
                this.writeCharSequence(chars.subSequence(segstart, i));
            }
            if (c == '\u0000') {
                disabled = !disabled;
            } else if (disabled) {
                if (c > '\u007f') {
                    if (UTF16CharacterSet.isHighSurrogate(c)) {
                        int cc = UTF16CharacterSet.combinePair(c, chars.charAt(i + 1));
                        if (!this.characterSet.inCharset(cc)) {
                            XPathException de = new XPathException("Character x" + Integer.toHexString(cc) + " is not available in the chosen encoding");
                            de.setErrorCode("SERE0008");
                            throw de;
                        }
                    } else if (!this.characterSet.inCharset(c)) {
                        XPathException de = new XPathException("Character " + c + " (x" + Integer.toHexString(c) + ") is not available in the chosen encoding");
                        de.setErrorCode("SERE0008");
                        throw de;
                    }
                }
                this.writer.write(c);
            } else if (c < '\u007f') {
                switch (c) {
                    case '<': {
                        this.writer.write("&lt;");
                        break;
                    }
                    case '>': {
                        this.writer.write("&gt;");
                        break;
                    }
                    case '&': {
                        this.writer.write("&amp;");
                        break;
                    }
                    case '\"': {
                        this.writer.write("&#34;");
                        break;
                    }
                    case '\'': {
                        this.writer.write("&#39;");
                        break;
                    }
                    case '\n': {
                        this.writer.write("&#xA;");
                        break;
                    }
                    case '\r': {
                        this.writer.write("&#xD;");
                        break;
                    }
                    case '\t': {
                        this.writer.write("&#x9;");
                        break;
                    }
                    default: {
                        this.characterReferenceGenerator.outputCharacterReference(c, this.writer);
                        break;
                    }
                }
            } else if (c < '\u00a0' || c == '\u2028') {
                this.characterReferenceGenerator.outputCharacterReference(c, this.writer);
            } else if (UTF16CharacterSet.isHighSurrogate(c)) {
                char d;
                int charval;
                if (this.characterSet.inCharset(charval = UTF16CharacterSet.combinePair(c, d = chars.charAt(++i)))) {
                    this.writer.write(c);
                    this.writer.write(d);
                } else {
                    this.characterReferenceGenerator.outputCharacterReference(charval, this.writer);
                }
            } else {
                this.characterReferenceGenerator.outputCharacterReference(c, this.writer);
            }
            segstart = ++i;
        }
    }

    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        int x;
        if (!this.started) {
            this.openDocument();
        }
        if ((x = this.testCharacters(chars)) != 0) {
            if (this.unfailing) {
                chars = this.convertToAscii(chars);
            } else {
                XPathException err2 = new XPathException("Character in comment cannot be represented in the selected encoding (code " + x + ')');
                err2.setErrorCode("SERE0008");
                throw err2;
            }
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.writer.write("<!--");
            this.writer.write(chars.toString());
            this.writer.write("-->");
        }
        catch (IOException err3) {
            throw new XPathException("Failure writing to " + this.getSystemId(), err3);
        }
    }

    public boolean usesTypeAnnotations() {
        return false;
    }

    public boolean isStarted() {
        return this.started;
    }

    static {
        int i;
        specialInText = new boolean[128];
        for (i = 0; i <= 31; ++i) {
            XMLEmitter.specialInText[i] = true;
        }
        for (i = 32; i <= 127; ++i) {
            XMLEmitter.specialInText[i] = false;
        }
        XMLEmitter.specialInText[10] = false;
        XMLEmitter.specialInText[9] = false;
        XMLEmitter.specialInText[13] = true;
        XMLEmitter.specialInText[60] = true;
        XMLEmitter.specialInText[62] = true;
        XMLEmitter.specialInText[38] = true;
        specialInAtt = new boolean[128];
        for (i = 0; i <= 31; ++i) {
            XMLEmitter.specialInAtt[i] = true;
        }
        for (i = 32; i <= 127; ++i) {
            XMLEmitter.specialInAtt[i] = false;
        }
        XMLEmitter.specialInAtt[0] = true;
        XMLEmitter.specialInAtt[13] = true;
        XMLEmitter.specialInAtt[10] = true;
        XMLEmitter.specialInAtt[9] = true;
        XMLEmitter.specialInAtt[60] = true;
        XMLEmitter.specialInAtt[62] = true;
        XMLEmitter.specialInAtt[38] = true;
        XMLEmitter.specialInAtt[34] = true;
        specialInAttSingle = Arrays.copyOf(specialInAtt, 128);
        XMLEmitter.specialInAttSingle[34] = false;
        XMLEmitter.specialInAttSingle[39] = true;
    }
}

