/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class XML10ContentChecker
extends ProxyReceiver {
    public XML10ContentChecker(Receiver next2) {
        super(next2);
    }

    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.nextReceiver.startElement(elemName, typeCode, location, properties);
    }

    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value2, Location locationId, int properties) throws XPathException {
        this.checkString(value2, locationId);
        this.nextReceiver.attribute(attName, typeCode, value2, locationId, properties);
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.checkString(chars, locationId);
        this.nextReceiver.characters(chars, locationId, properties);
    }

    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.checkString(chars, locationId);
        this.nextReceiver.comment(chars, locationId, properties);
    }

    public void processingInstruction(String target, CharSequence data2, Location locationId, int properties) throws XPathException {
        this.checkString(data2, locationId);
        this.nextReceiver.processingInstruction(target, data2, locationId, properties);
    }

    private void checkString(CharSequence in, Location locationId) throws XPathException {
        int len = in.length();
        for (int c = 0; c < len; ++c) {
            int ch32 = in.charAt(c);
            if (UTF16CharacterSet.isHighSurrogate(ch32)) {
                char low = in.charAt(++c);
                ch32 = UTF16CharacterSet.combinePair((char)ch32, low);
            }
            if (XMLCharacterData.isValid10(ch32)) continue;
            XPathException err2 = new XPathException("The result tree contains a character not allowed by XML 1.0 (hex " + Integer.toHexString(ch32) + ')');
            err2.setErrorCode("SERE0006");
            err2.setLocator(locationId);
            throw err2;
        }
    }
}

