/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class XHTMLPrefixRemover
extends ProxyReceiver {
    public XHTMLPrefixRemover(Receiver next2) {
        super(next2);
    }

    private boolean isSpecial(String uri) {
        return uri.equals("http://www.w3.org/1999/xhtml") || uri.equals("http://www.w3.org/2000/svg") || uri.equals("http://www.w3.org/1998/Math/MathML");
    }

    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        if (this.isSpecial(elemName.getURI())) {
            if (!elemName.getPrefix().isEmpty()) {
                elemName = new FingerprintedQName("", elemName.getURI(), elemName.getLocalPart());
            }
            super.startElement(elemName, typeCode, location, properties);
            super.namespace(new NamespaceBinding("", elemName.getURI()), properties);
        } else {
            super.startElement(elemName, typeCode, location, properties);
        }
    }

    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        for (NamespaceBinding ns : namespaceBindings) {
            if (this.isSpecial(ns.getURI())) continue;
            super.namespace(ns, properties);
        }
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value2, Location locationId, int properties) throws XPathException {
        if (this.isSpecial(nameCode.getURI())) {
            super.namespace(nameCode.getNamespaceBinding(), properties);
        }
        super.attribute(nameCode, typeCode, value2, locationId, properties);
    }
}

