/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.codenorm.Normalizer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;

public class UnicodeNormalizer
extends ProxyReceiver {
    private Normalizer normalizer;

    public UnicodeNormalizer(String form, Receiver next2) throws XPathException {
        super(next2);
        int fb;
        if (form.equals("NFC")) {
            fb = 2;
        } else if (form.equals("NFD")) {
            fb = 0;
        } else if (form.equals("NFKC")) {
            fb = 3;
        } else if (form.equals("NFKD")) {
            fb = 1;
        } else {
            XPathException err2 = new XPathException("Unknown normalization form " + form);
            err2.setErrorCode("SESU0011");
            throw err2;
        }
        this.normalizer = new Normalizer(fb, this.getConfiguration());
    }

    public Normalizer getNormalizer() {
        return this.normalizer;
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value2, Location locationId, int properties) throws XPathException {
        this.nextReceiver.attribute(nameCode, typeCode, this.normalize(value2, (properties & 0x100) != 0), locationId, properties);
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (Whitespace.isWhite(chars)) {
            this.nextReceiver.characters(chars, locationId, properties);
        } else {
            this.nextReceiver.characters(this.normalize(chars, (properties & 0x100) != 0), locationId, properties);
        }
    }

    private CharSequence normalize(CharSequence in, boolean containsNullMarkers) {
        if (containsNullMarkers) {
            FastStringBuffer out = new FastStringBuffer(in.length());
            String s2 = in.toString();
            int start = 0;
            int nextNull = s2.indexOf(0);
            while (nextNull >= 0) {
                out.append(this.normalizer.normalize(s2.substring(start, nextNull)));
                out.append('\u0000');
                start = nextNull + 1;
                nextNull = s2.indexOf(0, start);
                out.append(s2.substring(start, nextNull));
                out.append('\u0000');
                start = nextNull + 1;
                nextNull = s2.indexOf(0, start);
            }
            out.append(this.normalizer.normalize(s2.substring(start)));
            return out.condense();
        }
        return this.normalizer.normalize(in);
    }
}

