/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Result;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public class UncommittedSerializer
extends ProxyReceiver {
    private boolean committed = false;
    private List<PendingNode> pending = null;
    private Result finalResult;
    private Properties outputProperties;
    private CharacterMapIndex charMapIndex;

    public UncommittedSerializer(Result finalResult, Receiver next2, Properties outputProperties, CharacterMapIndex charMap) {
        super(next2);
        this.finalResult = finalResult;
        this.outputProperties = outputProperties;
        this.charMapIndex = charMap;
    }

    public void open() throws XPathException {
        this.committed = false;
    }

    public void close() throws XPathException {
        if (!this.committed) {
            this.switchToMethod("xml");
        }
        this.getUnderlyingReceiver().close();
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.committed) {
            this.getUnderlyingReceiver().characters(chars, locationId, properties);
        } else {
            if (this.pending == null) {
                this.pending = new ArrayList<PendingNode>(10);
            }
            PendingNode node = new PendingNode();
            node.kind = 3;
            node.name = null;
            node.content = chars.toString();
            node.locationId = locationId.saveLocation();
            node.properties = properties;
            this.pending.add(node);
            if (!Whitespace.isWhite(chars)) {
                this.switchToMethod("xml");
            }
        }
    }

    public void processingInstruction(String target, CharSequence data2, Location locationId, int properties) throws XPathException {
        if (this.committed) {
            this.getUnderlyingReceiver().processingInstruction(target, data2, locationId, properties);
        } else {
            if (this.pending == null) {
                this.pending = new ArrayList<PendingNode>(10);
            }
            PendingNode node = new PendingNode();
            node.kind = 7;
            node.name = target;
            node.content = data2;
            node.locationId = locationId;
            node.properties = properties;
            this.pending.add(node);
        }
    }

    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.committed) {
            this.getUnderlyingReceiver().comment(chars, locationId, properties);
        } else {
            if (this.pending == null) {
                this.pending = new ArrayList<PendingNode>(10);
            }
            PendingNode node = new PendingNode();
            node.kind = 8;
            node.name = null;
            node.content = chars;
            node.locationId = locationId;
            node.properties = properties;
            this.pending.add(node);
        }
    }

    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        if (!this.committed) {
            String name = elemName.getLocalPart();
            String uri = elemName.getURI();
            if (name.equalsIgnoreCase("html") && uri.isEmpty()) {
                this.switchToMethod("html");
            } else if (name.equals("html") && uri.equals("http://www.w3.org/1999/xhtml")) {
                String version = this.outputProperties.getProperty("{http://saxon.sf.net/}stylesheet-version");
                if ("10".equals(version)) {
                    this.switchToMethod("xml");
                } else {
                    this.switchToMethod("xhtml");
                }
            } else {
                this.switchToMethod("xml");
            }
        }
        this.getUnderlyingReceiver().startElement(elemName, typeCode, location, properties);
    }

    private void switchToMethod(String method) throws XPathException {
        Properties newProperties = new Properties(this.outputProperties);
        newProperties.setProperty("method", method);
        SerializerFactory sf = this.getConfiguration().getSerializerFactory();
        SequenceReceiver target = sf.getReceiver(this.finalResult, this.getPipelineConfiguration(), newProperties, this.charMapIndex);
        this.committed = true;
        target.open();
        target.startDocument(0);
        if (this.pending != null) {
            for (PendingNode node : this.pending) {
                switch (node.kind) {
                    case 8: {
                        target.comment(node.content, node.locationId, node.properties);
                        break;
                    }
                    case 7: {
                        target.processingInstruction(node.name, node.content, node.locationId, node.properties);
                        break;
                    }
                    case 3: {
                        target.characters(node.content, node.locationId, node.properties);
                    }
                }
            }
            this.pending = null;
        }
        this.setUnderlyingReceiver(target);
    }

    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        if (item instanceof NodeInfo) {
            ((NodeInfo)item).copy(this, 2, locationId);
        } else {
            this.characters(item.getStringValueCS(), locationId, 0);
        }
    }

    private static final class PendingNode {
        int kind;
        String name;
        CharSequence content;
        int properties;
        Location locationId;

        private PendingNode() {
        }
    }
}

