/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import net.sf.saxon.Controller;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class ImplicitResultChecker
extends ProxyReceiver {
    private boolean clean = true;
    private boolean open = false;
    private Controller controller;

    public ImplicitResultChecker(Receiver next2, Controller controller) {
        super(next2);
        this.controller = controller;
    }

    public void open() throws XPathException {
        super.open();
        this.open = true;
    }

    public synchronized void startDocument(int properties) throws XPathException {
        if (!this.open) {
            this.open();
        }
        this.nextReceiver.startDocument(properties);
    }

    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        if (this.clean) {
            this.firstContent();
        }
        this.nextReceiver.startElement(nameCode, typeCode, location, properties);
    }

    public synchronized void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.clean) {
            this.firstContent();
        }
        this.nextReceiver.characters(chars, locationId, properties);
    }

    public void processingInstruction(String target, CharSequence data2, Location locationId, int properties) throws XPathException {
        if (this.clean) {
            this.firstContent();
        }
        this.nextReceiver.processingInstruction(target, data2, locationId, properties);
    }

    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.clean) {
            this.firstContent();
        }
        this.nextReceiver.comment(chars, locationId, properties);
    }

    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        if (this.clean) {
            this.firstContent();
        }
        ((SequenceReceiver)this.nextReceiver).append(item, locationId, copyNamespaces);
    }

    private synchronized void firstContent() throws XPathException {
        this.controller.checkImplicitResultTree();
        if (!this.open) {
            this.open();
            this.startDocument(0);
        }
        this.clean = false;
    }

    public void close() throws XPathException {
        if (!this.clean || !this.controller.hasThereBeenAnExplicitResultDocument()) {
            if (!this.open) {
                this.open();
            }
            this.nextReceiver.close();
        }
    }
}

