/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.HTMLEmitter;
import net.sf.saxon.trans.XPathException;

public class HTML50Emitter
extends HTMLEmitter {
    public HTML50Emitter() {
        this.version = 5;
    }

    protected boolean isHTMLElement(NodeName name) {
        String uri = name.getURI();
        return uri.equals("") || uri.equals("http://www.w3.org/1999/xhtml");
    }

    protected void openDocument() throws XPathException {
        this.version = 5;
        String systemId = this.outputProperties.getProperty("doctype-system");
        String publicId = this.outputProperties.getProperty("doctype-public");
        if ("".equals(systemId)) {
            systemId = null;
        }
        if ("".equals(publicId)) {
            publicId = null;
        }
        super.openDocument();
        this.writeDocType(null, "html", systemId, publicId);
    }

    protected void writeDocType(NodeName name, String displayName, String systemId, String publicId) throws XPathException {
        try {
            if (systemId == null && publicId == null) {
                this.writer.write("<!DOCTYPE HTML>\n");
            } else {
                super.writeDocType(name, displayName, systemId, publicId);
            }
        }
        catch (IOException err2) {
            throw new XPathException(err2);
        }
    }

    protected boolean writeDocTypeWithNullSystemId() {
        return true;
    }

    static {
        HTML50Emitter.setEmptyTag("area");
        HTML50Emitter.setEmptyTag("base");
        HTML50Emitter.setEmptyTag("base");
        HTML50Emitter.setEmptyTag("basefont");
        HTML50Emitter.setEmptyTag("br");
        HTML50Emitter.setEmptyTag("col");
        HTML50Emitter.setEmptyTag("embed");
        HTML50Emitter.setEmptyTag("frame");
        HTML50Emitter.setEmptyTag("hr");
        HTML50Emitter.setEmptyTag("img");
        HTML50Emitter.setEmptyTag("input");
        HTML50Emitter.setEmptyTag("isindex");
        HTML50Emitter.setEmptyTag("keygen");
        HTML50Emitter.setEmptyTag("link");
        HTML50Emitter.setEmptyTag("meta");
        HTML50Emitter.setEmptyTag("param");
        HTML50Emitter.setEmptyTag("source");
        HTML50Emitter.setEmptyTag("track");
        HTML50Emitter.setEmptyTag("wbr");
    }
}

