/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.HTMLEmitter;
import net.sf.saxon.trans.XPathException;

public class HTML40Emitter
extends HTMLEmitter {
    protected boolean isHTMLElement(NodeName name) {
        return name.getURI().equals("");
    }

    protected void openDocument() throws XPathException {
        String versionProperty = this.outputProperties.getProperty("html-version");
        if (versionProperty == null) {
            versionProperty = this.outputProperties.getProperty("version");
        }
        if (versionProperty != null) {
            if (versionProperty.equals("4.0") || versionProperty.equals("4.01")) {
                this.version = 4;
            } else {
                XPathException err2 = new XPathException("Unsupported HTML version: " + versionProperty);
                err2.setErrorCode("SESU0013");
                throw err2;
            }
        }
        String systemId = this.outputProperties.getProperty("doctype-system");
        String publicId = this.outputProperties.getProperty("doctype-public");
        if ("".equals(systemId)) {
            systemId = null;
        }
        if ("".equals(publicId)) {
            publicId = null;
        }
        super.openDocument();
        if (systemId != null || publicId != null) {
            this.writeDocType(null, "html", systemId, publicId);
        }
    }

    static {
        HTML40Emitter.setEmptyTag("area");
        HTML40Emitter.setEmptyTag("base");
        HTML40Emitter.setEmptyTag("basefont");
        HTML40Emitter.setEmptyTag("br");
        HTML40Emitter.setEmptyTag("col");
        HTML40Emitter.setEmptyTag("embed");
        HTML40Emitter.setEmptyTag("frame");
        HTML40Emitter.setEmptyTag("hr");
        HTML40Emitter.setEmptyTag("img");
        HTML40Emitter.setEmptyTag("input");
        HTML40Emitter.setEmptyTag("isindex");
        HTML40Emitter.setEmptyTag("link");
        HTML40Emitter.setEmptyTag("meta");
        HTML40Emitter.setEmptyTag("param");
    }
}

