/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XdmArray;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmEmptySequence;
import net.sf.saxon.s9api.XdmExternalObject;
import net.sf.saxon.s9api.XdmFunctionItem;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmMap;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XdmValue
implements Iterable<XdmItem> {
    private Sequence value;

    protected XdmValue() {
    }

    public XdmValue(Iterable<? extends XdmItem> items) {
        ArrayList<Item> values = new ArrayList<Item>();
        for (XdmItem xdmItem : items) {
            values.add(xdmItem.getUnderlyingValue());
        }
        this.value = new SequenceExtent(values);
    }

    public XdmValue(XdmSequenceIterator iterator2) throws SaxonApiException {
        try {
            ArrayList<Item> values = new ArrayList<Item>();
            while (iterator2.hasNext()) {
                values.add(iterator2.next().getUnderlyingValue());
            }
            this.value = new SequenceExtent(values);
        }
        catch (SaxonApiUncheckedException e) {
            throw new SaxonApiException(e.getCause());
        }
    }

    protected XdmValue(Sequence value2) {
        this.setValue(value2);
    }

    protected void setValue(Sequence value2) {
        this.value = value2;
    }

    public static XdmValue wrap(Sequence value2) {
        GroundedValue gv;
        if (value2 == null) {
            return XdmEmptySequence.getInstance();
        }
        try {
            gv = SequenceTool.toGroundedValue(value2);
        }
        catch (XPathException e) {
            throw new SaxonApiUncheckedException(e);
        }
        if (gv.getLength() == 0) {
            return XdmEmptySequence.getInstance();
        }
        if (gv.getLength() == 1) {
            Item first = gv.head();
            if (first instanceof NodeInfo) {
                return new XdmNode((NodeInfo)first);
            }
            if (first instanceof AtomicValue) {
                return new XdmAtomicValue((AtomicValue)first);
            }
            if (first instanceof MapItem) {
                return new XdmMap((MapItem)first);
            }
            if (first instanceof ArrayItem) {
                return new XdmArray((ArrayItem)first);
            }
            if (first instanceof Function) {
                return new XdmFunctionItem((Function)first);
            }
            return new XdmExternalObject(((ObjectValue)first).getObject());
        }
        return new XdmValue(gv);
    }

    public XdmValue append(XdmValue otherValue) {
        ArrayList<Item> values = new ArrayList<Item>();
        for (XdmItem item : this) {
            values.add(item.getUnderlyingValue());
        }
        for (XdmItem item : otherValue) {
            values.add(item.getUnderlyingValue());
        }
        return new XdmValue(new SequenceExtent(values));
    }

    public int size() {
        try {
            return SequenceTool.getLength(this.value);
        }
        catch (XPathException err2) {
            throw new SaxonApiUncheckedException(err2);
        }
    }

    public XdmItem itemAt(int n) throws IndexOutOfBoundsException, SaxonApiUncheckedException {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException("" + n);
        }
        try {
            Item item = SequenceTool.itemAt(this.value, n);
            return (XdmItem)XdmItem.wrap(item);
        }
        catch (XPathException e) {
            throw new SaxonApiUncheckedException(e);
        }
    }

    public XdmSequenceIterator iterator() throws SaxonApiUncheckedException {
        try {
            Sequence v = this.getUnderlyingValue();
            return new XdmSequenceIterator(v.iterate());
        }
        catch (XPathException e) {
            throw new SaxonApiUncheckedException(e);
        }
    }

    public Sequence getUnderlyingValue() {
        return this.value;
    }

    public String toString() {
        try {
            Item item;
            Configuration config = null;
            SequenceIterator iter2 = this.value.iterate();
            while ((item = iter2.next()) != null) {
                if (!(item instanceof NodeInfo)) continue;
                config = ((NodeInfo)item).getConfiguration();
                break;
            }
            if (config == null) {
                config = Configuration.newConfiguration();
            }
            StringWriter writer = new StringWriter();
            StreamResult result2 = new StreamResult(writer);
            PipelineConfiguration pipe = config.makePipelineConfiguration();
            Properties properties = new Properties();
            properties.setProperty("method", "adaptive");
            properties.setProperty("indent", "true");
            properties.setProperty("omit-xml-declaration", "true");
            SequenceReceiver r = config.getSerializerFactory().getReceiver(result2, pipe, properties);
            iter2 = this.value.iterate();
            while ((item = iter2.next()) != null) {
                r.append(item);
            }
            return writer.toString();
        }
        catch (XPathException e) {
            return super.toString();
        }
    }

    public static XdmValue makeSequence(Iterable list2) throws IllegalArgumentException {
        ArrayList<Item> result2 = new ArrayList<Item>();
        for (Object o : list2) {
            XdmValue v = XdmValue.makeValue(o);
            if (v instanceof XdmItem) {
                result2.add((Item)v.getUnderlyingValue());
                continue;
            }
            result2.add(new XdmArray(v).getUnderlyingValue());
        }
        return XdmValue.wrap(SequenceExtent.makeSequenceExtent(result2));
    }

    public static XdmValue makeValue(Object o) throws IllegalArgumentException {
        if (o instanceof Sequence) {
            return XdmValue.wrap((Sequence)o);
        }
        if (o instanceof XdmValue) {
            return (XdmValue)o;
        }
        if (o instanceof Map) {
            return XdmMap.makeMap((Map)o);
        }
        if (o instanceof Object[]) {
            return XdmArray.makeArray((Object[])o);
        }
        if (o instanceof Iterable) {
            return XdmValue.makeSequence((Iterable)o);
        }
        return XdmAtomicValue.makeAtomicValue(o);
    }
}

