/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmFunctionItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.value.AtomicValue;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XdmMap
extends XdmFunctionItem
implements Map<XdmAtomicValue, XdmValue> {
    public XdmMap() {
        this.setValue(new HashTrieMap());
    }

    public XdmMap(MapItem map2) {
        super(map2);
    }

    public XdmMap(Map<? extends XdmAtomicValue, ? extends XdmValue> map2) {
        HashTrieMap val = new HashTrieMap();
        for (Map.Entry<? extends XdmAtomicValue, ? extends XdmValue> entry2 : map2.entrySet()) {
            val.initialPut(entry2.getKey().getUnderlyingValue(), entry2.getValue().getUnderlyingValue());
        }
        this.setValue(val);
    }

    @Override
    public MapItem getUnderlyingValue() {
        return (MapItem)super.getUnderlyingValue();
    }

    public int mapSize() {
        return this.getUnderlyingValue().size();
    }

    @Override
    public XdmMap put(XdmAtomicValue key, XdmValue value2) {
        XdmMap map2 = new XdmMap();
        map2.setValue(this.getUnderlyingValue().addEntry(key.getUnderlyingValue(), value2.getUnderlyingValue()));
        return map2;
    }

    public XdmMap remove(XdmAtomicValue key) {
        XdmMap map2 = new XdmMap();
        map2.setValue(this.getUnderlyingValue().remove(key.getUnderlyingValue()));
        return map2;
    }

    @Override
    public Set<XdmAtomicValue> keySet() {
        AtomicValue key;
        HashSet<XdmAtomicValue> result2 = new HashSet<XdmAtomicValue>();
        AtomicIterator iter2 = this.getUnderlyingValue().keys();
        while ((key = iter2.next()) != null) {
            result2.add((XdmAtomicValue)XdmValue.wrap(key));
        }
        return result2;
    }

    @Override
    public Map<XdmAtomicValue, XdmValue> asMap() {
        return new HashMap<XdmAtomicValue, XdmValue>(this);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("XdmMap is immutable");
    }

    @Override
    public boolean isEmpty() {
        return this.getUnderlyingValue().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        AtomicValue k = ((XdmAtomicValue)key).getUnderlyingValue();
        return this.getUnderlyingValue().get(k) != null;
    }

    @Override
    public boolean containsValue(Object value2) {
        throw new UnsupportedOperationException("Not implemented: cannot compare sequences");
    }

    @Override
    public XdmValue get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof XdmAtomicValue)) {
            try {
                key = XdmAtomicValue.makeAtomicValue(key);
            }
            catch (IllegalArgumentException err2) {
                throw new ClassCastException(err2.toString());
            }
        }
        AtomicValue k = ((XdmAtomicValue)key).getUnderlyingValue();
        Sequence v = this.getUnderlyingValue().get(k);
        return v == null ? null : XdmValue.wrap(v);
    }

    @Override
    public XdmValue remove(Object key) {
        throw new UnsupportedOperationException("XdmMap is immutable");
    }

    @Override
    public void putAll(Map<? extends XdmAtomicValue, ? extends XdmValue> m) {
        throw new UnsupportedOperationException("XdmMap is immutable");
    }

    @Override
    @NotNull
    public Collection<XdmValue> values() {
        ArrayList<XdmValue> result2 = new ArrayList<XdmValue>();
        for (KeyValuePair keyValuePair : this.getUnderlyingValue()) {
            result2.add(XdmValue.wrap(keyValuePair.value));
        }
        return result2;
    }

    @Override
    @NotNull
    public Set<Map.Entry<XdmAtomicValue, XdmValue>> entrySet() {
        HashSet<Map.Entry<XdmAtomicValue, XdmValue>> result2 = new HashSet<Map.Entry<XdmAtomicValue, XdmValue>>();
        for (KeyValuePair keyValuePair : this.getUnderlyingValue()) {
            XdmMapEntry entry2 = new XdmMapEntry(keyValuePair);
            result2.add(entry2);
        }
        return result2;
    }

    public static XdmMap makeMap(Map input2) throws IllegalArgumentException {
        HashTrieMap result2 = new HashTrieMap();
        for (Map.Entry entry2 : input2.entrySet()) {
            Object key = entry2.getKey();
            Object value2 = entry2.getValue();
            XdmAtomicValue xKey = XdmAtomicValue.makeAtomicValue(key);
            XdmValue xValue = XdmValue.makeValue(value2);
            result2.initialPut(xKey.getUnderlyingValue(), xValue.getUnderlyingValue());
        }
        return new XdmMap(result2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XdmMapEntry
    implements Map.Entry<XdmAtomicValue, XdmValue> {
        KeyValuePair pair;

        public XdmMapEntry(KeyValuePair pair2) {
            this.pair = pair2;
        }

        @Override
        public XdmAtomicValue getKey() {
            return (XdmAtomicValue)XdmValue.wrap(this.pair.key);
        }

        @Override
        public XdmValue getValue() {
            return XdmValue.wrap(this.pair.value);
        }

        @Override
        public XdmValue setValue(XdmValue value2) {
            throw new UnsupportedOperationException();
        }
    }
}

