/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.StringToDouble11;
import net.sf.saxon.value.StringValue;

public class XdmAtomicValue
extends XdmItem {
    protected XdmAtomicValue(AtomicValue value2) {
        super(value2);
    }

    public XdmAtomicValue(boolean value2) {
        super(BooleanValue.get(value2));
    }

    public XdmAtomicValue(long value2) {
        super(Int64Value.makeDerived(value2, BuiltInAtomicType.LONG));
    }

    public XdmAtomicValue(int value2) {
        super(Int64Value.makeDerived(value2, BuiltInAtomicType.INT));
    }

    public XdmAtomicValue(short value2) {
        super(Int64Value.makeDerived(value2, BuiltInAtomicType.SHORT));
    }

    public XdmAtomicValue(byte value2) {
        super(Int64Value.makeDerived(value2, BuiltInAtomicType.BYTE));
    }

    public XdmAtomicValue(BigDecimal value2) {
        super(new BigDecimalValue(value2));
    }

    public XdmAtomicValue(double value2) {
        super(new DoubleValue(value2));
    }

    public XdmAtomicValue(float value2) {
        super(new FloatValue(value2));
    }

    public XdmAtomicValue(String value2) {
        super(new StringValue(value2));
    }

    public XdmAtomicValue(URI value2) {
        super(new AnyURIValue(value2.toString()));
    }

    public XdmAtomicValue(QName value2) {
        super(new QNameValue(value2.getStructuredQName(), BuiltInAtomicType.QNAME));
    }

    public XdmAtomicValue(String lexicalForm, ItemType type) throws SaxonApiException {
        net.sf.saxon.type.ItemType it = type.getUnderlyingItemType();
        if (!it.isPlainType()) {
            throw new SaxonApiException("Requested type is not atomic");
        }
        if (((AtomicType)it).isAbstract()) {
            throw new SaxonApiException("Requested type is an abstract type");
        }
        if (((AtomicType)it).isNamespaceSensitive()) {
            throw new SaxonApiException("Requested type is namespace-sensitive");
        }
        try {
            StringConverter converter = ((AtomicType)it).getStringConverter(type.getConversionRules());
            this.setValue(converter.convertString(lexicalForm).asAtomic());
        }
        catch (ValidationException e) {
            throw new SaxonApiException(e);
        }
    }

    public static XdmAtomicValue makeAtomicValue(Object value2) {
        if (value2 instanceof AtomicValue) {
            return new XdmAtomicValue((AtomicValue)value2);
        }
        if (value2 instanceof Boolean) {
            return new XdmAtomicValue((Boolean)value2);
        }
        if (value2 instanceof Integer) {
            return new XdmAtomicValue((Integer)value2);
        }
        if (value2 instanceof Long) {
            return new XdmAtomicValue((Long)value2);
        }
        if (value2 instanceof Short) {
            return new XdmAtomicValue((Short)value2);
        }
        if (value2 instanceof Character) {
            return new XdmAtomicValue(((Character)value2).charValue());
        }
        if (value2 instanceof Byte) {
            return new XdmAtomicValue((Byte)value2);
        }
        if (value2 instanceof String) {
            return new XdmAtomicValue((String)value2);
        }
        if (value2 instanceof Double) {
            return new XdmAtomicValue((Double)value2);
        }
        if (value2 instanceof Float) {
            return new XdmAtomicValue(((Float)value2).floatValue());
        }
        if (value2 instanceof BigDecimal) {
            return new XdmAtomicValue((BigDecimal)value2);
        }
        if (value2 instanceof BigInteger) {
            return new XdmAtomicValue(IntegerValue.makeIntegerValue((BigInteger)value2));
        }
        if (value2 instanceof URI) {
            return new XdmAtomicValue((URI)value2);
        }
        if (value2 instanceof QName) {
            return new XdmAtomicValue((QName)value2);
        }
        if (value2 instanceof XdmAtomicValue) {
            return (XdmAtomicValue)value2;
        }
        throw new IllegalArgumentException(value2.toString());
    }

    public AtomicValue getUnderlyingValue() {
        return (AtomicValue)super.getUnderlyingValue();
    }

    public String toString() {
        return this.getStringValue();
    }

    public QName getPrimitiveTypeName() {
        AtomicValue value2 = this.getUnderlyingValue();
        BuiltInAtomicType type = value2.getPrimitiveType();
        return new QName(type.getStructuredQName());
    }

    public QName getTypeName() {
        AtomicValue value2 = this.getUnderlyingValue();
        AtomicType type = value2.getItemType();
        return new QName(type.getStructuredQName());
    }

    public Object getValue() {
        AtomicValue av = this.getUnderlyingValue();
        if (av instanceof StringValue) {
            return av.getStringValue();
        }
        if (av instanceof IntegerValue) {
            return ((IntegerValue)av).asBigInteger();
        }
        if (av instanceof DoubleValue) {
            return ((DoubleValue)av).getDoubleValue();
        }
        if (av instanceof FloatValue) {
            return Float.valueOf(((FloatValue)av).getFloatValue());
        }
        if (av instanceof BooleanValue) {
            return ((BooleanValue)av).getBooleanValue();
        }
        if (av instanceof BigDecimalValue) {
            return ((BigDecimalValue)av).getDecimalValue();
        }
        if (av instanceof QNameValue) {
            QNameValue q = (QNameValue)av;
            return new QName(q.getPrefix(), q.getNamespaceURI(), q.getLocalName());
        }
        return av.getStringValue();
    }

    public boolean getBooleanValue() throws SaxonApiException {
        AtomicValue av = this.getUnderlyingValue();
        if (av instanceof BooleanValue) {
            return ((BooleanValue)av).getBooleanValue();
        }
        if (av instanceof NumericValue) {
            return !av.isNaN() && ((NumericValue)av).signum() != 0;
        }
        if (av instanceof StringValue) {
            String s2 = av.getStringValue().trim();
            return "1".equals(s2) || "true".equals(s2);
        }
        throw new SaxonApiException("Cannot cast item to a boolean");
    }

    public long getLongValue() throws SaxonApiException {
        AtomicValue av = this.getUnderlyingValue();
        if (av instanceof BooleanValue) {
            return ((BooleanValue)av).getBooleanValue() ? 0L : 1L;
        }
        if (av instanceof NumericValue) {
            try {
                return ((NumericValue)av).longValue();
            }
            catch (XPathException e) {
                throw new SaxonApiException("Cannot cast item to an integer");
            }
        }
        if (av instanceof StringValue) {
            StringToDouble converter = StringToDouble.getInstance();
            return (long)converter.stringToNumber(av.getStringValueCS());
        }
        throw new SaxonApiException("Cannot cast item to an integer");
    }

    public double getDoubleValue() throws SaxonApiException {
        AtomicValue av = this.getUnderlyingValue();
        if (av instanceof BooleanValue) {
            return ((BooleanValue)av).getBooleanValue() ? 0.0 : 1.0;
        }
        if (av instanceof NumericValue) {
            return ((NumericValue)av).getDoubleValue();
        }
        if (av instanceof StringValue) {
            try {
                StringToDouble11 converter = StringToDouble11.getInstance();
                return converter.stringToNumber(av.getStringValueCS());
            }
            catch (NumberFormatException e) {
                throw new SaxonApiException(e.getMessage());
            }
        }
        throw new SaxonApiException("Cannot cast item to a double");
    }

    public BigDecimal getDecimalValue() throws SaxonApiException {
        AtomicValue av = this.getUnderlyingValue();
        if (av instanceof BooleanValue) {
            return ((BooleanValue)av).getBooleanValue() ? BigDecimal.ZERO : BigDecimal.ONE;
        }
        if (av instanceof NumericValue) {
            try {
                return ((NumericValue)av).getDecimalValue();
            }
            catch (XPathException e) {
                throw new SaxonApiException("Cannot cast item to a decimal");
            }
        }
        if (av instanceof StringValue) {
            return new BigDecimal(av.getStringValueCS().toString());
        }
        throw new SaxonApiException("Cannot cast item to a decimal");
    }

    public QName getQNameValue() {
        AtomicValue av = this.getUnderlyingValue();
        if (av instanceof QualifiedNameValue) {
            return new QName(((QualifiedNameValue)av).getStructuredQName());
        }
        return null;
    }

    public boolean equals(Object other) {
        if (other instanceof XdmAtomicValue) {
            AtomicMatchKey a = this.getUnderlyingValue().asMapKey();
            AtomicMatchKey b = ((XdmAtomicValue)other).getUnderlyingValue().asMapKey();
            return a.equals(b);
        }
        return false;
    }

    public int hashCode() {
        return this.getUnderlyingValue().asMapKey().hashCode();
    }
}

