/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.ResourceCollection;
import net.sf.saxon.resource.CatalogCollection;
import net.sf.saxon.resource.DirectoryCollection;
import net.sf.saxon.resource.JarCollection;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;

public class StandardCollectionFinder
implements CollectionFinder {
    private Map<String, ResourceCollection> registeredCollections = new HashMap<String, ResourceCollection>(2);

    public void registerCollection(String collectionURI, ResourceCollection collection) {
        this.registeredCollections.put(collectionURI, collection);
    }

    public ResourceCollection findCollection(XPathContext context, String collectionURI) throws XPathException {
        URI resolvedURI;
        if (collectionURI == null) {
            XPathException err2 = new XPathException("No default collection has been defined");
            err2.setErrorCode("FODC0002");
            err2.setXPathContext(context);
            throw err2;
        }
        ResourceCollection registeredCollection = this.registeredCollections.get(collectionURI);
        if (registeredCollection != null) {
            return registeredCollection;
        }
        URIQueryParameters params = null;
        String query = null;
        try {
            URI relativeURI = new URI(ResolveURI.escapeSpaces(collectionURI));
            query = relativeURI.getQuery();
            if (query != null) {
                int q = collectionURI.indexOf(63);
                params = new URIQueryParameters(query, context.getConfiguration());
                collectionURI = ResolveURI.escapeSpaces(collectionURI.substring(0, q));
            }
        }
        catch (URISyntaxException e) {
            XPathException err3 = new XPathException("Invalid relative URI " + Err.wrap(collectionURI, 4) + " passed to collection() function");
            err3.setErrorCode("FODC0004");
            err3.setXPathContext(context);
            throw err3;
        }
        try {
            resolvedURI = new URI(collectionURI);
        }
        catch (URISyntaxException e) {
            throw new XPathException(e);
        }
        if ("file".equals(resolvedURI.getScheme())) {
            File file = new File(resolvedURI);
            if (!file.exists()) {
                XPathException err4 = new XPathException("The file or directory " + resolvedURI + " does not exist");
                err4.setErrorCode("FODC0002");
                err4.setXPathContext(context);
                throw err4;
            }
            if (file.isDirectory()) {
                return new DirectoryCollection(context.getConfiguration(), collectionURI, file, params);
            }
        }
        if (this.isJarFileURI(collectionURI)) {
            return new JarCollection(context, collectionURI, params);
        }
        return new CatalogCollection(context.getConfiguration(), collectionURI);
    }

    protected boolean isJarFileURI(String collectionURI) {
        return collectionURI.endsWith(".jar") || collectionURI.endsWith(".zip") || collectionURI.startsWith("jar:");
    }
}

